/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgradient_wrapper.h"

// Extra includes
#include <QPair>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>

using namespace Shiboken;

static int
SbkQGradient_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGradient* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QGradient()
    cptr = new QGradient();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQGradientFunc_coordinateMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // coordinateMode()const
    QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
    QGradient::CoordinateMode cpp_result = cppSelf->QGradient::coordinateMode();
    py_result = Shiboken::Converter<QGradient::CoordinateMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGradientFunc_interpolationMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // interpolationMode()const
    QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
    QGradient::InterpolationMode cpp_result = cppSelf->QGradient::interpolationMode();
    py_result = Shiboken::Converter<QGradient::InterpolationMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGradientFunc_setColorAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColorAt", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QColor& >::isConvertible(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QColor > cpp_arg1_auto_ptr;
        QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QColor& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
        // setColorAt(qreal,QColor)
        QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
        cppSelf->QGradient::setColorAt(cpp_arg0, *cpp_arg1);
    } else goto SbkQGradientFunc_setColorAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGradientFunc_setColorAt_TypeError:
        const char* overloads[] = {"float, PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGradient.setColorAt", overloads);
        return 0;
}

static PyObject*
SbkQGradientFunc_setCoordinateMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGradient::CoordinateMode >::isConvertible(arg)) {
        QGradient::CoordinateMode cpp_arg0 = Shiboken::Converter<QGradient::CoordinateMode >::toCpp(arg);
        // setCoordinateMode(QGradient::CoordinateMode)
        QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
        cppSelf->QGradient::setCoordinateMode(cpp_arg0);
    } else goto SbkQGradientFunc_setCoordinateMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGradientFunc_setCoordinateMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGradient.CoordinateMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGradient.setCoordinateMode", overloads);
        return 0;
}

static PyObject*
SbkQGradientFunc_setInterpolationMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGradient::InterpolationMode >::isConvertible(arg)) {
        QGradient::InterpolationMode cpp_arg0 = Shiboken::Converter<QGradient::InterpolationMode >::toCpp(arg);
        // setInterpolationMode(QGradient::InterpolationMode)
        QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
        cppSelf->QGradient::setInterpolationMode(cpp_arg0);
    } else goto SbkQGradientFunc_setInterpolationMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGradientFunc_setInterpolationMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGradient.InterpolationMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGradient.setInterpolationMode", overloads);
        return 0;
}

static PyObject*
SbkQGradientFunc_setSpread(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGradient::Spread >::isConvertible(arg)) {
        QGradient::Spread cpp_arg0 = Shiboken::Converter<QGradient::Spread >::toCpp(arg);
        // setSpread(QGradient::Spread)
        QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
        cppSelf->QGradient::setSpread(cpp_arg0);
    } else goto SbkQGradientFunc_setSpread_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGradientFunc_setSpread_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGradient.Spread", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGradient.setSpread", overloads);
        return 0;
}

static PyObject*
SbkQGradientFunc_setStops(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QPair<qreal, QColor > >  >::isConvertible(arg)) {
        QVector<QPair<qreal, QColor > >  cpp_arg0 = Shiboken::Converter<QVector<QPair<qreal, QColor > >  >::toCpp(arg);
        // setStops(QVector<QPair<qreal,QColor> >)
        QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
        cppSelf->QGradient::setStops(cpp_arg0);
    } else goto SbkQGradientFunc_setStops_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGradientFunc_setStops_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGradient.setStops", overloads);
        return 0;
}

static PyObject*
SbkQGradientFunc_spread(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spread()const
    QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
    QGradient::Spread cpp_result = cppSelf->QGradient::spread();
    py_result = Shiboken::Converter<QGradient::Spread >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGradientFunc_stops(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stops()const
    QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
    QVector<QPair<qreal, QColor > > cpp_result = cppSelf->QGradient::stops();
    py_result = Shiboken::Converter<QVector<QPair<qreal, QColor > > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGradientFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QGradient* cppSelf = Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);
    QGradient::Type cpp_result = cppSelf->QGradient::type();
    py_result = Shiboken::Converter<QGradient::Type >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGradient_methods[] = {
    {"coordinateMode", (PyCFunction)SbkQGradientFunc_coordinateMode, METH_NOARGS},
    {"interpolationMode", (PyCFunction)SbkQGradientFunc_interpolationMode, METH_NOARGS},
    {"setColorAt", (PyCFunction)SbkQGradientFunc_setColorAt, METH_VARARGS},
    {"setCoordinateMode", (PyCFunction)SbkQGradientFunc_setCoordinateMode, METH_O},
    {"setInterpolationMode", (PyCFunction)SbkQGradientFunc_setInterpolationMode, METH_O},
    {"setSpread", (PyCFunction)SbkQGradientFunc_setSpread, METH_O},
    {"setStops", (PyCFunction)SbkQGradientFunc_setStops, METH_O},
    {"spread", (PyCFunction)SbkQGradientFunc_spread, METH_NOARGS},
    {"stops", (PyCFunction)SbkQGradientFunc_stops, METH_NOARGS},
    {"type", (PyCFunction)SbkQGradientFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQGradient_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QGradient& cpp_self = *Shiboken::Converter<QGradient* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QGradient& >::isConvertible(other)) {
                QGradient* cpp_other = Shiboken::Converter<QGradient* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQGradient_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QGradient& >::isConvertible(other)) {
                QGradient* cpp_other = Shiboken::Converter<QGradient* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QGradient& >::isConvertible(other)) {
                QGradient* cpp_other = Shiboken::Converter<QGradient* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQGradient_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQGradient_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGradient_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGradient",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGradient >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQGradient_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGradient_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGradient_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QGradient_CoordinateMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGradient_CoordinateMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGradient_CoordinateMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CoordinateMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGradient_CoordinateMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGradient_CoordinateMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGradient_CoordinateMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QGradient_Spread_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGradient_Spread_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGradient_Spread_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Spread",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGradient_Spread_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGradient_Spread_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGradient_Spread_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QGradient_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGradient_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGradient_Type_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGradient_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGradient_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGradient_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QGradient_InterpolationMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGradient_InterpolationMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGradient_InterpolationMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InterpolationMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGradient_InterpolationMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGradient_InterpolationMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGradient_InterpolationMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QGradient(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRADIENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGradient_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQGradient_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGradient_Type));
    PyModule_AddObject(module, "QGradient",
        ((PyObject*)&SbkQGradient_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CoordinateMode
    SbkPySide_QtGuiTypes[SBK_QGRADIENT_COORDINATEMODE_IDX] = &SbkPySide_QtGui_QGradient_CoordinateMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGradient_CoordinateMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGradient_CoordinateMode_Type);
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
            "CoordinateMode",((PyObject*)&SbkPySide_QtGui_QGradient_CoordinateMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_CoordinateMode_Type,
        (long) QGradient::LogicalMode, "LogicalMode");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "LogicalMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_CoordinateMode_Type.tp_dict,
        "LogicalMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_CoordinateMode_Type,
        (long) QGradient::StretchToDeviceMode, "StretchToDeviceMode");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "StretchToDeviceMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_CoordinateMode_Type.tp_dict,
        "StretchToDeviceMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_CoordinateMode_Type,
        (long) QGradient::ObjectBoundingMode, "ObjectBoundingMode");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "ObjectBoundingMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_CoordinateMode_Type.tp_dict,
        "ObjectBoundingMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGradient::CoordinateMode");

    // init enum class: Spread
    SbkPySide_QtGuiTypes[SBK_QGRADIENT_SPREAD_IDX] = &SbkPySide_QtGui_QGradient_Spread_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGradient_Spread_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGradient_Spread_Type);
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
            "Spread",((PyObject*)&SbkPySide_QtGui_QGradient_Spread_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Spread_Type,
        (long) QGradient::PadSpread, "PadSpread");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "PadSpread", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Spread_Type.tp_dict,
        "PadSpread", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Spread_Type,
        (long) QGradient::ReflectSpread, "ReflectSpread");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "ReflectSpread", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Spread_Type.tp_dict,
        "ReflectSpread", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Spread_Type,
        (long) QGradient::RepeatSpread, "RepeatSpread");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "RepeatSpread", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Spread_Type.tp_dict,
        "RepeatSpread", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGradient::Spread");

    // init enum class: Type
    SbkPySide_QtGuiTypes[SBK_QGRADIENT_TYPE_IDX] = &SbkPySide_QtGui_QGradient_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGradient_Type_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGradient_Type_Type);
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkPySide_QtGui_QGradient_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Type_Type,
        (long) QGradient::LinearGradient, "LinearGradient");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "LinearGradient", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Type_Type.tp_dict,
        "LinearGradient", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Type_Type,
        (long) QGradient::RadialGradient, "RadialGradient");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "RadialGradient", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Type_Type.tp_dict,
        "RadialGradient", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Type_Type,
        (long) QGradient::ConicalGradient, "ConicalGradient");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "ConicalGradient", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Type_Type.tp_dict,
        "ConicalGradient", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_Type_Type,
        (long) QGradient::NoGradient, "NoGradient");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "NoGradient", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_Type_Type.tp_dict,
        "NoGradient", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGradient::Type");

    // init enum class: InterpolationMode
    SbkPySide_QtGuiTypes[SBK_QGRADIENT_INTERPOLATIONMODE_IDX] = &SbkPySide_QtGui_QGradient_InterpolationMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGradient_InterpolationMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGradient_InterpolationMode_Type);
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
            "InterpolationMode",((PyObject*)&SbkPySide_QtGui_QGradient_InterpolationMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_InterpolationMode_Type,
        (long) QGradient::ColorInterpolation, "ColorInterpolation");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "ColorInterpolation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_InterpolationMode_Type.tp_dict,
        "ColorInterpolation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGradient_InterpolationMode_Type,
        (long) QGradient::ComponentInterpolation, "ComponentInterpolation");
    PyDict_SetItemString(SbkQGradient_Type.super.ht_type.tp_dict,
        "ComponentInterpolation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGradient_InterpolationMode_Type.tp_dict,
        "ComponentInterpolation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGradient::InterpolationMode");

    Shiboken::TypeResolver::createValueTypeResolver<QGradient >("QGradient");
    Shiboken::TypeResolver::createValueTypeResolver<QGradient >(typeid(QGradient).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

