/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgesturerecognizer_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qgesture.h>
#include <qgesturerecognizer.h>
#include <qobject.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGestureRecognizerWrapper::QGestureRecognizerWrapper() : QGestureRecognizer() {
    // ... middle
}

QGesture * QGestureRecognizerWrapper::create(QObject * target)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "create"));
    if (py_override.isNull()) {
        return this->QGestureRecognizer::create(target);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QObject* >::toPython(target)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QGesture* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGestureRecognizer.create");
        return 0        ;
    }
    QGesture* cpp_result(Shiboken::Converter<QGesture* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QFlags<QGestureRecognizer::ResultFlag> QGestureRecognizerWrapper::recognize(QGesture * state, QObject * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "recognize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGestureRecognizer.recognize()' not implemented.");
        return QFlags<QGestureRecognizer::ResultFlag>();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QGesture* >::toPython(state),
        Shiboken::Converter<QObject* >::toPython(watched),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QGestureRecognizer::ResultFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QGestureRecognizer::ResultFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QGestureRecognizer.recognize");
        return QFlags<QGestureRecognizer::ResultFlag>()        ;
    }
    QFlags<QGestureRecognizer::ResultFlag> cpp_result(Shiboken::Converter<QFlags<QGestureRecognizer::ResultFlag> >::toCpp(py_result));
    return cpp_result;
}

void QGestureRecognizerWrapper::reset(QGesture * state)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QGestureRecognizer::reset(state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QGesture* >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QGestureRecognizerWrapper::~QGestureRecognizerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGestureRecognizer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGestureRecognizerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGestureRecognizer' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QGestureRecognizer()
    cptr = new QGestureRecognizerWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQGestureRecognizerFunc_create(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // create(QObject*)
        QGestureRecognizer* cppSelf = Shiboken::Converter<QGestureRecognizer* >::toCpp((PyObject*)self);
        QGesture * cpp_result = cppSelf->QGestureRecognizer::create(cpp_arg0);
        py_result = Shiboken::Converter<QGesture* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQGestureRecognizerFunc_create_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGestureRecognizerFunc_create_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGestureRecognizer.create", overloads);
        return 0;
}

static PyObject*
SbkQGestureRecognizerFunc_recognize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "recognize", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QGesture* >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject* >::isConvertible(pyargs[1]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGesture* cpp_arg0 = Shiboken::Converter<QGesture* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QEvent* cpp_arg2 = Shiboken::Converter<QEvent* >::toCpp(pyargs[2]);
        // recognize(QGesture*,QObject*,QEvent*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGestureRecognizer.recognize()' not implemented.");
            return 0;
        }
        QGestureRecognizer* cppSelf = Shiboken::Converter<QGestureRecognizer* >::toCpp((PyObject*)self);
        QFlags<QGestureRecognizer::ResultFlag> cpp_result = cppSelf->recognize(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QFlags<QGestureRecognizer::ResultFlag> >::toPython(cpp_result);
    } else goto SbkQGestureRecognizerFunc_recognize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGestureRecognizerFunc_recognize_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGesture, PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGestureRecognizer.recognize", overloads);
        return 0;
}

static PyObject*
SbkQGestureRecognizerFunc_registerRecognizer(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QGestureRecognizer* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGestureRecognizer* cpp_arg0 = Shiboken::Converter<QGestureRecognizer* >::toCpp(arg);
        // registerRecognizer(QGestureRecognizer*)
        Qt::GestureType cpp_result = QGestureRecognizer::registerRecognizer(cpp_arg0);
        py_result = Shiboken::Converter<Qt::GestureType >::toPython(cpp_result);
    } else goto SbkQGestureRecognizerFunc_registerRecognizer_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQGestureRecognizerFunc_registerRecognizer_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGestureRecognizer", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGestureRecognizer.registerRecognizer", overloads);
        return 0;
}

static PyObject*
SbkQGestureRecognizerFunc_reset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGesture* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGesture* cpp_arg0 = Shiboken::Converter<QGesture* >::toCpp(arg);
        // reset(QGesture*)
        QGestureRecognizer* cppSelf = Shiboken::Converter<QGestureRecognizer* >::toCpp((PyObject*)self);
        cppSelf->QGestureRecognizer::reset(cpp_arg0);
    } else goto SbkQGestureRecognizerFunc_reset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGestureRecognizerFunc_reset_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGesture", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGestureRecognizer.reset", overloads);
        return 0;
}

static PyObject*
SbkQGestureRecognizerFunc_unregisterRecognizer(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<Qt::GestureType >::isConvertible(arg)) {
        Qt::GestureType cpp_arg0 = Shiboken::Converter<Qt::GestureType >::toCpp(arg);
        // unregisterRecognizer(Qt::GestureType)
        QGestureRecognizer::unregisterRecognizer(cpp_arg0);
    } else goto SbkQGestureRecognizerFunc_unregisterRecognizer_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGestureRecognizerFunc_unregisterRecognizer_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.GestureType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGestureRecognizer.unregisterRecognizer", overloads);
        return 0;
}

static PyMethodDef SbkQGestureRecognizer_methods[] = {
    {"create", (PyCFunction)SbkQGestureRecognizerFunc_create, METH_O},
    {"recognize", (PyCFunction)SbkQGestureRecognizerFunc_recognize, METH_VARARGS},
    {"registerRecognizer", (PyCFunction)SbkQGestureRecognizerFunc_registerRecognizer, METH_O|METH_STATIC},
    {"reset", (PyCFunction)SbkQGestureRecognizerFunc_reset, METH_O},
    {"unregisterRecognizer", (PyCFunction)SbkQGestureRecognizerFunc_unregisterRecognizer, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGestureRecognizer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGestureRecognizer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGestureRecognizerWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGestureRecognizer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGestureRecognizer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQGestureRecognizer_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQGestureRecognizer_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QGestureRecognizer*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

PyObject*
SbkPySide_QtGui_QGestureRecognizer_ResultFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGestureRecognizer::Result >::toPython(
        ((QGestureRecognizer::Result) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGestureRecognizer::Result >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGestureRecognizer_ResultFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGestureRecognizer::Result >::toPython(
        ((QGestureRecognizer::Result) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGestureRecognizer::Result >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGestureRecognizer_ResultFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGestureRecognizer::Result >::toPython(
        ((QGestureRecognizer::Result) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGestureRecognizer::Result >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGestureRecognizer_ResultFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGestureRecognizer::Result >::toPython(
        ~ Shiboken::Converter< QGestureRecognizer::Result >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QGestureRecognizer_ResultFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QGestureRecognizer_ResultFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QGestureRecognizer_ResultFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QGestureRecognizer_ResultFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QGestureRecognizer_ResultFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QGestureRecognizer_ResultFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGestureRecognizer_ResultFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ResultFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QGestureRecognizer_ResultFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGestureRecognizer_ResultFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGestureRecognizer_ResultFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGestureRecognizer_ResultFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGestureRecognizer_Result_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGestureRecognizer_Result_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Result",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGestureRecognizer_Result_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QGestureRecognizer_Result_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QGestureRecognizer_Result_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QGestureRecognizer(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGestureRecognizer_Type);

    // Fill type discovery information
    SbkQGestureRecognizer_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQGestureRecognizer_Type.type_discovery->addTypeDiscoveryFunction(&SbkQGestureRecognizer_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQGestureRecognizer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGestureRecognizer_Type));
    PyModule_AddObject(module, "QGestureRecognizer",
        ((PyObject*)&SbkQGestureRecognizer_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ResultFlag
    SbkPySide_QtGuiTypes[SBK_QGESTURERECOGNIZER_RESULTFLAG_IDX] = &SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type);
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
            "ResultFlag",((PyObject*)&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type));

    // init flags class: QFlags<QGestureRecognizer::ResultFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QGESTURERECOGNIZER_RESULTFLAG__IDX] = &SbkPySide_QtGui_QGestureRecognizer_Result_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGestureRecognizer_Result_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGestureRecognizer_Result_Type);
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
            "Result",((PyObject*)&SbkPySide_QtGui_QGestureRecognizer_Result_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::Ignore, "Ignore");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "Ignore", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "Ignore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::MayBeGesture, "MayBeGesture");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "MayBeGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "MayBeGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::TriggerGesture, "TriggerGesture");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "TriggerGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "TriggerGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::FinishGesture, "FinishGesture");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "FinishGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "FinishGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::CancelGesture, "CancelGesture");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "CancelGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "CancelGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::ResultState_Mask, "ResultState_Mask");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "ResultState_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "ResultState_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::ConsumeEventHint, "ConsumeEventHint");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "ConsumeEventHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "ConsumeEventHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type,
        (long) QGestureRecognizer::ResultHint_Mask, "ResultHint_Mask");
    PyDict_SetItemString(SbkQGestureRecognizer_Type.super.ht_type.tp_dict,
        "ResultHint_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGestureRecognizer_ResultFlag_Type.tp_dict,
        "ResultHint_Mask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGestureRecognizer::ResultFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QGestureRecognizer >("QGestureRecognizer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGestureRecognizer >(typeid(QGestureRecognizer).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

