/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qformlayout_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFormLayoutWrapper::QFormLayoutWrapper(QWidget * parent) : QFormLayout(parent), m_metaObject(0) {
    // ... middle
}

void QFormLayoutWrapper::addItem(QLayoutItem * item)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addItem"));
    if (py_override.isNull()) {
        return this->QFormLayout::addItem(item);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QLayoutItem* >::toPython(item)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFormLayoutWrapper::childEvent(QChildEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFormLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QFormLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QFormLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.count");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QFormLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFormLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFormLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFormLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::Orientation> QFormLayoutWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        return this->QFormLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.expandingDirections");
        return QFlags<Qt::Orientation>()        ;
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QFormLayoutWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        return this->QLayout::geometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.geometry");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QFormLayoutWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QFormLayout::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.hasHeightForWidth");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QFormLayoutWrapper::heightForWidth(int width) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QFormLayout::heightForWidth(width);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        width
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QFormLayoutWrapper::indexOf(QWidget * arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexOf"));
    if (py_override.isNull()) {
        return this->QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.indexOf");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QFormLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QFormLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFormLayoutWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        return this->QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.isEmpty");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QFormLayoutWrapper::itemAt(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QFormLayout::itemAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.itemAt");
        return 0        ;
    }
    QLayoutItem* cpp_result(Shiboken::Converter<QLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayout * QFormLayoutWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayout::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.layout");
        return 0        ;
    }
    QLayout* cpp_result(Shiboken::Converter<QLayout* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QSize QFormLayoutWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        return this->QLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.maximumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QFormLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.minimumHeightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QFormLayoutWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        return this->QFormLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.minimumSize");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QFormLayoutWrapper::setGeometry(const QRect & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QFormLayout::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QRect& >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QFormLayoutWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QFormLayout::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QFormLayoutWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.spacerItem");
        return 0        ;
    }
    QSpacerItem* cpp_result(Shiboken::Converter<QSpacerItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QLayoutItem * QFormLayoutWrapper::takeAt(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "takeAt"));
    if (py_override.isNull()) {
        return this->QFormLayout::takeAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.takeAt");
        return 0        ;
    }
    QLayoutItem* cpp_result(Shiboken::Converter<QLayoutItem* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QFormLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QFormLayoutWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFormLayout.widget");
        return 0        ;
    }
    QWidget* cpp_result(Shiboken::Converter<QWidget* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

const QMetaObject* QFormLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QFormLayout::staticMetaObject);
}
    return m_metaObject;
}

int QFormLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QFormLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QFormLayoutWrapper::~QFormLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQFormLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFormLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QFormLayout", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QFormLayout(QWidget*)
        cptr = new QFormLayoutWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QFormLayout(QWidget*)
        cptr = new QFormLayoutWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQFormLayout_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFormLayout_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQFormLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFormLayout", overloads);
        return -1;
}

static PyObject*
SbkQFormLayoutFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayoutItem* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayoutItem* cpp_arg0 = Shiboken::Converter<QLayoutItem* >::toCpp(arg);
        // addItem(QLayoutItem*)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::addItem(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQFormLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.addItem", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_addRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addRow", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // addRow(QString,QWidget*)
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            cppSelf->QFormLayout::addRow(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[1]);
        } else if (numArgs == 2 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QLayout* cpp_arg1 = Shiboken::Converter<QLayout* >::toCpp(pyargs[1]);
            // addRow(QString,QLayout*)
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            cppSelf->QFormLayout::addRow(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQFormLayoutFunc_addRow_TypeError;
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addRow(QWidget*)
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            cppSelf->QFormLayout::addRow(cpp_arg0);
            Shiboken::setParent(self, pyargs[0]);
        } else if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // addRow(QWidget*,QWidget*)
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            cppSelf->QFormLayout::addRow(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[0]);
            Shiboken::setParent(self, pyargs[1]);
        } else if (numArgs == 2 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QLayout* cpp_arg1 = Shiboken::Converter<QLayout* >::toCpp(pyargs[1]);
            // addRow(QWidget*,QLayout*)
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            cppSelf->QFormLayout::addRow(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[0]);
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQFormLayoutFunc_addRow_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(pyargs[0]);
        // addRow(QLayout*)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::addRow(cpp_arg0);
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQFormLayoutFunc_addRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_addRow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout", "PySide.QtGui.QWidget, PySide.QtGui.QLayout", "PySide.QtGui.QWidget, PySide.QtGui.QWidget", "PySide.QtGui.QWidget", "PySide.QtCore.QString, PySide.QtGui.QLayout", "PySide.QtCore.QString, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFormLayout.addRow", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFormLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->QFormLayout::expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_fieldGrowthPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fieldGrowthPolicy()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QFormLayout::FieldGrowthPolicy cpp_result = cppSelf->QFormLayout::fieldGrowthPolicy();
    py_result = Shiboken::Converter<QFormLayout::FieldGrowthPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_formAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // formAlignment()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QFormLayout::formAlignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_hasHeightForWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasHeightForWidth()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFormLayout::hasHeightForWidth();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_heightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // heightForWidth(int)const
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFormLayout::heightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQFormLayoutFunc_heightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFormLayoutFunc_heightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.heightForWidth", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_horizontalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalSpacing()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFormLayout::horizontalSpacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_insertRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertRow", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // insertRow(int,QString,QWidget*)
                QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
                cppSelf->QFormLayout::insertRow(cpp_arg0, *cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[2]);
            } else if (numArgs == 3 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QLayout* cpp_arg2 = Shiboken::Converter<QLayout* >::toCpp(pyargs[2]);
                // insertRow(int,QString,QLayout*)
                QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
                cppSelf->QFormLayout::insertRow(cpp_arg0, *cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[2]);
            } else goto SbkQFormLayoutFunc_insertRow_TypeError;
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // insertRow(int,QWidget*)
                QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
                cppSelf->QFormLayout::insertRow(cpp_arg0, cpp_arg1);
                Shiboken::setParent(self, pyargs[1]);
            } else if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // insertRow(int,QWidget*,QWidget*)
                QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
                cppSelf->QFormLayout::insertRow(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[1]);
                Shiboken::setParent(self, pyargs[2]);
            } else if (numArgs == 3 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QLayout* cpp_arg2 = Shiboken::Converter<QLayout* >::toCpp(pyargs[2]);
                // insertRow(int,QWidget*,QLayout*)
                QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
                cppSelf->QFormLayout::insertRow(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(self, pyargs[1]);
                Shiboken::setParent(self, pyargs[2]);
            } else goto SbkQFormLayoutFunc_insertRow_TypeError;
        } else if (numArgs == 2 && Shiboken::Converter<QLayout* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QLayout* cpp_arg1 = Shiboken::Converter<QLayout* >::toCpp(pyargs[1]);
            // insertRow(int,QLayout*)
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            cppSelf->QFormLayout::insertRow(cpp_arg0, cpp_arg1);
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQFormLayoutFunc_insertRow_TypeError;
    } else goto SbkQFormLayoutFunc_insertRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_insertRow_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QLayout", "int, PySide.QtGui.QWidget, PySide.QtGui.QLayout", "int, PySide.QtGui.QWidget, PySide.QtGui.QWidget", "int, PySide.QtGui.QWidget", "int, PySide.QtCore.QString, PySide.QtGui.QLayout", "int, PySide.QtCore.QString, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFormLayout.insertRow", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    cppSelf->QFormLayout::invalidate();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQFormLayoutFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // itemAt(int)const
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            QLayoutItem * cpp_result = cppSelf->QFormLayout::itemAt(cpp_arg0);
            py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else if (numArgs == 2 && Shiboken::Converter<QFormLayout::ItemRole >::isConvertible(pyargs[1])) {
            QFormLayout::ItemRole cpp_arg1 = Shiboken::Converter<QFormLayout::ItemRole >::toCpp(pyargs[1]);
            // itemAt(int,QFormLayout::ItemRole)const
            QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
            QLayoutItem * cpp_result = cppSelf->QFormLayout::itemAt(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
            Shiboken::setParent(self, py_result);
        } else goto SbkQFormLayoutFunc_itemAt_TypeError;
    } else goto SbkQFormLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFormLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtGui.QFormLayout.ItemRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFormLayout.itemAt", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_labelAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // labelAlignment()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QFormLayout::labelAlignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_labelForField(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // labelForField(QWidget*)const
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QFormLayout::labelForField(cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QLayout* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(arg);
        // labelForField(QLayout*)const
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QFormLayout::labelForField(cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQFormLayoutFunc_labelForField_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFormLayoutFunc_labelForField_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.labelForField", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QFormLayout::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_rowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowCount()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFormLayout::rowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_rowWrapPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowWrapPolicy()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QFormLayout::RowWrapPolicy cpp_result = cppSelf->QFormLayout::rowWrapPolicy();
    py_result = Shiboken::Converter<QFormLayout::RowWrapPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_setFieldGrowthPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFormLayout::FieldGrowthPolicy >::isConvertible(arg)) {
        QFormLayout::FieldGrowthPolicy cpp_arg0 = Shiboken::Converter<QFormLayout::FieldGrowthPolicy >::toCpp(arg);
        // setFieldGrowthPolicy(QFormLayout::FieldGrowthPolicy)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setFieldGrowthPolicy(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setFieldGrowthPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setFieldGrowthPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFormLayout.FieldGrowthPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setFieldGrowthPolicy", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setFormAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setFormAlignment(QFlags<Qt::AlignmentFlag>)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setFormAlignment(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setFormAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setFormAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setFormAlignment", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setGeometry(*cpp_arg0);
    } else goto SbkQFormLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setGeometry", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setHorizontalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setHorizontalSpacing(int)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setHorizontalSpacing(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setHorizontalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setHorizontalSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setHorizontalSpacing", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setLabelAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setLabelAlignment(QFlags<Qt::AlignmentFlag>)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setLabelAlignment(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setLabelAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setLabelAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setLabelAlignment", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setLayout(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setLayout", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QFormLayout::ItemRole >::isConvertible(pyargs[1]) && Shiboken::Converter<QLayout* >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QFormLayout::ItemRole cpp_arg1 = Shiboken::Converter<QFormLayout::ItemRole >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QLayout* cpp_arg2 = Shiboken::Converter<QLayout* >::toCpp(pyargs[2]);
        // setLayout(int,QFormLayout::ItemRole,QLayout*)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setLayout(cpp_arg0, cpp_arg1, cpp_arg2);
        Shiboken::setParent(self, pyargs[2]);
    } else goto SbkQFormLayoutFunc_setLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setLayout_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QFormLayout.ItemRole, PySide.QtGui.QLayout", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFormLayout.setLayout", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setRowWrapPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFormLayout::RowWrapPolicy >::isConvertible(arg)) {
        QFormLayout::RowWrapPolicy cpp_arg0 = Shiboken::Converter<QFormLayout::RowWrapPolicy >::toCpp(arg);
        // setRowWrapPolicy(QFormLayout::RowWrapPolicy)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setRowWrapPolicy(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setRowWrapPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setRowWrapPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFormLayout.RowWrapPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setRowWrapPolicy", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSpacing(int)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setSpacing(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setSpacing", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setVerticalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setVerticalSpacing(int)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setVerticalSpacing(cpp_arg0);
    } else goto SbkQFormLayoutFunc_setVerticalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setVerticalSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.setVerticalSpacing", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_setWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setWidget", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QFormLayout::ItemRole >::isConvertible(pyargs[1]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QFormLayout::ItemRole cpp_arg1 = Shiboken::Converter<QFormLayout::ItemRole >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        // setWidget(int,QFormLayout::ItemRole,QWidget*)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        cppSelf->QFormLayout::setWidget(cpp_arg0, cpp_arg1, cpp_arg2);
        Shiboken::setParent(self, pyargs[2]);
    } else goto SbkQFormLayoutFunc_setWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFormLayoutFunc_setWidget_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QFormLayout.ItemRole, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFormLayout.setWidget", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QFormLayout::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_spacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacing()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFormLayout::spacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFormLayoutFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QFormLayout::takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem* >::toPython(cpp_result);
        Shiboken::setParent(self, 0);
        Shiboken::setParent(self, py_result);
    } else goto SbkQFormLayoutFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFormLayoutFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFormLayout.takeAt", overloads);
        return 0;
}

static PyObject*
SbkQFormLayoutFunc_verticalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalSpacing()const
    QFormLayout* cppSelf = Shiboken::Converter<QFormLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFormLayout::verticalSpacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQFormLayout_methods[] = {
    {"addItem", (PyCFunction)SbkQFormLayoutFunc_addItem, METH_O},
    {"addRow", (PyCFunction)SbkQFormLayoutFunc_addRow, METH_VARARGS},
    {"count", (PyCFunction)SbkQFormLayoutFunc_count, METH_NOARGS},
    {"expandingDirections", (PyCFunction)SbkQFormLayoutFunc_expandingDirections, METH_NOARGS},
    {"fieldGrowthPolicy", (PyCFunction)SbkQFormLayoutFunc_fieldGrowthPolicy, METH_NOARGS},
    {"formAlignment", (PyCFunction)SbkQFormLayoutFunc_formAlignment, METH_NOARGS},
    {"hasHeightForWidth", (PyCFunction)SbkQFormLayoutFunc_hasHeightForWidth, METH_NOARGS},
    {"heightForWidth", (PyCFunction)SbkQFormLayoutFunc_heightForWidth, METH_O},
    {"horizontalSpacing", (PyCFunction)SbkQFormLayoutFunc_horizontalSpacing, METH_NOARGS},
    {"insertRow", (PyCFunction)SbkQFormLayoutFunc_insertRow, METH_VARARGS},
    {"invalidate", (PyCFunction)SbkQFormLayoutFunc_invalidate, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQFormLayoutFunc_itemAt, METH_VARARGS},
    {"labelAlignment", (PyCFunction)SbkQFormLayoutFunc_labelAlignment, METH_NOARGS},
    {"labelForField", (PyCFunction)SbkQFormLayoutFunc_labelForField, METH_O},
    {"minimumSize", (PyCFunction)SbkQFormLayoutFunc_minimumSize, METH_NOARGS},
    {"rowCount", (PyCFunction)SbkQFormLayoutFunc_rowCount, METH_NOARGS},
    {"rowWrapPolicy", (PyCFunction)SbkQFormLayoutFunc_rowWrapPolicy, METH_NOARGS},
    {"setFieldGrowthPolicy", (PyCFunction)SbkQFormLayoutFunc_setFieldGrowthPolicy, METH_O},
    {"setFormAlignment", (PyCFunction)SbkQFormLayoutFunc_setFormAlignment, METH_O},
    {"setGeometry", (PyCFunction)SbkQFormLayoutFunc_setGeometry, METH_O},
    {"setHorizontalSpacing", (PyCFunction)SbkQFormLayoutFunc_setHorizontalSpacing, METH_O},
    {"setLabelAlignment", (PyCFunction)SbkQFormLayoutFunc_setLabelAlignment, METH_O},
    {"setLayout", (PyCFunction)SbkQFormLayoutFunc_setLayout, METH_VARARGS},
    {"setRowWrapPolicy", (PyCFunction)SbkQFormLayoutFunc_setRowWrapPolicy, METH_O},
    {"setSpacing", (PyCFunction)SbkQFormLayoutFunc_setSpacing, METH_O},
    {"setVerticalSpacing", (PyCFunction)SbkQFormLayoutFunc_setVerticalSpacing, METH_O},
    {"setWidget", (PyCFunction)SbkQFormLayoutFunc_setWidget, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQFormLayoutFunc_sizeHint, METH_NOARGS},
    {"spacing", (PyCFunction)SbkQFormLayoutFunc_spacing, METH_NOARGS},
    {"takeAt", (PyCFunction)SbkQFormLayoutFunc_takeAt, METH_O},
    {"verticalSpacing", (PyCFunction)SbkQFormLayoutFunc_verticalSpacing, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQFormLayoutSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QFormLayout* me = reinterpret_cast<QFormLayout*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX]))
        return static_cast<QLayout*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast<QLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFormLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFormLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QFormLayoutWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFormLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFormLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQFormLayoutSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FieldGrowthPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFormLayout_RowWrapPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFormLayout_RowWrapPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RowWrapPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFormLayout_RowWrapPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFormLayout_RowWrapPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFormLayout_RowWrapPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFormLayout_ItemRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFormLayout_ItemRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFormLayout_ItemRole_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFormLayout_ItemRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFormLayout_ItemRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFormLayout_ItemRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QFormLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFormLayout_Type);

    SbkQFormLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX];
    SbkQFormLayout_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX])->mi_init;

    // Fill type discovery information
    SbkQFormLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFormLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFormLayout_Type));
    PyModule_AddObject(module, "QFormLayout",
        ((PyObject*)&SbkQFormLayout_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FieldGrowthPolicy
    SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_FIELDGROWTHPOLICY_IDX] = &SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type);
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
            "FieldGrowthPolicy",((PyObject*)&SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type,
        (long) QFormLayout::FieldsStayAtSizeHint, "FieldsStayAtSizeHint");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "FieldsStayAtSizeHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type.tp_dict,
        "FieldsStayAtSizeHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type,
        (long) QFormLayout::ExpandingFieldsGrow, "ExpandingFieldsGrow");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "ExpandingFieldsGrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type.tp_dict,
        "ExpandingFieldsGrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type,
        (long) QFormLayout::AllNonFixedFieldsGrow, "AllNonFixedFieldsGrow");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "AllNonFixedFieldsGrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_FieldGrowthPolicy_Type.tp_dict,
        "AllNonFixedFieldsGrow", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFormLayout::FieldGrowthPolicy");

    // init enum class: RowWrapPolicy
    SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_ROWWRAPPOLICY_IDX] = &SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type);
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
            "RowWrapPolicy",((PyObject*)&SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type,
        (long) QFormLayout::DontWrapRows, "DontWrapRows");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "DontWrapRows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type.tp_dict,
        "DontWrapRows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type,
        (long) QFormLayout::WrapLongRows, "WrapLongRows");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "WrapLongRows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type.tp_dict,
        "WrapLongRows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type,
        (long) QFormLayout::WrapAllRows, "WrapAllRows");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "WrapAllRows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_RowWrapPolicy_Type.tp_dict,
        "WrapAllRows", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFormLayout::RowWrapPolicy");

    // init enum class: ItemRole
    SbkPySide_QtGuiTypes[SBK_QFORMLAYOUT_ITEMROLE_IDX] = &SbkPySide_QtGui_QFormLayout_ItemRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFormLayout_ItemRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFormLayout_ItemRole_Type);
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
            "ItemRole",((PyObject*)&SbkPySide_QtGui_QFormLayout_ItemRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_ItemRole_Type,
        (long) QFormLayout::LabelRole, "LabelRole");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "LabelRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_ItemRole_Type.tp_dict,
        "LabelRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_ItemRole_Type,
        (long) QFormLayout::FieldRole, "FieldRole");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "FieldRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_ItemRole_Type.tp_dict,
        "FieldRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFormLayout_ItemRole_Type,
        (long) QFormLayout::SpanningRole, "SpanningRole");
    PyDict_SetItemString(SbkQFormLayout_Type.super.ht_type.tp_dict,
        "SpanningRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFormLayout_ItemRole_Type.tp_dict,
        "SpanningRole", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFormLayout::ItemRole");

    Shiboken::TypeResolver::createObjectTypeResolver<QFormLayout >("QFormLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFormLayout >(typeid(QFormLayout).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

