/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qfiledialog_wrapper.h"

// Extra includes
#include <QAbstractProxyModel>
#include <QList>
#include <QUrl>
#include <qabstractitemdelegate.h>
#include <qabstractproxymodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qdir.h>
#include <qevent.h>
#include <qfiledialog.h>
#include <qfileiconprovider.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFileDialogWrapper::QFileDialogWrapper(QWidget * parent, QFlags<Qt::WindowType> f) : QFileDialog(parent, f), m_metaObject(0) {
    // ... middle
}

QFileDialogWrapper::QFileDialogWrapper(QWidget * parent, const QString & caption, const QString & directory, const QString & filter) : QFileDialog(parent, caption, directory, filter), m_metaObject(0) {
    // ... middle
}

void QFileDialogWrapper::accept()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "accept"));
    if (py_override.isNull()) {
        return this->QFileDialog::accept();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::changeEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFileDialog::changeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QDialog::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QDialog::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QFileDialogWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::done(int result)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "done"));
    if (py_override.isNull()) {
        return this->QFileDialog::done(result);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        result
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QFileDialogWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QWidget::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFileDialogWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QDialog::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QFileDialogWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QFileDialogWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QFileDialogWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QDialog::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QFileDialogWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QFileDialogWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QDialog::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QFileDialogWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QFileDialogWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::reject()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reject"));
    if (py_override.isNull()) {
        return this->QDialog::reject();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QDialog::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QFileDialog::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QDialog::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QFileDialogWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QDialog::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileDialog.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QFileDialogWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileDialogWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileDialogWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QFileDialogWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QFileDialog::staticMetaObject);
}
    return m_metaObject;
}

int QFileDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QFileDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QFileDialogWrapper::~QFileDialogWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQFileDialog_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFileDialogWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QFileDialog", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QFileDialog(QWidget*,QString,QString,QString)
        cptr = new QFileDialogWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QFileDialog(QWidget*,QString,QString,QString)
            cptr = new QFileDialogWrapper(cpp_arg0);
            Shiboken::setParent(pyargs[0], self);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QFileDialog(QWidget*,QString,QString,QString)
                cptr = new QFileDialogWrapper(cpp_arg0, *cpp_arg1);
                Shiboken::setParent(pyargs[0], self);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                if (numArgs == 3) {
                    // QFileDialog(QWidget*,QString,QString,QString)
                    cptr = new QFileDialogWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2);
                    Shiboken::setParent(pyargs[0], self);
                } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return -1;
                    std::auto_ptr<QString > cpp_arg3_auto_ptr;
                    QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                    // QFileDialog(QWidget*,QString,QString,QString)
                    cptr = new QFileDialogWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                    Shiboken::setParent(pyargs[0], self);
                } else goto SbkQFileDialog_Init_TypeError;
            } else goto SbkQFileDialog_Init_TypeError;
        } else if (numArgs == 2 && SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QFileDialog(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QFileDialogWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQFileDialog_Init_TypeError;
    } else goto SbkQFileDialog_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFileDialog_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQFileDialog_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.WindowFlags", "PySide.QtGui.QWidget = None, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog", overloads);
        return -1;
}

static PyObject*
SbkQFileDialogFunc_accept(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // accept()
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    cppSelf->QFileDialog::accept();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQFileDialogFunc_acceptMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // acceptMode()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QFileDialog::AcceptMode cpp_result = cppSelf->QFileDialog::acceptMode();
    py_result = Shiboken::Converter<QFileDialog::AcceptMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::changeEvent(cpp_arg0);
    } else goto SbkQFileDialogFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_confirmOverwrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // confirmOverwrite()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileDialog::confirmOverwrite();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_defaultSuffix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultSuffix()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileDialog::defaultSuffix();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_directory(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // directory()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QDir cpp_result = cppSelf->QFileDialog::directory();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_done(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // done(int)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::done(cpp_arg0);
    } else goto SbkQFileDialogFunc_done_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_done_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.done", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_fileMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileMode()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QFileDialog::FileMode cpp_result = cppSelf->QFileDialog::fileMode();
    py_result = Shiboken::Converter<QFileDialog::FileMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_filter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filter()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QFlags<QDir::Filter> cpp_result = cppSelf->QFileDialog::filter();
    py_result = Shiboken::Converter<QFlags<QDir::Filter> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_filters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filters()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QFileDialog::filters();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_getExistingDirectory(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getExistingDirectory", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
        thread_state_saver.save();
        QString cpp_result = QFileDialog::getExistingDirectory();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            thread_state_saver.save();
            QString cpp_result = QFileDialog::getExistingDirectory(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                thread_state_saver.save();
                QString cpp_result = QFileDialog::getExistingDirectory(cpp_arg0, *cpp_arg1);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                if (numArgs == 3) {
                    // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                    thread_state_saver.save();
                    QString cpp_result = QFileDialog::getExistingDirectory(cpp_arg0, *cpp_arg1, *cpp_arg2);
                    thread_state_saver.restore();
                    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                } else if (SbkPySide_QtGui_QFileDialog_Option_Check(pyargs[3])) {
                    QFlags<QFileDialog::Option> cpp_arg3 = Shiboken::Converter<QFlags<QFileDialog::Option> >::toCpp(pyargs[3]);
                    // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                    thread_state_saver.save();
                    QString cpp_result = QFileDialog::getExistingDirectory(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                    thread_state_saver.restore();
                    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                } else goto SbkQFileDialogFunc_getExistingDirectory_TypeError;
            } else goto SbkQFileDialogFunc_getExistingDirectory_TypeError;
        } else goto SbkQFileDialogFunc_getExistingDirectory_TypeError;
    } else goto SbkQFileDialogFunc_getExistingDirectory_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_getExistingDirectory_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtGui.QFileDialog.Options = QFileDialog.ShowDirsOnly", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.getExistingDirectory", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_getOpenFileName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getOpenFileName", 0, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 0) {
        // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        thread_state_saver.save();
        QString cpp_result = QFileDialog::getOpenFileName();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            thread_state_saver.save();
            QString cpp_result = QFileDialog::getOpenFileName(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                thread_state_saver.save();
                QString cpp_result = QFileDialog::getOpenFileName(cpp_arg0, *cpp_arg1);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                if (numArgs == 3) {
                    // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    thread_state_saver.save();
                    QString cpp_result = QFileDialog::getOpenFileName(cpp_arg0, *cpp_arg1, *cpp_arg2);
                    thread_state_saver.restore();
                    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    std::auto_ptr<QString > cpp_arg3_auto_ptr;
                    QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                    if (numArgs == 4) {
                        // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        thread_state_saver.save();
                        QString cpp_result = QFileDialog::getOpenFileName(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                        thread_state_saver.restore();
                        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                    } else if (Shiboken::Converter<QString* >::isConvertible(pyargs[4])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                            return 0;
                        std::auto_ptr<QString > cpp_arg4_auto_ptr;
                        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
                        if (!Shiboken::Converter<QString* >::isConvertible(pyargs[4]))
                            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
                        if (numArgs == 5) {
                            // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            thread_state_saver.save();
                            QString cpp_result = QFileDialog::getOpenFileName(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                        } else if (SbkPySide_QtGui_QFileDialog_Option_Check(pyargs[5])) {
                            QFlags<QFileDialog::Option> cpp_arg5 = Shiboken::Converter<QFlags<QFileDialog::Option> >::toCpp(pyargs[5]);
                            // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            thread_state_saver.save();
                            QString cpp_result = QFileDialog::getOpenFileName(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                        } else goto SbkQFileDialogFunc_getOpenFileName_TypeError;
                    } else goto SbkQFileDialogFunc_getOpenFileName_TypeError;
                } else goto SbkQFileDialogFunc_getOpenFileName_TypeError;
            } else goto SbkQFileDialogFunc_getOpenFileName_TypeError;
        } else goto SbkQFileDialogFunc_getOpenFileName_TypeError;
    } else goto SbkQFileDialogFunc_getOpenFileName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_getOpenFileName_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = None, PySide.QtGui.QFileDialog.Options = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.getOpenFileName", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_getOpenFileNames(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getOpenFileNames", 0, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 0) {
        // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        thread_state_saver.save();
        QStringList cpp_result = QFileDialog::getOpenFileNames();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            thread_state_saver.save();
            QStringList cpp_result = QFileDialog::getOpenFileNames(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                thread_state_saver.save();
                QStringList cpp_result = QFileDialog::getOpenFileNames(cpp_arg0, *cpp_arg1);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                if (numArgs == 3) {
                    // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    thread_state_saver.save();
                    QStringList cpp_result = QFileDialog::getOpenFileNames(cpp_arg0, *cpp_arg1, *cpp_arg2);
                    thread_state_saver.restore();
                    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
                } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    std::auto_ptr<QString > cpp_arg3_auto_ptr;
                    QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                    if (numArgs == 4) {
                        // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        thread_state_saver.save();
                        QStringList cpp_result = QFileDialog::getOpenFileNames(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                        thread_state_saver.restore();
                        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
                    } else if (Shiboken::Converter<QString* >::isConvertible(pyargs[4])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                            return 0;
                        std::auto_ptr<QString > cpp_arg4_auto_ptr;
                        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
                        if (!Shiboken::Converter<QString* >::isConvertible(pyargs[4]))
                            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
                        if (numArgs == 5) {
                            // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            thread_state_saver.save();
                            QStringList cpp_result = QFileDialog::getOpenFileNames(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
                        } else if (SbkPySide_QtGui_QFileDialog_Option_Check(pyargs[5])) {
                            QFlags<QFileDialog::Option> cpp_arg5 = Shiboken::Converter<QFlags<QFileDialog::Option> >::toCpp(pyargs[5]);
                            // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            thread_state_saver.save();
                            QStringList cpp_result = QFileDialog::getOpenFileNames(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
                        } else goto SbkQFileDialogFunc_getOpenFileNames_TypeError;
                    } else goto SbkQFileDialogFunc_getOpenFileNames_TypeError;
                } else goto SbkQFileDialogFunc_getOpenFileNames_TypeError;
            } else goto SbkQFileDialogFunc_getOpenFileNames_TypeError;
        } else goto SbkQFileDialogFunc_getOpenFileNames_TypeError;
    } else goto SbkQFileDialogFunc_getOpenFileNames_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_getOpenFileNames_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = None, PySide.QtGui.QFileDialog.Options = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.getOpenFileNames", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_getSaveFileName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getSaveFileName", 0, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 0) {
        // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        thread_state_saver.save();
        QString cpp_result = QFileDialog::getSaveFileName();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            thread_state_saver.save();
            QString cpp_result = QFileDialog::getSaveFileName(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                thread_state_saver.save();
                QString cpp_result = QFileDialog::getSaveFileName(cpp_arg0, *cpp_arg1);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                if (numArgs == 3) {
                    // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    thread_state_saver.save();
                    QString cpp_result = QFileDialog::getSaveFileName(cpp_arg0, *cpp_arg1, *cpp_arg2);
                    thread_state_saver.restore();
                    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    std::auto_ptr<QString > cpp_arg3_auto_ptr;
                    QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                    if (numArgs == 4) {
                        // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        thread_state_saver.save();
                        QString cpp_result = QFileDialog::getSaveFileName(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                        thread_state_saver.restore();
                        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                    } else if (Shiboken::Converter<QString* >::isConvertible(pyargs[4])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                            return 0;
                        std::auto_ptr<QString > cpp_arg4_auto_ptr;
                        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
                        if (!Shiboken::Converter<QString* >::isConvertible(pyargs[4]))
                            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
                        if (numArgs == 5) {
                            // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            thread_state_saver.save();
                            QString cpp_result = QFileDialog::getSaveFileName(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                        } else if (SbkPySide_QtGui_QFileDialog_Option_Check(pyargs[5])) {
                            QFlags<QFileDialog::Option> cpp_arg5 = Shiboken::Converter<QFlags<QFileDialog::Option> >::toCpp(pyargs[5]);
                            // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            thread_state_saver.save();
                            QString cpp_result = QFileDialog::getSaveFileName(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                        } else goto SbkQFileDialogFunc_getSaveFileName_TypeError;
                    } else goto SbkQFileDialogFunc_getSaveFileName_TypeError;
                } else goto SbkQFileDialogFunc_getSaveFileName_TypeError;
            } else goto SbkQFileDialogFunc_getSaveFileName_TypeError;
        } else goto SbkQFileDialogFunc_getSaveFileName_TypeError;
    } else goto SbkQFileDialogFunc_getSaveFileName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_getSaveFileName_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = None, PySide.QtGui.QFileDialog.Options = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.getSaveFileName", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_history(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // history()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QFileDialog::history();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_iconProvider(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconProvider()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QFileIconProvider * cpp_result = cppSelf->QFileDialog::iconProvider();
    py_result = Shiboken::Converter<QFileIconProvider* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_isNameFilterDetailsVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNameFilterDetailsVisible()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileDialog::isNameFilterDetailsVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_isReadOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadOnly()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileDialog::isReadOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_itemDelegate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemDelegate()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QAbstractItemDelegate * cpp_result = cppSelf->QFileDialog::itemDelegate();
    py_result = Shiboken::Converter<QAbstractItemDelegate* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_labelText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFileDialog::DialogLabel >::isConvertible(arg)) {
        QFileDialog::DialogLabel cpp_arg0 = Shiboken::Converter<QFileDialog::DialogLabel >::toCpp(arg);
        // labelText(QFileDialog::DialogLabel)const
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFileDialog::labelText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFileDialogFunc_labelText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_labelText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.DialogLabel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.labelText", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_nameFilters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nameFilters()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QFileDialog::nameFilters();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_open(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQFileDialogFunc_open_TypeError;

    if (!PyArg_UnpackTuple(args, "open", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // open()
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::open();
    } else if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        // open(QObject*,const char*)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::open(cpp_arg0, cpp_arg1);
    } else goto SbkQFileDialogFunc_open_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_open_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.open", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_options(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // options()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QFlags<QFileDialog::Option> cpp_result = cppSelf->QFileDialog::options();
    py_result = Shiboken::Converter<QFlags<QFileDialog::Option> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_proxyModel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proxyModel()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QAbstractProxyModel * cpp_result = cppSelf->QFileDialog::proxyModel();
    py_result = Shiboken::Converter<QAbstractProxyModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_resolveSymlinks(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // resolveSymlinks()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileDialog::resolveSymlinks();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_restoreState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // restoreState(QByteArray)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFileDialog::restoreState(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFileDialogFunc_restoreState_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_restoreState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.restoreState", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_saveState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // saveState()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QFileDialog::saveState();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_selectFile(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // selectFile(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::selectFile(*cpp_arg0);
    } else goto SbkQFileDialogFunc_selectFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_selectFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.selectFile", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_selectFilter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // selectFilter(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::selectFilter(*cpp_arg0);
    } else goto SbkQFileDialogFunc_selectFilter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_selectFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.selectFilter", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_selectNameFilter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // selectNameFilter(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::selectNameFilter(*cpp_arg0);
    } else goto SbkQFileDialogFunc_selectNameFilter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_selectNameFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.selectNameFilter", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_selectedFiles(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedFiles()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QFileDialog::selectedFiles();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_selectedFilter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedFilter()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileDialog::selectedFilter();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_selectedNameFilter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedNameFilter()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileDialog::selectedNameFilter();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_setAcceptMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFileDialog::AcceptMode >::isConvertible(arg)) {
        QFileDialog::AcceptMode cpp_arg0 = Shiboken::Converter<QFileDialog::AcceptMode >::toCpp(arg);
        // setAcceptMode(QFileDialog::AcceptMode)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setAcceptMode(cpp_arg0);
    } else goto SbkQFileDialogFunc_setAcceptMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setAcceptMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.AcceptMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setAcceptMode", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setConfirmOverwrite(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setConfirmOverwrite(bool)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setConfirmOverwrite(cpp_arg0);
    } else goto SbkQFileDialogFunc_setConfirmOverwrite_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setConfirmOverwrite_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setConfirmOverwrite", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setDefaultSuffix(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDefaultSuffix(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setDefaultSuffix(*cpp_arg0);
    } else goto SbkQFileDialogFunc_setDefaultSuffix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setDefaultSuffix_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setDefaultSuffix", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setDirectory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDirectory(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setDirectory(*cpp_arg0);
    } else if (Shiboken::Converter<QDir& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QDir > cpp_arg0_auto_ptr;
        QDir* cpp_arg0 = Shiboken::Converter<QDir* >::toCpp(arg);
        if (!Shiboken::Converter<QDir& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QDir >(cpp_arg0);
        // setDirectory(QDir)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setDirectory(*cpp_arg0);
    } else goto SbkQFileDialogFunc_setDirectory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setDirectory_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setDirectory", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setFileMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFileDialog::FileMode >::isConvertible(arg)) {
        QFileDialog::FileMode cpp_arg0 = Shiboken::Converter<QFileDialog::FileMode >::toCpp(arg);
        // setFileMode(QFileDialog::FileMode)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setFileMode(cpp_arg0);
    } else goto SbkQFileDialogFunc_setFileMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setFileMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.FileMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setFileMode", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setFilter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFilter(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setFilter(*cpp_arg0);
    } else if (SbkPySide_QtCore_QDir_Filter_Check(arg)) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(arg);
        // setFilter(QFlags<QDir::Filter>)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setFilter(cpp_arg0);
    } else goto SbkQFileDialogFunc_setFilter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setFilter", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setFilters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setFilters(QStringList)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setFilters(*cpp_arg0);
    } else goto SbkQFileDialogFunc_setFilters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setFilters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setFilters", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setHistory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setHistory(QStringList)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setHistory(*cpp_arg0);
    } else goto SbkQFileDialogFunc_setHistory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setHistory_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setHistory", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setIconProvider(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFileIconProvider* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFileIconProvider* cpp_arg0 = Shiboken::Converter<QFileIconProvider* >::toCpp(arg);
        // setIconProvider(QFileIconProvider*)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setIconProvider(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQFileDialogFunc_setIconProvider_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setIconProvider_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileIconProvider", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setIconProvider", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setItemDelegate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemDelegate* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemDelegate* cpp_arg0 = Shiboken::Converter<QAbstractItemDelegate* >::toCpp(arg);
        // setItemDelegate(QAbstractItemDelegate*)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setItemDelegate(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQFileDialogFunc_setItemDelegate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setItemDelegate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemDelegate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setItemDelegate", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setLabelText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setLabelText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QFileDialog::DialogLabel >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        QFileDialog::DialogLabel cpp_arg0 = Shiboken::Converter<QFileDialog::DialogLabel >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setLabelText(QFileDialog::DialogLabel,QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setLabelText(cpp_arg0, *cpp_arg1);
    } else goto SbkQFileDialogFunc_setLabelText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setLabelText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.DialogLabel, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.setLabelText", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setNameFilter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setNameFilter(QString)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setNameFilter(*cpp_arg0);
    } else goto SbkQFileDialogFunc_setNameFilter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setNameFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setNameFilter", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setNameFilterDetailsVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setNameFilterDetailsVisible(bool)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setNameFilterDetailsVisible(cpp_arg0);
    } else goto SbkQFileDialogFunc_setNameFilterDetailsVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setNameFilterDetailsVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setNameFilterDetailsVisible", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setNameFilters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setNameFilters(QStringList)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setNameFilters(*cpp_arg0);
    } else goto SbkQFileDialogFunc_setNameFilters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setNameFilters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setNameFilters", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setOption(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOption", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QFileDialog::Option >::isConvertible(pyargs[0])) {
        QFileDialog::Option cpp_arg0 = Shiboken::Converter<QFileDialog::Option >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOption(QFileDialog::Option,bool)
            QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
            cppSelf->QFileDialog::setOption(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setOption(QFileDialog::Option,bool)
            QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
            cppSelf->QFileDialog::setOption(cpp_arg0, cpp_arg1);
        } else goto SbkQFileDialogFunc_setOption_TypeError;
    } else goto SbkQFileDialogFunc_setOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.Option, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFileDialog.setOption", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setOptions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QFileDialog_Option_Check(arg)) {
        QFlags<QFileDialog::Option> cpp_arg0 = Shiboken::Converter<QFlags<QFileDialog::Option> >::toCpp(arg);
        // setOptions(QFlags<QFileDialog::Option>)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setOptions(cpp_arg0);
    } else goto SbkQFileDialogFunc_setOptions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setOptions_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.Options", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setOptions", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setProxyModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractProxyModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractProxyModel* cpp_arg0 = Shiboken::Converter<QAbstractProxyModel* >::toCpp(arg);
        // setProxyModel(QAbstractProxyModel*)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setProxyModel(cpp_arg0);
    } else goto SbkQFileDialogFunc_setProxyModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setProxyModel_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractProxyModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setProxyModel", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setReadOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadOnly(bool)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setReadOnly(cpp_arg0);
    } else goto SbkQFileDialogFunc_setReadOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setReadOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setReadOnly", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setResolveSymlinks(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setResolveSymlinks(bool)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setResolveSymlinks(cpp_arg0);
    } else goto SbkQFileDialogFunc_setResolveSymlinks_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setResolveSymlinks_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setResolveSymlinks", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setSidebarUrls(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QUrl >  >::isConvertible(arg)) {
        QList<QUrl >  cpp_arg0 = Shiboken::Converter<QList<QUrl >  >::toCpp(arg);
        // setSidebarUrls(QList<QUrl>)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setSidebarUrls(cpp_arg0);
    } else goto SbkQFileDialogFunc_setSidebarUrls_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setSidebarUrls_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setSidebarUrls", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setViewMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFileDialog::ViewMode >::isConvertible(arg)) {
        QFileDialog::ViewMode cpp_arg0 = Shiboken::Converter<QFileDialog::ViewMode >::toCpp(arg);
        // setViewMode(QFileDialog::ViewMode)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setViewMode(cpp_arg0);
    } else goto SbkQFileDialogFunc_setViewMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setViewMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.ViewMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setViewMode", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        cppSelf->QFileDialog::setVisible(cpp_arg0);
    } else goto SbkQFileDialogFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileDialogFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.setVisible", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_sidebarUrls(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sidebarUrls()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QList<QUrl > cpp_result = cppSelf->QFileDialog::sidebarUrls();
    py_result = Shiboken::Converter<QList<QUrl > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileDialogFunc_testOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFileDialog::Option >::isConvertible(arg)) {
        QFileDialog::Option cpp_arg0 = Shiboken::Converter<QFileDialog::Option >::toCpp(arg);
        // testOption(QFileDialog::Option)const
        QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFileDialog::testOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFileDialogFunc_testOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFileDialogFunc_testOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFileDialog.Option", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFileDialog.testOption", overloads);
        return 0;
}

static PyObject*
SbkQFileDialogFunc_viewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewMode()const
    QFileDialog* cppSelf = Shiboken::Converter<QFileDialog* >::toCpp((PyObject*)self);
    QFileDialog::ViewMode cpp_result = cppSelf->QFileDialog::viewMode();
    py_result = Shiboken::Converter<QFileDialog::ViewMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQFileDialog_methods[] = {
    {"accept", (PyCFunction)SbkQFileDialogFunc_accept, METH_NOARGS},
    {"acceptMode", (PyCFunction)SbkQFileDialogFunc_acceptMode, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQFileDialogFunc_changeEvent, METH_O},
    {"confirmOverwrite", (PyCFunction)SbkQFileDialogFunc_confirmOverwrite, METH_NOARGS},
    {"defaultSuffix", (PyCFunction)SbkQFileDialogFunc_defaultSuffix, METH_NOARGS},
    {"directory", (PyCFunction)SbkQFileDialogFunc_directory, METH_NOARGS},
    {"done", (PyCFunction)SbkQFileDialogFunc_done, METH_O},
    {"fileMode", (PyCFunction)SbkQFileDialogFunc_fileMode, METH_NOARGS},
    {"filter", (PyCFunction)SbkQFileDialogFunc_filter, METH_NOARGS},
    {"filters", (PyCFunction)SbkQFileDialogFunc_filters, METH_NOARGS},
    {"getExistingDirectory", (PyCFunction)SbkQFileDialogFunc_getExistingDirectory, METH_VARARGS|METH_STATIC},
    {"getOpenFileName", (PyCFunction)SbkQFileDialogFunc_getOpenFileName, METH_VARARGS|METH_STATIC},
    {"getOpenFileNames", (PyCFunction)SbkQFileDialogFunc_getOpenFileNames, METH_VARARGS|METH_STATIC},
    {"getSaveFileName", (PyCFunction)SbkQFileDialogFunc_getSaveFileName, METH_VARARGS|METH_STATIC},
    {"history", (PyCFunction)SbkQFileDialogFunc_history, METH_NOARGS},
    {"iconProvider", (PyCFunction)SbkQFileDialogFunc_iconProvider, METH_NOARGS},
    {"isNameFilterDetailsVisible", (PyCFunction)SbkQFileDialogFunc_isNameFilterDetailsVisible, METH_NOARGS},
    {"isReadOnly", (PyCFunction)SbkQFileDialogFunc_isReadOnly, METH_NOARGS},
    {"itemDelegate", (PyCFunction)SbkQFileDialogFunc_itemDelegate, METH_NOARGS},
    {"labelText", (PyCFunction)SbkQFileDialogFunc_labelText, METH_O},
    {"nameFilters", (PyCFunction)SbkQFileDialogFunc_nameFilters, METH_NOARGS},
    {"open", (PyCFunction)SbkQFileDialogFunc_open, METH_VARARGS},
    {"options", (PyCFunction)SbkQFileDialogFunc_options, METH_NOARGS},
    {"proxyModel", (PyCFunction)SbkQFileDialogFunc_proxyModel, METH_NOARGS},
    {"resolveSymlinks", (PyCFunction)SbkQFileDialogFunc_resolveSymlinks, METH_NOARGS},
    {"restoreState", (PyCFunction)SbkQFileDialogFunc_restoreState, METH_O},
    {"saveState", (PyCFunction)SbkQFileDialogFunc_saveState, METH_NOARGS},
    {"selectFile", (PyCFunction)SbkQFileDialogFunc_selectFile, METH_O},
    {"selectFilter", (PyCFunction)SbkQFileDialogFunc_selectFilter, METH_O},
    {"selectNameFilter", (PyCFunction)SbkQFileDialogFunc_selectNameFilter, METH_O},
    {"selectedFiles", (PyCFunction)SbkQFileDialogFunc_selectedFiles, METH_NOARGS},
    {"selectedFilter", (PyCFunction)SbkQFileDialogFunc_selectedFilter, METH_NOARGS},
    {"selectedNameFilter", (PyCFunction)SbkQFileDialogFunc_selectedNameFilter, METH_NOARGS},
    {"setAcceptMode", (PyCFunction)SbkQFileDialogFunc_setAcceptMode, METH_O},
    {"setConfirmOverwrite", (PyCFunction)SbkQFileDialogFunc_setConfirmOverwrite, METH_O},
    {"setDefaultSuffix", (PyCFunction)SbkQFileDialogFunc_setDefaultSuffix, METH_O},
    {"setDirectory", (PyCFunction)SbkQFileDialogFunc_setDirectory, METH_O},
    {"setFileMode", (PyCFunction)SbkQFileDialogFunc_setFileMode, METH_O},
    {"setFilter", (PyCFunction)SbkQFileDialogFunc_setFilter, METH_O},
    {"setFilters", (PyCFunction)SbkQFileDialogFunc_setFilters, METH_O},
    {"setHistory", (PyCFunction)SbkQFileDialogFunc_setHistory, METH_O},
    {"setIconProvider", (PyCFunction)SbkQFileDialogFunc_setIconProvider, METH_O},
    {"setItemDelegate", (PyCFunction)SbkQFileDialogFunc_setItemDelegate, METH_O},
    {"setLabelText", (PyCFunction)SbkQFileDialogFunc_setLabelText, METH_VARARGS},
    {"setNameFilter", (PyCFunction)SbkQFileDialogFunc_setNameFilter, METH_O},
    {"setNameFilterDetailsVisible", (PyCFunction)SbkQFileDialogFunc_setNameFilterDetailsVisible, METH_O},
    {"setNameFilters", (PyCFunction)SbkQFileDialogFunc_setNameFilters, METH_O},
    {"setOption", (PyCFunction)SbkQFileDialogFunc_setOption, METH_VARARGS},
    {"setOptions", (PyCFunction)SbkQFileDialogFunc_setOptions, METH_O},
    {"setProxyModel", (PyCFunction)SbkQFileDialogFunc_setProxyModel, METH_O},
    {"setReadOnly", (PyCFunction)SbkQFileDialogFunc_setReadOnly, METH_O},
    {"setResolveSymlinks", (PyCFunction)SbkQFileDialogFunc_setResolveSymlinks, METH_O},
    {"setSidebarUrls", (PyCFunction)SbkQFileDialogFunc_setSidebarUrls, METH_O},
    {"setViewMode", (PyCFunction)SbkQFileDialogFunc_setViewMode, METH_O},
    {"setVisible", (PyCFunction)SbkQFileDialogFunc_setVisible, METH_O},
    {"sidebarUrls", (PyCFunction)SbkQFileDialogFunc_sidebarUrls, METH_NOARGS},
    {"testOption", (PyCFunction)SbkQFileDialogFunc_testOption, METH_O},
    {"viewMode", (PyCFunction)SbkQFileDialogFunc_viewMode, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQFileDialogSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QFileDialog* me = reinterpret_cast<QFileDialog*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX]))
        return static_cast<QDialog*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFileDialog_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFileDialog",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QFileDialogWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFileDialog_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFileDialog_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQFileDialogSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QFileDialog_FileMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileDialog_FileMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileDialog_FileMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FileMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFileDialog_FileMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileDialog_FileMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileDialog_FileMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QFileDialog_Option___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFileDialog::Options >::toPython(
        ((QFileDialog::Options) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QFileDialog::Options >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QFileDialog_Option___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFileDialog::Options >::toPython(
        ((QFileDialog::Options) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QFileDialog::Options >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QFileDialog_Option___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFileDialog::Options >::toPython(
        ((QFileDialog::Options) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QFileDialog::Options >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QFileDialog_Option___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QFileDialog::Options >::toPython(
        ~ Shiboken::Converter< QFileDialog::Options >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QFileDialog_Option_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QFileDialog_Option___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QFileDialog_Option___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QFileDialog_Option___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QFileDialog_Option___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QFileDialog_Option_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileDialog_Option_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileDialog_Option_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Option",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QFileDialog_Option_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFileDialog_Option_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileDialog_Option_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileDialog_Option_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileDialog_Options_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileDialog_Options_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Options",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QFileDialog_Option_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileDialog_Options_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileDialog_Options_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QFileDialog_Options_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QFileDialog_DialogLabel_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileDialog_DialogLabel_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileDialog_DialogLabel_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DialogLabel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFileDialog_DialogLabel_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileDialog_DialogLabel_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileDialog_DialogLabel_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFileDialog_ViewMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileDialog_ViewMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileDialog_ViewMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFileDialog_ViewMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileDialog_ViewMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileDialog_ViewMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFileDialog_AcceptMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFileDialog_AcceptMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFileDialog_AcceptMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AcceptMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFileDialog_AcceptMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFileDialog_AcceptMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QFileDialog_AcceptMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QFileDialog(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFileDialog_Type);

    SbkQFileDialog_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX];
    SbkQFileDialog_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQFileDialog_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFileDialog_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFileDialog_Type));
    PyModule_AddObject(module, "QFileDialog",
        ((PyObject*)&SbkQFileDialog_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FileMode
    SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_FILEMODE_IDX] = &SbkPySide_QtGui_QFileDialog_FileMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileDialog_FileMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileDialog_FileMode_Type);
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
            "FileMode",((PyObject*)&SbkPySide_QtGui_QFileDialog_FileMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_FileMode_Type,
        (long) QFileDialog::AnyFile, "AnyFile");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "AnyFile", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_FileMode_Type.tp_dict,
        "AnyFile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_FileMode_Type,
        (long) QFileDialog::ExistingFile, "ExistingFile");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "ExistingFile", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_FileMode_Type.tp_dict,
        "ExistingFile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_FileMode_Type,
        (long) QFileDialog::Directory, "Directory");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "Directory", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_FileMode_Type.tp_dict,
        "Directory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_FileMode_Type,
        (long) QFileDialog::ExistingFiles, "ExistingFiles");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "ExistingFiles", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_FileMode_Type.tp_dict,
        "ExistingFiles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_FileMode_Type,
        (long) QFileDialog::DirectoryOnly, "DirectoryOnly");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "DirectoryOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_FileMode_Type.tp_dict,
        "DirectoryOnly", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFileDialog::FileMode");

    // init enum class: Option
    SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_OPTION_IDX] = &SbkPySide_QtGui_QFileDialog_Option_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileDialog_Option_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileDialog_Option_Type);
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
            "Option",((PyObject*)&SbkPySide_QtGui_QFileDialog_Option_Type));

    // init flags class: QFlags<QFileDialog::Option>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QFILEDIALOG_OPTION__IDX] = &SbkPySide_QtGui_QFileDialog_Options_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileDialog_Options_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileDialog_Options_Type);
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
            "Options",((PyObject*)&SbkPySide_QtGui_QFileDialog_Options_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::ShowDirsOnly, "ShowDirsOnly");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "ShowDirsOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "ShowDirsOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::DontResolveSymlinks, "DontResolveSymlinks");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "DontResolveSymlinks", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "DontResolveSymlinks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::DontConfirmOverwrite, "DontConfirmOverwrite");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "DontConfirmOverwrite", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "DontConfirmOverwrite", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::DontUseSheet, "DontUseSheet");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "DontUseSheet", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "DontUseSheet", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::DontUseNativeDialog, "DontUseNativeDialog");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "DontUseNativeDialog", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "DontUseNativeDialog", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::ReadOnly, "ReadOnly");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "ReadOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "ReadOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_Option_Type,
        (long) QFileDialog::HideNameFilterDetails, "HideNameFilterDetails");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "HideNameFilterDetails", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_Option_Type.tp_dict,
        "HideNameFilterDetails", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFileDialog::Option");

    // init enum class: DialogLabel
    SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX] = &SbkPySide_QtGui_QFileDialog_DialogLabel_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileDialog_DialogLabel_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileDialog_DialogLabel_Type);
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
            "DialogLabel",((PyObject*)&SbkPySide_QtGui_QFileDialog_DialogLabel_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_DialogLabel_Type,
        (long) QFileDialog::LookIn, "LookIn");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "LookIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_DialogLabel_Type.tp_dict,
        "LookIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_DialogLabel_Type,
        (long) QFileDialog::FileName, "FileName");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "FileName", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_DialogLabel_Type.tp_dict,
        "FileName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_DialogLabel_Type,
        (long) QFileDialog::FileType, "FileType");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "FileType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_DialogLabel_Type.tp_dict,
        "FileType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_DialogLabel_Type,
        (long) QFileDialog::Accept, "Accept");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "Accept", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_DialogLabel_Type.tp_dict,
        "Accept", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_DialogLabel_Type,
        (long) QFileDialog::Reject, "Reject");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "Reject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_DialogLabel_Type.tp_dict,
        "Reject", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFileDialog::DialogLabel");

    // init enum class: ViewMode
    SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_VIEWMODE_IDX] = &SbkPySide_QtGui_QFileDialog_ViewMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileDialog_ViewMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileDialog_ViewMode_Type);
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
            "ViewMode",((PyObject*)&SbkPySide_QtGui_QFileDialog_ViewMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_ViewMode_Type,
        (long) QFileDialog::Detail, "Detail");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "Detail", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_ViewMode_Type.tp_dict,
        "Detail", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_ViewMode_Type,
        (long) QFileDialog::List, "List");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "List", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_ViewMode_Type.tp_dict,
        "List", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFileDialog::ViewMode");

    // init enum class: AcceptMode
    SbkPySide_QtGuiTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX] = &SbkPySide_QtGui_QFileDialog_AcceptMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFileDialog_AcceptMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFileDialog_AcceptMode_Type);
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
            "AcceptMode",((PyObject*)&SbkPySide_QtGui_QFileDialog_AcceptMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_AcceptMode_Type,
        (long) QFileDialog::AcceptOpen, "AcceptOpen");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "AcceptOpen", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_AcceptMode_Type.tp_dict,
        "AcceptOpen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFileDialog_AcceptMode_Type,
        (long) QFileDialog::AcceptSave, "AcceptSave");
    PyDict_SetItemString(SbkQFileDialog_Type.super.ht_type.tp_dict,
        "AcceptSave", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFileDialog_AcceptMode_Type.tp_dict,
        "AcceptSave", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFileDialog::AcceptMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QFileDialog >("QFileDialog*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFileDialog >(typeid(QFileDialog).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

