/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qdoublevalidator_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qlocale.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvalidator.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QDoubleValidatorWrapper::QDoubleValidatorWrapper(QObject * parent) : QDoubleValidator(parent), m_metaObject(0) {
    // ... middle
}

QDoubleValidatorWrapper::QDoubleValidatorWrapper(double bottom, double top, int decimals, QObject * parent) : QDoubleValidator(bottom, top, decimals, parent), m_metaObject(0) {
    // ... middle
}

void QDoubleValidatorWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDoubleValidatorWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDoubleValidatorWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDoubleValidatorWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QDoubleValidatorWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QDoubleValidator.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QDoubleValidatorWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QDoubleValidator.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QDoubleValidatorWrapper::fixup(QString & arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fixup"));
    if (py_override.isNull()) {
        return this->QValidator::fixup(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDoubleValidatorWrapper::setRange(double bottom, double top, int decimals)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRange"));
    if (py_override.isNull()) {
        return this->QDoubleValidator::setRange(bottom, top, decimals);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ddi)",
        bottom,
        top,
        decimals
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDoubleValidatorWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QValidator::State QDoubleValidatorWrapper::validate(QString & arg__1, int & arg__2) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validate"));
    if (py_override.isNull()) {
        return this->QDoubleValidator::validate(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(arg__1),
        Shiboken::Converter<int >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QValidator::State();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QValidator::State >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QDoubleValidator.validate");
        return QValidator::State()        ;
    }
    QValidator::State cpp_result(Shiboken::Converter<QValidator::State >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QDoubleValidatorWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QDoubleValidator::staticMetaObject);
}
    return m_metaObject;
}

int QDoubleValidatorWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QDoubleValidator::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QDoubleValidatorWrapper::~QDoubleValidatorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQDoubleValidator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDoubleValidatorWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQDoubleValidator_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QDoubleValidator", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QObject* >::isConvertible(pyargs[3])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        QObject* cpp_arg3 = Shiboken::Converter<QObject* >::toCpp(pyargs[3]);
        // QDoubleValidator(double,double,int,QObject*)
        cptr = new QDoubleValidatorWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        Shiboken::setParent(pyargs[3], self);
    } else if (numArgs == 1 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QDoubleValidator(QObject*)
        cptr = new QDoubleValidatorWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQDoubleValidator_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDoubleValidator_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDoubleValidator_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", "float, float, int, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDoubleValidator", overloads);
        return -1;
}

static PyObject*
SbkQDoubleValidatorFunc_bottom(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottom()const
    QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QDoubleValidator::bottom();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDoubleValidatorFunc_decimals(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // decimals()const
    QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDoubleValidator::decimals();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDoubleValidatorFunc_notation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // notation()const
    QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
    QDoubleValidator::Notation cpp_result = cppSelf->QDoubleValidator::notation();
    py_result = Shiboken::Converter<QDoubleValidator::Notation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDoubleValidatorFunc_setBottom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // setBottom(double)
        QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
        cppSelf->QDoubleValidator::setBottom(cpp_arg0);
    } else goto SbkQDoubleValidatorFunc_setBottom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDoubleValidatorFunc_setBottom_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDoubleValidator.setBottom", overloads);
        return 0;
}

static PyObject*
SbkQDoubleValidatorFunc_setDecimals(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDecimals(int)
        QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
        cppSelf->QDoubleValidator::setDecimals(cpp_arg0);
    } else goto SbkQDoubleValidatorFunc_setDecimals_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDoubleValidatorFunc_setDecimals_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDoubleValidator.setDecimals", overloads);
        return 0;
}

static PyObject*
SbkQDoubleValidatorFunc_setNotation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDoubleValidator::Notation >::isConvertible(arg)) {
        QDoubleValidator::Notation cpp_arg0 = Shiboken::Converter<QDoubleValidator::Notation >::toCpp(arg);
        // setNotation(QDoubleValidator::Notation)
        QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
        cppSelf->QDoubleValidator::setNotation(cpp_arg0);
    } else goto SbkQDoubleValidatorFunc_setNotation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDoubleValidatorFunc_setNotation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDoubleValidator.Notation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDoubleValidator.setNotation", overloads);
        return 0;
}

static PyObject*
SbkQDoubleValidatorFunc_setRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRange", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // setRange(double,double,int)
            QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
            cppSelf->QDoubleValidator::setRange(cpp_arg0, cpp_arg1);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setRange(double,double,int)
            QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
            cppSelf->QDoubleValidator::setRange(cpp_arg0, cpp_arg1, cpp_arg2);
        } else goto SbkQDoubleValidatorFunc_setRange_TypeError;
    } else goto SbkQDoubleValidatorFunc_setRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDoubleValidatorFunc_setRange_TypeError:
        const char* overloads[] = {"float, float, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDoubleValidator.setRange", overloads);
        return 0;
}

static PyObject*
SbkQDoubleValidatorFunc_setTop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // setTop(double)
        QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
        cppSelf->QDoubleValidator::setTop(cpp_arg0);
    } else goto SbkQDoubleValidatorFunc_setTop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDoubleValidatorFunc_setTop_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDoubleValidator.setTop", overloads);
        return 0;
}

static PyObject*
SbkQDoubleValidatorFunc_top(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // top()const
    QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QDoubleValidator::top();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDoubleValidatorFunc_validate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "validate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // validate(QString&,int&)const
        QDoubleValidator* cppSelf = Shiboken::Converter<QDoubleValidator* >::toCpp((PyObject*)self);
        QValidator::State cpp_result = cppSelf->QDoubleValidator::validate(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QValidator::State >::toPython(cpp_result);
    } else goto SbkQDoubleValidatorFunc_validate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDoubleValidatorFunc_validate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDoubleValidator.validate", overloads);
        return 0;
}

static PyMethodDef SbkQDoubleValidator_methods[] = {
    {"bottom", (PyCFunction)SbkQDoubleValidatorFunc_bottom, METH_NOARGS},
    {"decimals", (PyCFunction)SbkQDoubleValidatorFunc_decimals, METH_NOARGS},
    {"notation", (PyCFunction)SbkQDoubleValidatorFunc_notation, METH_NOARGS},
    {"setBottom", (PyCFunction)SbkQDoubleValidatorFunc_setBottom, METH_O},
    {"setDecimals", (PyCFunction)SbkQDoubleValidatorFunc_setDecimals, METH_O},
    {"setNotation", (PyCFunction)SbkQDoubleValidatorFunc_setNotation, METH_O},
    {"setRange", (PyCFunction)SbkQDoubleValidatorFunc_setRange, METH_VARARGS},
    {"setTop", (PyCFunction)SbkQDoubleValidatorFunc_setTop, METH_O},
    {"top", (PyCFunction)SbkQDoubleValidatorFunc_top, METH_NOARGS},
    {"validate", (PyCFunction)SbkQDoubleValidatorFunc_validate, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDoubleValidator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDoubleValidator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDoubleValidatorWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDoubleValidator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDoubleValidator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QDoubleValidator_Notation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDoubleValidator_Notation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDoubleValidator_Notation_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Notation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDoubleValidator_Notation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDoubleValidator_Notation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QDoubleValidator_Notation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QDoubleValidator(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDOUBLEVALIDATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDoubleValidator_Type);

    SbkQDoubleValidator_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QVALIDATOR_IDX];
    // Fill type discovery information
    SbkQDoubleValidator_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQDoubleValidator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDoubleValidator_Type));
    PyModule_AddObject(module, "QDoubleValidator",
        ((PyObject*)&SbkQDoubleValidator_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Notation
    SbkPySide_QtGuiTypes[SBK_QDOUBLEVALIDATOR_NOTATION_IDX] = &SbkPySide_QtGui_QDoubleValidator_Notation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDoubleValidator_Notation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDoubleValidator_Notation_Type);
    PyDict_SetItemString(SbkQDoubleValidator_Type.super.ht_type.tp_dict,
            "Notation",((PyObject*)&SbkPySide_QtGui_QDoubleValidator_Notation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDoubleValidator_Notation_Type,
        (long) QDoubleValidator::StandardNotation, "StandardNotation");
    PyDict_SetItemString(SbkQDoubleValidator_Type.super.ht_type.tp_dict,
        "StandardNotation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDoubleValidator_Notation_Type.tp_dict,
        "StandardNotation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDoubleValidator_Notation_Type,
        (long) QDoubleValidator::ScientificNotation, "ScientificNotation");
    PyDict_SetItemString(SbkQDoubleValidator_Type.super.ht_type.tp_dict,
        "ScientificNotation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDoubleValidator_Notation_Type.tp_dict,
        "ScientificNotation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDoubleValidator::Notation");

    Shiboken::TypeResolver::createObjectTypeResolver<QDoubleValidator >("QDoubleValidator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDoubleValidator >(typeid(QDoubleValidator).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

