/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qcontextmenuevent_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QContextMenuEventWrapper::QContextMenuEventWrapper(QContextMenuEvent::Reason reason, const QPoint & pos) : QContextMenuEvent(reason, pos) {
    // ... middle
}

QContextMenuEventWrapper::QContextMenuEventWrapper(QContextMenuEvent::Reason reason, const QPoint & pos, const QPoint & globalPos) : QContextMenuEvent(reason, pos, globalPos) {
    // ... middle
}

QContextMenuEventWrapper::QContextMenuEventWrapper(QContextMenuEvent::Reason reason, const QPoint & pos, const QPoint & globalPos, QFlags<Qt::KeyboardModifier> modifiers) : QContextMenuEvent(reason, pos, globalPos, modifiers) {
    // ... middle
}

QContextMenuEventWrapper::~QContextMenuEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQContextMenuEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QContextMenuEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QContextMenuEvent", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (Shiboken::Converter<QContextMenuEvent::Reason >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[1])) {
        QContextMenuEvent::Reason cpp_arg0 = Shiboken::Converter<QContextMenuEvent::Reason >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QPoint > cpp_arg1_auto_ptr;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPoint >(cpp_arg1);
        if (numArgs == 2) {
            // QContextMenuEvent(QContextMenuEvent::Reason,QPoint)
            cptr = new QContextMenuEventWrapper(cpp_arg0, *cpp_arg1);
        } else if (Shiboken::Converter<QPoint& >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
            QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
            if (numArgs == 3) {
                // QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint)
                cptr = new QContextMenuEventWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2);
            } else if (numArgs == 4 && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[3])) {
                QFlags<Qt::KeyboardModifier> cpp_arg3 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[3]);
                // QContextMenuEvent(QContextMenuEvent::Reason,QPoint,QPoint,QFlags<Qt::KeyboardModifier>)
                cptr = new QContextMenuEventWrapper(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
            } else goto SbkQContextMenuEvent_Init_TypeError;
        } else goto SbkQContextMenuEvent_Init_TypeError;
    } else goto SbkQContextMenuEvent_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQContextMenuEvent_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQContextMenuEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent.Reason, PySide.QtCore.QPoint", "PySide.QtGui.QContextMenuEvent.Reason, PySide.QtCore.QPoint, PySide.QtCore.QPoint", "PySide.QtGui.QContextMenuEvent.Reason, PySide.QtCore.QPoint, PySide.QtCore.QPoint, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QContextMenuEvent", overloads);
        return -1;
}

static PyObject*
SbkQContextMenuEventFunc_globalPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalPos()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QContextMenuEvent::globalPos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQContextMenuEventFunc_globalX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalX()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QContextMenuEvent::globalX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQContextMenuEventFunc_globalY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalY()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QContextMenuEvent::globalY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQContextMenuEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QContextMenuEvent::pos();
    py_result = Shiboken::Converter<QPoint& >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQContextMenuEventFunc_reason(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // reason()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    QContextMenuEvent::Reason cpp_result = cppSelf->QContextMenuEvent::reason();
    py_result = Shiboken::Converter<QContextMenuEvent::Reason >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQContextMenuEventFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QContextMenuEvent::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQContextMenuEventFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QContextMenuEvent* cppSelf = Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QContextMenuEvent::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQContextMenuEvent_methods[] = {
    {"globalPos", (PyCFunction)SbkQContextMenuEventFunc_globalPos, METH_NOARGS},
    {"globalX", (PyCFunction)SbkQContextMenuEventFunc_globalX, METH_NOARGS},
    {"globalY", (PyCFunction)SbkQContextMenuEventFunc_globalY, METH_NOARGS},
    {"pos", (PyCFunction)SbkQContextMenuEventFunc_pos, METH_NOARGS},
    {"reason", (PyCFunction)SbkQContextMenuEventFunc_reason, METH_NOARGS},
    {"x", (PyCFunction)SbkQContextMenuEventFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQContextMenuEventFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQContextMenuEvent_get_reas(SbkBaseWrapper* self)
{
    return Shiboken::Converter<unsigned int >::toPython(Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self)->reas);
}
static int SbkQContextMenuEvent_set_reas(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'reas' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'reas', 'uint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self)->reas = Shiboken::Converter<unsigned int >::toCpp(value);

    return 0;
}

static PyObject* SbkQContextMenuEvent_get_gp(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self)->gp);
}
static int SbkQContextMenuEvent_set_gp(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'gp' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'gp', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self)->gp = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQContextMenuEvent_get_p(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self)->p);
}
static int SbkQContextMenuEvent_set_p(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'p' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'p', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QContextMenuEvent* >::toCpp((PyObject*)self)->p = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

// Getters and Setters for QContextMenuEvent
static PyGetSetDef SbkQContextMenuEvent_getsetlist[] = {
    {const_cast<char*>("reas"), (getter)SbkQContextMenuEvent_get_reas, (setter)SbkQContextMenuEvent_set_reas},
    {const_cast<char*>("gp"), (getter)SbkQContextMenuEvent_get_gp, (setter)SbkQContextMenuEvent_set_gp},
    {const_cast<char*>("p"), (getter)SbkQContextMenuEvent_get_p, (setter)SbkQContextMenuEvent_set_p},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQContextMenuEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QContextMenuEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QContextMenuEventWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQContextMenuEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQContextMenuEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQContextMenuEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQContextMenuEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQContextMenuEvent_Type);
     if ( reinterpret_cast<QContextMenuEvent*>(cptr)->type() == QEvent::ContextMenu)
        return &SbkQContextMenuEvent_Type;
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QContextMenuEvent_Reason_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QContextMenuEvent_Reason_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QContextMenuEvent_Reason_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Reason",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QContextMenuEvent_Reason_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QContextMenuEvent_Reason_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QContextMenuEvent_Reason_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QContextMenuEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQContextMenuEvent_Type);

    SbkQContextMenuEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX];
    // Fill type discovery information
    SbkQContextMenuEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQContextMenuEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQContextMenuEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQContextMenuEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQContextMenuEvent_Type));
    PyModule_AddObject(module, "QContextMenuEvent",
        ((PyObject*)&SbkQContextMenuEvent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Reason
    SbkPySide_QtGuiTypes[SBK_QCONTEXTMENUEVENT_REASON_IDX] = &SbkPySide_QtGui_QContextMenuEvent_Reason_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QContextMenuEvent_Reason_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QContextMenuEvent_Reason_Type);
    PyDict_SetItemString(SbkQContextMenuEvent_Type.super.ht_type.tp_dict,
            "Reason",((PyObject*)&SbkPySide_QtGui_QContextMenuEvent_Reason_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QContextMenuEvent_Reason_Type,
        (long) QContextMenuEvent::Mouse, "Mouse");
    PyDict_SetItemString(SbkQContextMenuEvent_Type.super.ht_type.tp_dict,
        "Mouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QContextMenuEvent_Reason_Type.tp_dict,
        "Mouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QContextMenuEvent_Reason_Type,
        (long) QContextMenuEvent::Keyboard, "Keyboard");
    PyDict_SetItemString(SbkQContextMenuEvent_Type.super.ht_type.tp_dict,
        "Keyboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QContextMenuEvent_Reason_Type.tp_dict,
        "Keyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QContextMenuEvent_Reason_Type,
        (long) QContextMenuEvent::Other, "Other");
    PyDict_SetItemString(SbkQContextMenuEvent_Type.super.ht_type.tp_dict,
        "Other", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QContextMenuEvent_Reason_Type.tp_dict,
        "Other", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QContextMenuEvent::Reason");

    Shiboken::TypeResolver::createObjectTypeResolver<QContextMenuEvent >("QContextMenuEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QContextMenuEvent >(typeid(QContextMenuEvent).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

