/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qcleanlooksstyle_wrapper.h"

// Extra includes
#include <QList>
#include <qapplication.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qwindowsstyle.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QCleanlooksStyleWrapper::QCleanlooksStyleWrapper() : QCleanlooksStyle(), m_metaObject(0) {
    // ... middle
}

void QCleanlooksStyleWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCleanlooksStyleWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCleanlooksStyleWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::drawComplexControl(QStyle::ComplexControl control, const QStyleOptionComplex * option, QPainter * painter, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawComplexControl"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::drawComplexControl(control, option, painter, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(control),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(option),
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::drawControl(QStyle::ControlElement ce, const QStyleOption * option, QPainter * painter, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawControl"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::drawControl(ce, option, painter, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ControlElement >::toPython(ce),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::drawItemPixmap(QPainter * painter, const QRect & rect, int alignment, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemPixmap"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        alignment,
        Shiboken::Converter<QPixmap& >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::drawItemText(QPainter * painter, const QRect & rect, int flags, const QPalette & pal, bool enabled, const QString & text, QPalette::ColorRole textRole) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawItemText"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiOOOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QRect& >::toPython(rect),
        flags,
        Shiboken::Converter<QPalette& >::toPython(pal),
        Shiboken::Converter<bool >::toPython(enabled),
        Shiboken::Converter<QString& >::toPython(text),
        Shiboken::Converter<QPalette::ColorRole >::toPython(textRole)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::drawPrimitive(QStyle::PrimitiveElement elem, const QStyleOption * option, QPainter * painter, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawPrimitive"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::drawPrimitive(elem, option, painter, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::PrimitiveElement >::toPython(elem),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QCleanlooksStyleWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QCleanlooksStyleWrapper::eventFilter(QObject * o, QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QWindowsStyle::eventFilter(o, e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(o),
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QPixmap QCleanlooksStyleWrapper::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap & pixmap, const QStyleOption * opt) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "generatedIconPixmap"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::generatedIconPixmap(iconMode, pixmap, opt);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QIcon::Mode >::toPython(iconMode),
        Shiboken::Converter<QPixmap& >::toPython(pixmap),
        Shiboken::Converter<QStyleOption* >::toPython(opt)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.generatedIconPixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

QStyle::SubControl QCleanlooksStyleWrapper::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, const QPoint & pt, const QWidget * w) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hitTestComplexControl"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::hitTestComplexControl(cc, opt, pt, w);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(opt),
        Shiboken::Converter<QPoint& >::toPython(pt),
        Shiboken::Converter<QWidget* >::toPython(w)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyle::SubControl();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyle::SubControl >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.hitTestComplexControl");
        return QStyle::SubControl()        ;
    }
    QStyle::SubControl cpp_result(Shiboken::Converter<QStyle::SubControl >::toCpp(py_result));
    return cpp_result;
}

QRect QCleanlooksStyleWrapper::itemPixmapRect(const QRect & r, int flags, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemPixmapRect"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::itemPixmapRect(r, flags, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiO)",
        Shiboken::Converter<QRect& >::toPython(r),
        flags,
        Shiboken::Converter<QPixmap& >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.itemPixmapRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

int QCleanlooksStyleWrapper::pixelMetric(QStyle::PixelMetric metric, const QStyleOption * option, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pixelMetric"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::pixelMetric(metric, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::PixelMetric >::toPython(metric),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.pixelMetric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QCleanlooksStyleWrapper::polish(QApplication * app)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::polish(app);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QApplication* >::toPython(app)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::polish(QPalette & pal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::polish(pal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPalette& >::toPython(pal)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::polish(QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polish"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::polish(widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QCleanlooksStyleWrapper::sizeFromContents(QStyle::ContentsType type, const QStyleOption * option, const QSize & size, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeFromContents"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::sizeFromContents(type, option, size, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ContentsType >::toPython(type),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QSize& >::toPython(size),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.sizeFromContents");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QPalette QCleanlooksStyleWrapper::standardPalette() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPalette"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::standardPalette();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPalette();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPalette >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.standardPalette");
        return QPalette()        ;
    }
    QPalette cpp_result(Shiboken::Converter<QPalette >::toCpp(py_result));
    return cpp_result;
}

QPixmap QCleanlooksStyleWrapper::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption * opt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "standardPixmap"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCleanlooksStyle.standardPixmap()' not implemented.");
        return QPixmap();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::StandardPixmap >::toPython(standardPixmap),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPixmap();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPixmap >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.standardPixmap");
        return QPixmap()        ;
    }
    QPixmap cpp_result(Shiboken::Converter<QPixmap >::toCpp(py_result));
    return cpp_result;
}

int QCleanlooksStyleWrapper::styleHint(QStyle::StyleHint hint, const QStyleOption * option, const QWidget * widget, QStyleHintReturn * returnData) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "styleHint"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::styleHint(hint, option, widget, returnData);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::StyleHint >::toPython(hint),
        Shiboken::Converter<QStyleOption* >::toPython(option),
        Shiboken::Converter<QWidget* >::toPython(widget),
        Shiboken::Converter<QStyleHintReturn* >::toPython(returnData)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.styleHint");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QRect QCleanlooksStyleWrapper::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex * opt, QStyle::SubControl sc, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subControlRect"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::subControlRect(cc, opt, sc, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QStyle::ComplexControl >::toPython(cc),
        Shiboken::Converter<QStyleOptionComplex* >::toPython(opt),
        Shiboken::Converter<QStyle::SubControl >::toPython(sc),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.subControlRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRect QCleanlooksStyleWrapper::subElementRect(QStyle::SubElement r, const QStyleOption * opt, const QWidget * widget) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "subElementRect"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::subElementRect(r, opt, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QStyle::SubElement >::toPython(r),
        Shiboken::Converter<QStyleOption* >::toPython(opt),
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCleanlooksStyle.subElementRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

void QCleanlooksStyleWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QWindowsStyle::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::unpolish(QApplication * app)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::unpolish(app);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QApplication* >::toPython(app)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCleanlooksStyleWrapper::unpolish(QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unpolish"));
    if (py_override.isNull()) {
        return this->QCleanlooksStyle::unpolish(widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QCleanlooksStyleWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QCleanlooksStyle::staticMetaObject);
}
    return m_metaObject;
}

int QCleanlooksStyleWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QCleanlooksStyle::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QCleanlooksStyleWrapper::~QCleanlooksStyleWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQCleanlooksStyle_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QCleanlooksStyleWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QCLEANLOOKSSTYLE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QCleanlooksStyle' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QCleanlooksStyle()
    cptr = new QCleanlooksStyleWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQCleanlooksStyleFunc_drawComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawComplexControl", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::drawComplexControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQCleanlooksStyleFunc_drawComplexControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_drawComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QPainter, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.drawComplexControl", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_drawControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawControl", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ControlElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ControlElement cpp_arg0 = Shiboken::Converter<QStyle::ControlElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::drawControl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
    } else goto SbkQCleanlooksStyleFunc_drawControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_drawControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ControlElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.drawControl", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_drawItemPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemPixmap", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg3_auto_ptr;
        QPixmap* cpp_arg3 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg3);
        // drawItemPixmap(QPainter*,QRect,int,QPixmap)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::drawItemPixmap(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
    } else goto SbkQCleanlooksStyleFunc_drawItemPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_drawItemPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.drawItemPixmap", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_drawItemText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemText", 6, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QPalette& >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QString& >::isConvertible(pyargs[5])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPalette > cpp_arg3_auto_ptr;
        QPalette* cpp_arg3 = Shiboken::Converter<QPalette* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QPalette& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPalette >(cpp_arg3);
        bool cpp_arg4 = Shiboken::Converter<bool >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return 0;
        std::auto_ptr<QString > cpp_arg5_auto_ptr;
        QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
        if (numArgs == 6) {
            // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            cppSelf->QCleanlooksStyle::drawItemText(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5);
        } else if (Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[6])) {
            QPalette::ColorRole cpp_arg6 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[6]);
            // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            cppSelf->QCleanlooksStyle::drawItemText(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5, cpp_arg6);
        } else goto SbkQCleanlooksStyleFunc_drawItemText_TypeError;
    } else goto SbkQCleanlooksStyleFunc_drawItemText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_drawItemText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, int, PySide.QtGui.QPalette, bool, PySide.QtCore.QString, PySide.QtGui.QPalette.ColorRole = QPalette.NoRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.drawItemText", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_drawPrimitive(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawPrimitive", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::PrimitiveElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPainter* >::isConvertible(pyargs[2])) {
        QStyle::PrimitiveElement cpp_arg0 = Shiboken::Converter<QStyle::PrimitiveElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPainter* cpp_arg2 = Shiboken::Converter<QPainter* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            cppSelf->QCleanlooksStyle::drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            cppSelf->QCleanlooksStyle::drawPrimitive(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        } else goto SbkQCleanlooksStyleFunc_drawPrimitive_TypeError;
    } else goto SbkQCleanlooksStyleFunc_drawPrimitive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_drawPrimitive_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PrimitiveElement, PySide.QtGui.QStyleOption, PySide.QtGui.QPainter, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.drawPrimitive", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_generatedIconPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "generatedIconPixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[2])) {
        QIcon::Mode cpp_arg0 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOption* cpp_arg2 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[2]);
        // generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QCleanlooksStyle::generatedIconPixmap(cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    } else goto SbkQCleanlooksStyleFunc_generatedIconPixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_generatedIconPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon.Mode, PySide.QtGui.QPixmap, PySide.QtGui.QStyleOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.generatedIconPixmap", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_hitTestComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "hitTestComplexControl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QPoint& >::isConvertible(pyargs[2])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPoint > cpp_arg2_auto_ptr;
        QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPoint& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPoint >(cpp_arg2);
        if (numArgs == 3) {
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            QStyle::SubControl cpp_result = cppSelf->QCleanlooksStyle::hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            QStyle::SubControl cpp_result = cppSelf->QCleanlooksStyle::hitTestComplexControl(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QStyle::SubControl >::toPython(cpp_result);
        } else goto SbkQCleanlooksStyleFunc_hitTestComplexControl_TypeError;
    } else goto SbkQCleanlooksStyleFunc_hitTestComplexControl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_hitTestComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtCore.QPoint, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.hitTestComplexControl", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_itemPixmapRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "itemPixmapRect", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QPixmap& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg2_auto_ptr;
        QPixmap* cpp_arg2 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QPixmap& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg2);
        // itemPixmapRect(QRect,int,QPixmap)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QCleanlooksStyle::itemPixmapRect(*cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQCleanlooksStyleFunc_itemPixmapRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_itemPixmapRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.itemPixmapRect", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_pixelMetric(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "pixelMetric", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::PixelMetric >::isConvertible(pyargs[0])) {
        QStyle::PixelMetric cpp_arg0 = Shiboken::Converter<QStyle::PixelMetric >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QCleanlooksStyle::pixelMetric(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QCleanlooksStyle::pixelMetric(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
                QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QCleanlooksStyle::pixelMetric(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else goto SbkQCleanlooksStyleFunc_pixelMetric_TypeError;
        } else goto SbkQCleanlooksStyleFunc_pixelMetric_TypeError;
    } else goto SbkQCleanlooksStyleFunc_pixelMetric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_pixelMetric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PixelMetric, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.pixelMetric", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_polish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // polish(QWidget*)
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::polish(cpp_arg0);
    } else if (Shiboken::Converter<QPalette& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPalette > cpp_arg0_auto_ptr;
        QPalette* cpp_arg0 = Shiboken::Converter<QPalette* >::toCpp(arg);
        if (!Shiboken::Converter<QPalette& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPalette >(cpp_arg0);
        // polish(QPalette&)
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::polish(*cpp_arg0);
    } else if (Shiboken::Converter<QApplication* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // polish(QApplication*)
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::polish(cpp_arg0);
    } else goto SbkQCleanlooksStyleFunc_polish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_polish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QPalette", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCleanlooksStyle.polish", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_sizeFromContents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sizeFromContents", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ContentsType >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1]) && Shiboken::Converter<QSize& >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ContentsType cpp_arg0 = Shiboken::Converter<QStyle::ContentsType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QSize* cpp_arg2 = Shiboken::Converter<QSize* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QCleanlooksStyle::sizeFromContents(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQCleanlooksStyleFunc_sizeFromContents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_sizeFromContents_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ContentsType, PySide.QtGui.QStyleOption, PySide.QtCore.QSize, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.sizeFromContents", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_standardIconImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "standardIconImplementation", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::StandardPixmap >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
        QStyle::StandardPixmap cpp_arg0 = Shiboken::Converter<QStyle::StandardPixmap >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QCleanlooksStyle::standardIconImplementation(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // standardIconImplementation(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            QIcon cpp_result = cppSelf->QCleanlooksStyle::standardIconImplementation(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        } else goto SbkQCleanlooksStyleFunc_standardIconImplementation_TypeError;
    } else goto SbkQCleanlooksStyleFunc_standardIconImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_standardIconImplementation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StandardPixmap, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.standardIconImplementation", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_standardPalette(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // standardPalette()const
    QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
    QPalette cpp_result = cppSelf->QCleanlooksStyle::standardPalette();
    py_result = Shiboken::Converter<QPalette >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCleanlooksStyleFunc_styleHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "styleHint", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QStyle::StyleHint >::isConvertible(pyargs[0])) {
        QStyle::StyleHint cpp_arg0 = Shiboken::Converter<QStyle::StyleHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QCleanlooksStyle::styleHint(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
        } else if (Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QCleanlooksStyle::styleHint(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
            } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                    QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
                    int cpp_result = cppSelf->QCleanlooksStyle::styleHint(cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<int >::toPython(cpp_result);
                } else if (Shiboken::Converter<QStyleHintReturn* >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    QStyleHintReturn* cpp_arg3 = Shiboken::Converter<QStyleHintReturn* >::toCpp(pyargs[3]);
                    // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                    QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
                    int cpp_result = cppSelf->QCleanlooksStyle::styleHint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<int >::toPython(cpp_result);
                } else goto SbkQCleanlooksStyleFunc_styleHint_TypeError;
            } else goto SbkQCleanlooksStyleFunc_styleHint_TypeError;
        } else goto SbkQCleanlooksStyleFunc_styleHint_TypeError;
    } else goto SbkQCleanlooksStyleFunc_styleHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_styleHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.StyleHint, PySide.QtGui.QStyleOption = None, PySide.QtGui.QWidget = None, PySide.QtGui.QStyleHintReturn = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.styleHint", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_subControlRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subControlRect", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex* >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyle::SubControl >::isConvertible(pyargs[2]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[3])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        QStyle::SubControl cpp_arg2 = Shiboken::Converter<QStyle::SubControl >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
        // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QCleanlooksStyle::subControlRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQCleanlooksStyleFunc_subControlRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_subControlRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex, PySide.QtGui.QStyle.SubControl, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.subControlRect", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_subElementRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "subElementRect", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QStyle::SubElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption* >::isConvertible(pyargs[1])) {
        QStyle::SubElement cpp_arg0 = Shiboken::Converter<QStyle::SubElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->QCleanlooksStyle::subElementRect(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
            QRect cpp_result = cppSelf->QCleanlooksStyle::subElementRect(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        } else goto SbkQCleanlooksStyleFunc_subElementRect_TypeError;
    } else goto SbkQCleanlooksStyleFunc_subElementRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCleanlooksStyleFunc_subElementRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.SubElement, PySide.QtGui.QStyleOption, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCleanlooksStyle.subElementRect", overloads);
        return 0;
}

static PyObject*
SbkQCleanlooksStyleFunc_unpolish(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // unpolish(QWidget*)
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::unpolish(cpp_arg0);
    } else if (Shiboken::Converter<QApplication* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QApplication* cpp_arg0 = Shiboken::Converter<QApplication* >::toCpp(arg);
        // unpolish(QApplication*)
        QCleanlooksStyle* cppSelf = Shiboken::Converter<QCleanlooksStyle* >::toCpp((PyObject*)self);
        cppSelf->QCleanlooksStyle::unpolish(cpp_arg0);
    } else goto SbkQCleanlooksStyleFunc_unpolish_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCleanlooksStyleFunc_unpolish_TypeError:
        const char* overloads[] = {"PySide.QtGui.QApplication", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCleanlooksStyle.unpolish", overloads);
        return 0;
}

static PyMethodDef SbkQCleanlooksStyle_methods[] = {
    {"drawComplexControl", (PyCFunction)SbkQCleanlooksStyleFunc_drawComplexControl, METH_VARARGS},
    {"drawControl", (PyCFunction)SbkQCleanlooksStyleFunc_drawControl, METH_VARARGS},
    {"drawItemPixmap", (PyCFunction)SbkQCleanlooksStyleFunc_drawItemPixmap, METH_VARARGS},
    {"drawItemText", (PyCFunction)SbkQCleanlooksStyleFunc_drawItemText, METH_VARARGS},
    {"drawPrimitive", (PyCFunction)SbkQCleanlooksStyleFunc_drawPrimitive, METH_VARARGS},
    {"generatedIconPixmap", (PyCFunction)SbkQCleanlooksStyleFunc_generatedIconPixmap, METH_VARARGS},
    {"hitTestComplexControl", (PyCFunction)SbkQCleanlooksStyleFunc_hitTestComplexControl, METH_VARARGS},
    {"itemPixmapRect", (PyCFunction)SbkQCleanlooksStyleFunc_itemPixmapRect, METH_VARARGS},
    {"pixelMetric", (PyCFunction)SbkQCleanlooksStyleFunc_pixelMetric, METH_VARARGS},
    {"polish", (PyCFunction)SbkQCleanlooksStyleFunc_polish, METH_O},
    {"sizeFromContents", (PyCFunction)SbkQCleanlooksStyleFunc_sizeFromContents, METH_VARARGS},
    {"standardIconImplementation", (PyCFunction)SbkQCleanlooksStyleFunc_standardIconImplementation, METH_VARARGS},
    {"standardPalette", (PyCFunction)SbkQCleanlooksStyleFunc_standardPalette, METH_NOARGS},
    {"styleHint", (PyCFunction)SbkQCleanlooksStyleFunc_styleHint, METH_VARARGS},
    {"subControlRect", (PyCFunction)SbkQCleanlooksStyleFunc_subControlRect, METH_VARARGS},
    {"subElementRect", (PyCFunction)SbkQCleanlooksStyleFunc_subElementRect, METH_VARARGS},
    {"unpolish", (PyCFunction)SbkQCleanlooksStyleFunc_unpolish, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCleanlooksStyle_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QCleanlooksStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QCleanlooksStyleWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCleanlooksStyle_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCleanlooksStyle_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QCleanlooksStyle(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCLEANLOOKSSTYLE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCleanlooksStyle_Type);

    SbkQCleanlooksStyle_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWINDOWSSTYLE_IDX];
    // Fill type discovery information
    SbkQCleanlooksStyle_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQCleanlooksStyle_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCleanlooksStyle_Type));
    PyModule_AddObject(module, "QCleanlooksStyle",
        ((PyObject*)&SbkQCleanlooksStyle_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QCleanlooksStyle >("QCleanlooksStyle*");
    Shiboken::TypeResolver::createObjectTypeResolver<QCleanlooksStyle >(typeid(QCleanlooksStyle).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

