/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qabstractspinbox_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractspinbox.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractSpinBoxWrapper::QAbstractSpinBoxWrapper(QWidget * parent) : QAbstractSpinBox(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractSpinBoxWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::clear()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clear"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::clear();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::closeEvent(QCloseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::closeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::contextMenuEvent(QContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractSpinBoxWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractSpinBoxWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractSpinBoxWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::fixup(QString & input) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fixup"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::fixup(input);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(input)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractSpinBoxWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractSpinBoxWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::hideEvent(QHideEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::hideEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QAbstractSpinBoxWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::keyReleaseEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractSpinBoxWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QAbstractSpinBoxWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QAbstractSpinBoxWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QAbstractSpinBoxWrapper::paintEvent(QPaintEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::paintEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractSpinBoxWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QAbstractSpinBoxWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::stepBy(int steps)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stepBy"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::stepBy(steps);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        steps
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QAbstractSpinBox::StepEnabledFlag> QAbstractSpinBoxWrapper::stepEnabled() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stepEnabled"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::stepEnabled();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QAbstractSpinBox::StepEnabledFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.stepEnabled");
        return QFlags<QAbstractSpinBox::StepEnabledFlag>()        ;
    }
    QFlags<QAbstractSpinBox::StepEnabledFlag> cpp_result(Shiboken::Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractSpinBoxWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QValidator::State QAbstractSpinBoxWrapper::validate(QString & input, int & pos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validate"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::validate(input, pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(input),
        Shiboken::Converter<int >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QValidator::State();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QValidator::State >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractSpinBox.validate");
        return QValidator::State()        ;
    }
    QValidator::State cpp_result(Shiboken::Converter<QValidator::State >::toCpp(py_result));
    return cpp_result;
}

void QAbstractSpinBoxWrapper::wheelEvent(QWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractSpinBoxWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractSpinBox::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractSpinBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractSpinBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractSpinBoxWrapper::~QAbstractSpinBoxWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractSpinBox_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractSpinBoxWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractSpinBox", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractSpinBox(QWidget*)
        cptr = new QAbstractSpinBoxWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QAbstractSpinBox(QWidget*)
        cptr = new QAbstractSpinBoxWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractSpinBox_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractSpinBox_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractSpinBox_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractSpinBox", overloads);
        return -1;
}

static PyObject*
SbkQAbstractSpinBoxFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QAbstractSpinBox::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_buttonSymbols(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttonSymbols()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QAbstractSpinBox::ButtonSymbols cpp_result = cppSelf->QAbstractSpinBox::buttonSymbols();
    py_result = Shiboken::Converter<QAbstractSpinBox::ButtonSymbols >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::changeEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.changeEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSpinBox::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSpinBoxFunc_closeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCloseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCloseEvent* cpp_arg0 = Shiboken::Converter<QCloseEvent* >::toCpp(arg);
        // closeEvent(QCloseEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::closeEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_closeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_closeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCloseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.closeEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::contextMenuEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.contextMenuEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_correctionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // correctionMode()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QAbstractSpinBox::CorrectionMode cpp_result = cppSelf->QAbstractSpinBox::correctionMode();
    py_result = Shiboken::Converter<QAbstractSpinBox::CorrectionMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractSpinBox::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractSpinBoxFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSpinBoxFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.event", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_fixup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fixup(QString&)const
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::fixup(*cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_fixup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_fixup_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.fixup", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::focusInEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::focusOutEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_hasAcceptableInput(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAcceptableInput()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSpinBox::hasAcceptableInput();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_hasFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFrame()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSpinBox::hasFrame();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::hideEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.hideEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QAbstractSpinBox::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQAbstractSpinBoxFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSpinBoxFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_interpretText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // interpretText()
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSpinBox::interpretText();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSpinBoxFunc_isAccelerated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAccelerated()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSpinBox::isAccelerated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_isReadOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadOnly()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSpinBox::isReadOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::keyPressEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::keyReleaseEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.keyReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_keyboardTracking(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyboardTracking()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSpinBox::keyboardTracking();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_lineEdit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineEdit()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QLineEdit * cpp_result = cppSelf->QAbstractSpinBox::lineEdit();
    py_result = Shiboken::Converter<QLineEdit* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QAbstractSpinBox::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::mouseMoveEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::mousePressEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::paintEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.paintEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::resizeEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_selectAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // selectAll()
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSpinBox::selectAll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setAccelerated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAccelerated(bool)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setAccelerated(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setAccelerated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setAccelerated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setAccelerated", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setAlignment(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setAlignment", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setButtonSymbols(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractSpinBox::ButtonSymbols >::isConvertible(arg)) {
        QAbstractSpinBox::ButtonSymbols cpp_arg0 = Shiboken::Converter<QAbstractSpinBox::ButtonSymbols >::toCpp(arg);
        // setButtonSymbols(QAbstractSpinBox::ButtonSymbols)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setButtonSymbols(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setButtonSymbols_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setButtonSymbols_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractSpinBox.ButtonSymbols", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setButtonSymbols", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setCorrectionMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractSpinBox::CorrectionMode >::isConvertible(arg)) {
        QAbstractSpinBox::CorrectionMode cpp_arg0 = Shiboken::Converter<QAbstractSpinBox::CorrectionMode >::toCpp(arg);
        // setCorrectionMode(QAbstractSpinBox::CorrectionMode)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setCorrectionMode(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setCorrectionMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setCorrectionMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractSpinBox.CorrectionMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setCorrectionMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFrame(bool)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setFrame(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setFrame_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setFrame", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setKeyboardTracking(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setKeyboardTracking(bool)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setKeyboardTracking(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setKeyboardTracking_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setKeyboardTracking_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setKeyboardTracking", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setLineEdit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLineEdit* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLineEdit* cpp_arg0 = Shiboken::Converter<QLineEdit* >::toCpp(arg);
        // setLineEdit(QLineEdit*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setLineEdit(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractSpinBoxFunc_setLineEdit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setLineEdit_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLineEdit", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setLineEdit", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setReadOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadOnly(bool)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setReadOnly(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setReadOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setReadOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setReadOnly", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setSpecialValueText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setSpecialValueText(QString)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setSpecialValueText(*cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setSpecialValueText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setSpecialValueText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setSpecialValueText", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_setWrapping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWrapping(bool)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::setWrapping(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_setWrapping_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_setWrapping_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.setWrapping", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::showEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.showEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QAbstractSpinBox::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_specialValueText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // specialValueText()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAbstractSpinBox::specialValueText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_stepBy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // stepBy(int)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::stepBy(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_stepBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_stepBy_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.stepBy", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_stepDown(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stepDown()
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSpinBox::stepDown();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSpinBoxFunc_stepEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stepEnabled()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QFlags<QAbstractSpinBox::StepEnabledFlag> cpp_result = cppSelf->QAbstractSpinBox::stepEnabled();
    py_result = Shiboken::Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_stepUp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stepUp()
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    cppSelf->QAbstractSpinBox::stepUp();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractSpinBoxFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAbstractSpinBox::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractSpinBoxFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::timerEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_validate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "validate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // validate(QString&,int&)const
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        QValidator::State cpp_result = cppSelf->QAbstractSpinBox::validate(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QValidator::State >::toPython(cpp_result);
    } else goto SbkQAbstractSpinBoxFunc_validate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractSpinBoxFunc_validate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractSpinBox.validate", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
        cppSelf->QAbstractSpinBox::wheelEvent(cpp_arg0);
    } else goto SbkQAbstractSpinBoxFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractSpinBoxFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractSpinBox.wheelEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractSpinBoxFunc_wrapping(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wrapping()const
    QAbstractSpinBox* cppSelf = Shiboken::Converter<QAbstractSpinBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractSpinBox::wrapping();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQAbstractSpinBox_methods[] = {
    {"alignment", (PyCFunction)SbkQAbstractSpinBoxFunc_alignment, METH_NOARGS},
    {"buttonSymbols", (PyCFunction)SbkQAbstractSpinBoxFunc_buttonSymbols, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQAbstractSpinBoxFunc_clear, METH_NOARGS},
    {"closeEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_closeEvent, METH_O},
    {"contextMenuEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_contextMenuEvent, METH_O},
    {"correctionMode", (PyCFunction)SbkQAbstractSpinBoxFunc_correctionMode, METH_NOARGS},
    {"event", (PyCFunction)SbkQAbstractSpinBoxFunc_event, METH_O},
    {"fixup", (PyCFunction)SbkQAbstractSpinBoxFunc_fixup, METH_O},
    {"focusInEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_focusInEvent, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_focusOutEvent, METH_O},
    {"hasAcceptableInput", (PyCFunction)SbkQAbstractSpinBoxFunc_hasAcceptableInput, METH_NOARGS},
    {"hasFrame", (PyCFunction)SbkQAbstractSpinBoxFunc_hasFrame, METH_NOARGS},
    {"hideEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_hideEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQAbstractSpinBoxFunc_inputMethodQuery, METH_O},
    {"interpretText", (PyCFunction)SbkQAbstractSpinBoxFunc_interpretText, METH_NOARGS},
    {"isAccelerated", (PyCFunction)SbkQAbstractSpinBoxFunc_isAccelerated, METH_NOARGS},
    {"isReadOnly", (PyCFunction)SbkQAbstractSpinBoxFunc_isReadOnly, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_keyReleaseEvent, METH_O},
    {"keyboardTracking", (PyCFunction)SbkQAbstractSpinBoxFunc_keyboardTracking, METH_NOARGS},
    {"lineEdit", (PyCFunction)SbkQAbstractSpinBoxFunc_lineEdit, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQAbstractSpinBoxFunc_minimumSizeHint, METH_NOARGS},
    {"mouseMoveEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_mouseReleaseEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_paintEvent, METH_O},
    {"resizeEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_resizeEvent, METH_O},
    {"selectAll", (PyCFunction)SbkQAbstractSpinBoxFunc_selectAll, METH_NOARGS},
    {"setAccelerated", (PyCFunction)SbkQAbstractSpinBoxFunc_setAccelerated, METH_O},
    {"setAlignment", (PyCFunction)SbkQAbstractSpinBoxFunc_setAlignment, METH_O},
    {"setButtonSymbols", (PyCFunction)SbkQAbstractSpinBoxFunc_setButtonSymbols, METH_O},
    {"setCorrectionMode", (PyCFunction)SbkQAbstractSpinBoxFunc_setCorrectionMode, METH_O},
    {"setFrame", (PyCFunction)SbkQAbstractSpinBoxFunc_setFrame, METH_O},
    {"setKeyboardTracking", (PyCFunction)SbkQAbstractSpinBoxFunc_setKeyboardTracking, METH_O},
    {"setLineEdit", (PyCFunction)SbkQAbstractSpinBoxFunc_setLineEdit, METH_O},
    {"setReadOnly", (PyCFunction)SbkQAbstractSpinBoxFunc_setReadOnly, METH_O},
    {"setSpecialValueText", (PyCFunction)SbkQAbstractSpinBoxFunc_setSpecialValueText, METH_O},
    {"setWrapping", (PyCFunction)SbkQAbstractSpinBoxFunc_setWrapping, METH_O},
    {"showEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQAbstractSpinBoxFunc_sizeHint, METH_NOARGS},
    {"specialValueText", (PyCFunction)SbkQAbstractSpinBoxFunc_specialValueText, METH_NOARGS},
    {"stepBy", (PyCFunction)SbkQAbstractSpinBoxFunc_stepBy, METH_O},
    {"stepDown", (PyCFunction)SbkQAbstractSpinBoxFunc_stepDown, METH_NOARGS},
    {"stepEnabled", (PyCFunction)SbkQAbstractSpinBoxFunc_stepEnabled, METH_NOARGS},
    {"stepUp", (PyCFunction)SbkQAbstractSpinBoxFunc_stepUp, METH_NOARGS},
    {"text", (PyCFunction)SbkQAbstractSpinBoxFunc_text, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_timerEvent, METH_O},
    {"validate", (PyCFunction)SbkQAbstractSpinBoxFunc_validate, METH_VARARGS},
    {"wheelEvent", (PyCFunction)SbkQAbstractSpinBoxFunc_wheelEvent, METH_O},
    {"wrapping", (PyCFunction)SbkQAbstractSpinBoxFunc_wrapping, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQAbstractSpinBoxSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QAbstractSpinBox* me = reinterpret_cast<QAbstractSpinBox*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractSpinBox_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractSpinBox",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractSpinBoxWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractSpinBox_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractSpinBox_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQAbstractSpinBoxSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toPython(
        ((QAbstractSpinBox::StepEnabled) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toPython(
        ((QAbstractSpinBox::StepEnabled) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toPython(
        ((QAbstractSpinBox::StepEnabled) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toPython(
        ~ Shiboken::Converter< QAbstractSpinBox::StepEnabled >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StepEnabledFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StepEnabled",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CorrectionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ButtonSymbols",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QAbstractSpinBox(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractSpinBox_Type);

    SbkQAbstractSpinBox_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQAbstractSpinBox_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQAbstractSpinBox_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractSpinBox_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractSpinBox_Type));
    PyModule_AddObject(module, "QAbstractSpinBox",
        ((PyObject*)&SbkQAbstractSpinBox_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StepEnabledFlag
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX] = &SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type);
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
            "StepEnabledFlag",((PyObject*)&SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type));

    // init flags class: QFlags<QAbstractSpinBox::StepEnabledFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG__IDX] = &SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Type);
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
            "StepEnabled",((PyObject*)&SbkPySide_QtGui_QAbstractSpinBox_StepEnabled_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type,
        (long) QAbstractSpinBox::StepNone, "StepNone");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "StepNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type.tp_dict,
        "StepNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type,
        (long) QAbstractSpinBox::StepUpEnabled, "StepUpEnabled");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "StepUpEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type.tp_dict,
        "StepUpEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type,
        (long) QAbstractSpinBox::StepDownEnabled, "StepDownEnabled");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "StepDownEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_StepEnabledFlag_Type.tp_dict,
        "StepDownEnabled", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSpinBox::StepEnabledFlag");

    // init enum class: CorrectionMode
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX] = &SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type);
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
            "CorrectionMode",((PyObject*)&SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type,
        (long) QAbstractSpinBox::CorrectToPreviousValue, "CorrectToPreviousValue");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "CorrectToPreviousValue", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type.tp_dict,
        "CorrectToPreviousValue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type,
        (long) QAbstractSpinBox::CorrectToNearestValue, "CorrectToNearestValue");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "CorrectToNearestValue", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_CorrectionMode_Type.tp_dict,
        "CorrectToNearestValue", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSpinBox::CorrectionMode");

    // init enum class: ButtonSymbols
    SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX] = &SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type);
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
            "ButtonSymbols",((PyObject*)&SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type,
        (long) QAbstractSpinBox::UpDownArrows, "UpDownArrows");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "UpDownArrows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type.tp_dict,
        "UpDownArrows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type,
        (long) QAbstractSpinBox::PlusMinus, "PlusMinus");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "PlusMinus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type.tp_dict,
        "PlusMinus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type,
        (long) QAbstractSpinBox::NoButtons, "NoButtons");
    PyDict_SetItemString(SbkQAbstractSpinBox_Type.super.ht_type.tp_dict,
        "NoButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractSpinBox_ButtonSymbols_Type.tp_dict,
        "NoButtons", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractSpinBox::ButtonSymbols");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractSpinBox >("QAbstractSpinBox*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractSpinBox >(typeid(QAbstractSpinBox).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

