/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qabstractproxymodel_wrapper.h"

// Extra includes
#include <QItemSelection>
#include <QList>
#include <QMap>
#include <QSize>
#include <QStringList>
#include <pysideconversions.h>
#include <qabstractitemmodel.h>
#include <qabstractproxymodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatastream.h>
#include <qitemselectionmodel.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractProxyModelWrapper::QAbstractProxyModelWrapper(QObject * parent) : QAbstractProxyModel(parent), m_metaObject(0) {
    // ... middle
}

QModelIndex QAbstractProxyModelWrapper::buddy(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "buddy"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::buddy(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.buddy");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::canFetchMore(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canFetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.canFetchMore");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractProxyModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractProxyModelWrapper::columnCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "columnCount"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.columnCount()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.columnCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractProxyModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractProxyModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QAbstractProxyModelWrapper::data(const QModelIndex & proxyIndex, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::data(proxyIndex, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oi)",
        Shiboken::Converter<QModelIndex& >::toPython(proxyIndex),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.data");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QAbstractProxyModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractProxyModelWrapper::dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOiiO)",
        Shiboken::Converter<QMimeData* >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action),
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.dropMimeData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAbstractProxyModelWrapper::fetchMore(const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::ItemFlag> QAbstractProxyModelWrapper::flags(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flags"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::flags(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::ItemFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.flags");
        return QFlags<Qt::ItemFlag>()        ;
    }
    QFlags<Qt::ItemFlag> cpp_result(Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::hasChildren(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasChildren"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::hasChildren(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.hasChildren");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QAbstractProxyModelWrapper::headerData(int section, Qt::Orientation orientation, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "headerData"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.headerData");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QAbstractProxyModelWrapper::index(int row, int column, const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "index"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.index()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        column,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.index");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::insertColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertColumns"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.insertColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::insertRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertRows"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.insertRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QMap<int, QVariant > QAbstractProxyModelWrapper::itemData(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemData"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::itemData(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QMap<int, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<int, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.itemData");
        return QMap<int, QVariant >()        ;
    }
    QMap<int, QVariant > cpp_result(Shiboken::Converter<QMap<int, QVariant > >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QAbstractProxyModelWrapper::mapFromSource(const QModelIndex & sourceIndex) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapFromSource"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapFromSource()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(sourceIndex)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.mapFromSource");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

QItemSelection QAbstractProxyModelWrapper::mapSelectionFromSource(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapSelectionFromSource"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::mapSelectionFromSource(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QItemSelection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QItemSelection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.mapSelectionFromSource");
        return QItemSelection()        ;
    }
    QItemSelection cpp_result(Shiboken::Converter<QItemSelection >::toCpp(py_result));
    return cpp_result;
}

QItemSelection QAbstractProxyModelWrapper::mapSelectionToSource(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapSelectionToSource"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::mapSelectionToSource(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QItemSelection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QItemSelection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.mapSelectionToSource");
        return QItemSelection()        ;
    }
    QItemSelection cpp_result(Shiboken::Converter<QItemSelection >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QAbstractProxyModelWrapper::mapToSource(const QModelIndex & proxyIndex) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mapToSource"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapToSource()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(proxyIndex)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.mapToSource");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

QList<QModelIndex > QAbstractProxyModelWrapper::match(const QModelIndex & start, int role, const QVariant & value, int hits, QFlags<Qt::MatchFlag> flags) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "match"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OiOiO)",
        Shiboken::Converter<QModelIndex& >::toPython(start),
        role,
        Shiboken::Converter<QVariant& >::toPython(value),
        hits,
        Shiboken::Converter<QFlags<Qt::MatchFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.match");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QMimeData * QAbstractProxyModelWrapper::mimeData(const QList<QModelIndex > & indexes) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QList<QModelIndex >  >::toPython(indexes)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.mimeData");
        return 0        ;
    }
    QMimeData* cpp_result(Shiboken::Converter<QMimeData* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

QStringList QAbstractProxyModelWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.mimeTypes");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QAbstractProxyModelWrapper::parent(const QModelIndex & child) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parent"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.parent()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(child)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.parent");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::removeColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeColumns"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        column,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.removeColumns");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::removeRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRows"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiO)",
        row,
        count,
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.removeRows");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractProxyModelWrapper::revert()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "revert"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::revert();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractProxyModelWrapper::rowCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowCount"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.rowCount()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.rowCount");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::setData(const QModelIndex & index, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOi)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.setData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::setHeaderData(int section, Qt::Orientation orientation, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHeaderData"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iOOi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        Shiboken::Converter<QVariant& >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.setHeaderData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::setItemData(const QModelIndex & index, const QMap<int, QVariant > & roles)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setItemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QMap<int, QVariant >  >::toPython(roles)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.setItemData");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractProxyModelWrapper::setSourceModel(QAbstractItemModel * sourceModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSourceModel"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::setSourceModel(sourceModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractItemModel* >::toPython(sourceModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractProxyModelWrapper::sort(int column, Qt::SortOrder order)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sort"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iO)",
        column,
        Shiboken::Converter<Qt::SortOrder >::toPython(order)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QAbstractProxyModelWrapper::span(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "span"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::span(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.span");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractProxyModelWrapper::submit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "submit"));
    if (py_override.isNull()) {
        return this->QAbstractProxyModel::submit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.submit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::DropAction> QAbstractProxyModelWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractProxyModel.supportedDropActions");
        return QFlags<Qt::DropAction>()        ;
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QAbstractProxyModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAbstractProxyModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractProxyModel::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractProxyModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractProxyModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractProxyModelWrapper::~QAbstractProxyModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractProxyModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractProxyModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTPROXYMODEL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractProxyModel' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractProxyModel", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractProxyModel(QObject*)
        cptr = new QAbstractProxyModelWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAbstractProxyModel(QObject*)
        cptr = new QAbstractProxyModelWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractProxyModel_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractProxyModel_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractProxyModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractProxyModel", overloads);
        return -1;
}

static PyObject*
SbkQAbstractProxyModelFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // data(QModelIndex,int)const
            QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QAbstractProxyModel::data(*cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // data(QModelIndex,int)const
            QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QAbstractProxyModel::data(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        } else goto SbkQAbstractProxyModelFunc_data_TypeError;
    } else goto SbkQAbstractProxyModelFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractProxyModel.data", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_flags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // flags(QModelIndex)const
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QFlags<Qt::ItemFlag> cpp_result = cppSelf->QAbstractProxyModel::flags(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_flags_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_flags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.flags", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_headerData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "headerData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // headerData(int,Qt::Orientation,int)const
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QAbstractProxyModel::headerData(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_headerData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_headerData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractProxyModel.headerData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_itemData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemData(QModelIndex)const
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QMap<int, QVariant > cpp_result = cppSelf->QAbstractProxyModel::itemData(*cpp_arg0);
        py_result = Shiboken::Converter<QMap<int, QVariant > >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_itemData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_itemData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.itemData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_mapFromSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // mapFromSource(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapFromSource()' not implemented.");
            return 0;
        }
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->mapFromSource(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_mapFromSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_mapFromSource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.mapFromSource", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_mapSelectionFromSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // mapSelectionFromSource(QItemSelection)const
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QItemSelection cpp_result = cppSelf->QAbstractProxyModel::mapSelectionFromSource(*cpp_arg0);
        py_result = Shiboken::Converter<QItemSelection >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_mapSelectionFromSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_mapSelectionFromSource_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.mapSelectionFromSource", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_mapSelectionToSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // mapSelectionToSource(QItemSelection)const
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QItemSelection cpp_result = cppSelf->QAbstractProxyModel::mapSelectionToSource(*cpp_arg0);
        py_result = Shiboken::Converter<QItemSelection >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_mapSelectionToSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_mapSelectionToSource_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.mapSelectionToSource", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_mapToSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // mapToSource(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapToSource()' not implemented.");
            return 0;
        }
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->mapToSource(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQAbstractProxyModelFunc_mapToSource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_mapToSource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.mapToSource", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_revert(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // revert()
    QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractProxyModel::revert();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractProxyModelFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // setData(QModelIndex,QVariant,int)
            QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractProxyModel::setData(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setData(QModelIndex,QVariant,int)
            QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractProxyModel::setData(*cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQAbstractProxyModelFunc_setData_TypeError;
    } else goto SbkQAbstractProxyModelFunc_setData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractProxyModel.setData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_setHeaderData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHeaderData", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractProxyModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractProxyModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQAbstractProxyModelFunc_setHeaderData_TypeError;
    } else goto SbkQAbstractProxyModelFunc_setHeaderData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractProxyModelFunc_setHeaderData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractProxyModel.setHeaderData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_setSourceModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setSourceModel(QAbstractItemModel*)
        QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractProxyModel::setSourceModel(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractProxyModelFunc_setSourceModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractProxyModelFunc_setSourceModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractProxyModel.setSourceModel", overloads);
        return 0;
}

static PyObject*
SbkQAbstractProxyModelFunc_sourceModel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sourceModel()const
    QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
    QAbstractItemModel * cpp_result = cppSelf->QAbstractProxyModel::sourceModel();
    py_result = Shiboken::Converter<QAbstractItemModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractProxyModelFunc_submit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // submit()
    QAbstractProxyModel* cppSelf = Shiboken::Converter<QAbstractProxyModel* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractProxyModel::submit();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQAbstractProxyModel_methods[] = {
    {"data", (PyCFunction)SbkQAbstractProxyModelFunc_data, METH_VARARGS},
    {"flags", (PyCFunction)SbkQAbstractProxyModelFunc_flags, METH_O},
    {"headerData", (PyCFunction)SbkQAbstractProxyModelFunc_headerData, METH_VARARGS},
    {"itemData", (PyCFunction)SbkQAbstractProxyModelFunc_itemData, METH_O},
    {"mapFromSource", (PyCFunction)SbkQAbstractProxyModelFunc_mapFromSource, METH_O},
    {"mapSelectionFromSource", (PyCFunction)SbkQAbstractProxyModelFunc_mapSelectionFromSource, METH_O},
    {"mapSelectionToSource", (PyCFunction)SbkQAbstractProxyModelFunc_mapSelectionToSource, METH_O},
    {"mapToSource", (PyCFunction)SbkQAbstractProxyModelFunc_mapToSource, METH_O},
    {"revert", (PyCFunction)SbkQAbstractProxyModelFunc_revert, METH_NOARGS},
    {"setData", (PyCFunction)SbkQAbstractProxyModelFunc_setData, METH_VARARGS},
    {"setHeaderData", (PyCFunction)SbkQAbstractProxyModelFunc_setHeaderData, METH_VARARGS},
    {"setSourceModel", (PyCFunction)SbkQAbstractProxyModelFunc_setSourceModel, METH_O},
    {"sourceModel", (PyCFunction)SbkQAbstractProxyModelFunc_sourceModel, METH_NOARGS},
    {"submit", (PyCFunction)SbkQAbstractProxyModelFunc_submit, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractProxyModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractProxyModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractProxyModelWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractProxyModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractProxyModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QAbstractProxyModel(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTPROXYMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractProxyModel_Type);

    SbkQAbstractProxyModel_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX];
    // Fill type discovery information
    SbkQAbstractProxyModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractProxyModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractProxyModel_Type));
    PyModule_AddObject(module, "QAbstractProxyModel",
        ((PyObject*)&SbkQAbstractProxyModel_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractProxyModel >("QAbstractProxyModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractProxyModel >(typeid(QAbstractProxyModel).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

