/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qabstractitemview_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractItemViewWrapper::QAbstractItemViewWrapper(QWidget * parent) : QAbstractItemView(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractItemViewWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QActionEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemViewWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QCloseEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemViewWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWidget* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QContextMenuEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::currentChanged(const QModelIndex & current, const QModelIndex & previous)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(current),
        Shiboken::Converter<QModelIndex& >::toPython(previous)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(topLeft),
        Shiboken::Converter<QModelIndex& >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractItemViewWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.devType");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragEnterEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::dragLeaveEvent(QDragLeaveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragLeaveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::dragMoveEvent(QDragMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDragMoveEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDropEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractItemViewWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.edit");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QAbstractItemViewWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QObject* >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QAbstractItemViewWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemViewWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractItemViewWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.focusNextPrevChild");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFocusEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractItemViewWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.heightForWidth");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QHideEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractItemViewWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.horizontalOffset()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.horizontalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QAbstractItemViewWrapper::indexAt(const QPoint & point) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.indexAt()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPoint& >::toPython(point)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.indexAt");
        return QModelIndex()        ;
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QInputMethodEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QAbstractItemViewWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.inputMethodQuery");
        return QVariant()        ;
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemViewWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.isIndexHidden()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.isIndexHidden");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QKeyEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemViewWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractItemViewWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.metric");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QAbstractItemViewWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.minimumSizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMouseEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QAbstractItemViewWrapper::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
{
    #warning Pure virtual method "QAbstractItemView::moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)" must be implement but was completely removed on typesystem.
    return QModelIndex();
}

void QAbstractItemViewWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QMoveEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QAbstractItemViewWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.paintEngine");
        return 0        ;
    }
    QPaintEngine* cpp_result(Shiboken::Converter<QPaintEngine* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QAbstractItemViewWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QPaintEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QResizeEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Oii)",
        Shiboken::Converter<QModelIndex& >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.scrollTo()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QAbstractItemViewWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.selectedIndexes");
        return QList<QModelIndex >()        ;
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QItemSelection& >::toPython(selected),
        Shiboken::Converter<QItemSelection& >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QAbstractItemViewWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QModelIndex& >::toPython(index),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.selectionCommand");
        return QFlags<QItemSelectionModel::SelectionFlag>()        ;
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAbstractItemViewWrapper::setModel(QAbstractItemModel * model)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModel"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setModel(model);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractItemModel* >::toPython(model)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.setSelection()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QRect& >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelectionModel* >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QShowEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QAbstractItemViewWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QAbstractItemViewWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.sizeHintForColumn");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QAbstractItemViewWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.sizeHintForRow");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTabletEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemViewWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractItemViewWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.verticalOffset()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.verticalOffset");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemViewWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QAbstractItemViewWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.viewOptions");
        return QStyleOptionViewItem()        ;
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemViewWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.viewportEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QAbstractItemViewWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRect()' not implemented.");
        return QRect();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.visualRect");
        return QRect()        ;
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QAbstractItemViewWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRegionForSelection()' not implemented.");
        return QRegion();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QItemSelection& >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemView.visualRegionForSelection");
        return QRegion()        ;
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemViewWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QWheelEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractItemViewWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractItemView::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractItemViewWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractItemView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractItemViewWrapper::~QAbstractItemViewWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractItemView_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractItemViewWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractItemView' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractItemView", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractItemView(QWidget*)
        cptr = new QAbstractItemViewWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QAbstractItemView(QWidget*)
        cptr = new QAbstractItemViewWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractItemView_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractItemView_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractItemView_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView", overloads);
        return -1;
}

static PyObject*
SbkQAbstractItemViewFunc_alternatingRowColors(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alternatingRowColors()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemView::alternatingRowColors();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_autoScrollMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoScrollMargin()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractItemView::autoScrollMargin();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_clearSelection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearSelection()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::clearSelection();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_closeEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "closeEditor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        QAbstractItemDelegate::EndEditHint cpp_arg1 = Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toCpp(pyargs[1]);
        // closeEditor(QWidget*,QAbstractItemDelegate::EndEditHint)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::closeEditor(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_closeEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_closeEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QAbstractItemDelegate.EndEditHint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.closeEditor", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_closePersistentEditor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // closePersistentEditor(QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::closePersistentEditor(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_closePersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_closePersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.closePersistentEditor", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_commitData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // commitData(QWidget*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::commitData(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_commitData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_commitData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.commitData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_currentChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "currentChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // currentChanged(QModelIndex,QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::currentChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_currentChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_currentChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.currentChanged", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QAbstractItemView::currentIndex();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_dataChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dataChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // dataChanged(QModelIndex,QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::dataChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_dataChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_dataChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.dataChanged", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_defaultDropAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultDropAction()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    Qt::DropAction cpp_result = cppSelf->QAbstractItemView::defaultDropAction();
    py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_dirtyRegionOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dirtyRegionOffset()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QAbstractItemView::dirtyRegionOffset();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_doAutoScroll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doAutoScroll()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::doAutoScroll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_doItemsLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doItemsLayout()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::doItemsLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_dragDropMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dragDropMode()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::DragDropMode cpp_result = cppSelf->QAbstractItemView::dragDropMode();
    py_result = Shiboken::Converter<QAbstractItemView::DragDropMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_dragDropOverwriteMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dragDropOverwriteMode()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemView::dragDropOverwriteMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_dragEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dragEnabled()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemView::dragEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::dragEnterEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.dragEnterEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::dragLeaveEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.dragLeaveEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::dragMoveEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.dragMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::dropEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.dropEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_dropIndicatorPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dropIndicatorPosition()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::DropIndicatorPosition cpp_result = cppSelf->QAbstractItemView::dropIndicatorPosition();
    py_result = Shiboken::Converter<QAbstractItemView::DropIndicatorPosition >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_edit(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQAbstractItemViewFunc_edit_TypeError;

    if (!PyArg_UnpackTuple(args, "edit", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // edit(QModelIndex)
            QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
            cppSelf->QAbstractItemView::edit(*cpp_arg0);
            py_result = Py_None;
            Py_INCREF(Py_None);
        } else if (numArgs == 3 && Shiboken::Converter<QAbstractItemView::EditTrigger >::isConvertible(pyargs[1]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[2])) {
            QAbstractItemView::EditTrigger cpp_arg1 = Shiboken::Converter<QAbstractItemView::EditTrigger >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QEvent* cpp_arg2 = Shiboken::Converter<QEvent* >::toCpp(pyargs[2]);
            // edit(QModelIndex,QAbstractItemView::EditTrigger,QEvent*)
            QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemView::edit(*cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQAbstractItemViewFunc_edit_TypeError;
    } else goto SbkQAbstractItemViewFunc_edit_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_edit_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", "PySide.QtCore.QModelIndex, PySide.QtGui.QAbstractItemView.EditTrigger, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.edit", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_editTriggers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // editTriggers()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QFlags<QAbstractItemView::EditTrigger> cpp_result = cppSelf->QAbstractItemView::editTriggers();
    py_result = Shiboken::Converter<QFlags<QAbstractItemView::EditTrigger> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_editorDestroyed(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // editorDestroyed(QObject*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::editorDestroyed(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_editorDestroyed_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_editorDestroyed_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.editorDestroyed", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemView::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.event", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_executeDelayedItemsLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // executeDelayedItemsLayout()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::executeDelayedItemsLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::focusInEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.focusInEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemView::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.focusNextPrevChild", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::focusOutEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.focusOutEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_hasAutoScroll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAutoScroll()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemView::hasAutoScroll();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_horizontalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalOffset()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.horizontalOffset()' not implemented.");
        return 0;
    }
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->horizontalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_horizontalScrollMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalScrollMode()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::ScrollMode cpp_result = cppSelf->QAbstractItemView::horizontalScrollMode();
    py_result = Shiboken::Converter<QAbstractItemView::ScrollMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_horizontalScrollbarAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // horizontalScrollbarAction(int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::horizontalScrollbarAction(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_horizontalScrollbarAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_horizontalScrollbarAction_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.horizontalScrollbarAction", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_horizontalScrollbarValueChanged(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // horizontalScrollbarValueChanged(int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::horizontalScrollbarValueChanged(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_horizontalScrollbarValueChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_horizontalScrollbarValueChanged_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.horizontalScrollbarValueChanged", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_iconSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconSize()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QAbstractItemView::iconSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_indexAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // indexAt(QPoint)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.indexAt()' not implemented.");
            return 0;
        }
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->indexAt(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_indexAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_indexAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.indexAt", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_indexWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // indexWidget(QModelIndex)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QAbstractItemView::indexWidget(*cpp_arg0);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractItemViewFunc_indexWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_indexWidget_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.indexWidget", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::inputMethodEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.inputMethodEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QAbstractItemView::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.inputMethodQuery", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_isIndexHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // isIndexHidden(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.isIndexHidden()' not implemented.");
            return 0;
        }
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->isIndexHidden(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_isIndexHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_isIndexHidden_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.isIndexHidden", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_itemDelegate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // itemDelegate()const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QAbstractItemDelegate * cpp_result = cppSelf->QAbstractItemView::itemDelegate();
        py_result = Shiboken::Converter<QAbstractItemDelegate* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemDelegate(QModelIndex)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QAbstractItemDelegate * cpp_result = cppSelf->QAbstractItemView::itemDelegate(*cpp_arg0);
        py_result = Shiboken::Converter<QAbstractItemDelegate* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractItemViewFunc_itemDelegate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_itemDelegate_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.itemDelegate", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_itemDelegateForColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemDelegateForColumn(int)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QAbstractItemDelegate * cpp_result = cppSelf->QAbstractItemView::itemDelegateForColumn(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractItemDelegate* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractItemViewFunc_itemDelegateForColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_itemDelegateForColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.itemDelegateForColumn", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_itemDelegateForRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemDelegateForRow(int)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QAbstractItemDelegate * cpp_result = cppSelf->QAbstractItemView::itemDelegateForRow(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractItemDelegate* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractItemViewFunc_itemDelegateForRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_itemDelegateForRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.itemDelegateForRow", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::keyPressEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.keyPressEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_keyboardSearch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // keyboardSearch(QString)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::keyboardSearch(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_keyboardSearch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_keyboardSearch_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.keyboardSearch", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemModel * cpp_result = cppSelf->QAbstractItemView::model();
    py_result = Shiboken::Converter<QAbstractItemModel* >::toPython(cpp_result);

    // Ownership transferences.

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::mouseDoubleClickEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::mouseMoveEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.mouseMoveEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::mousePressEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.mousePressEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::mouseReleaseEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_openPersistentEditor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // openPersistentEditor(QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::openPersistentEditor(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_openPersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_openPersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.openPersistentEditor", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::resizeEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.resizeEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_rootIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rootIndex()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QAbstractItemView::rootIndex();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_rowsAboutToBeRemoved(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsAboutToBeRemoved", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsAboutToBeRemoved(QModelIndex,int,int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::rowsAboutToBeRemoved(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQAbstractItemViewFunc_rowsAboutToBeRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_rowsAboutToBeRemoved_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.rowsAboutToBeRemoved", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_rowsInserted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsInserted", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsInserted(QModelIndex,int,int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::rowsInserted(*cpp_arg0, cpp_arg1, cpp_arg2);
    } else goto SbkQAbstractItemViewFunc_rowsInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_rowsInserted_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.rowsInserted", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_scheduleDelayedItemsLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // scheduleDelayedItemsLayout()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::scheduleDelayedItemsLayout();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_scrollDirtyRegion(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollDirtyRegion", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollDirtyRegion(int,int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::scrollDirtyRegion(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_scrollDirtyRegion_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_scrollDirtyRegion_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.scrollDirtyRegion", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_scrollTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.scrollTo()' not implemented.");
                return 0;
            }
            QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
            cppSelf->scrollTo(*cpp_arg0);
        } else if (Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
            QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.scrollTo()' not implemented.");
                return 0;
            }
            QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
            cppSelf->scrollTo(*cpp_arg0, cpp_arg1);
        } else goto SbkQAbstractItemViewFunc_scrollTo_TypeError;
    } else goto SbkQAbstractItemViewFunc_scrollTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_scrollTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QAbstractItemView.ScrollHint = EnsureVisible", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.scrollTo", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_scrollToBottom(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // scrollToBottom()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::scrollToBottom();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_scrollToTop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // scrollToTop()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::scrollToTop();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_selectAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // selectAll()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::selectAll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_selectedIndexes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedIndexes()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QAbstractItemView::selectedIndexes();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_selectionBehavior(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionBehavior()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::SelectionBehavior cpp_result = cppSelf->QAbstractItemView::selectionBehavior();
    py_result = Shiboken::Converter<QAbstractItemView::SelectionBehavior >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_selectionChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "selectionChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[0]) && Shiboken::Converter<QItemSelection& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemSelection* cpp_arg1 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[1]);
        // selectionChanged(QItemSelection,QItemSelection)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::selectionChanged(*cpp_arg0, *cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_selectionChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_selectionChanged_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection, PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.selectionChanged", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_selectionCommand(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "selectionCommand", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // selectionCommand(QModelIndex,const QEvent*)const
            QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
            QFlags<QItemSelectionModel::SelectionFlag> cpp_result = cppSelf->QAbstractItemView::selectionCommand(*cpp_arg0);
            py_result = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(cpp_result);
        } else if (Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
            // selectionCommand(QModelIndex,const QEvent*)const
            QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
            QFlags<QItemSelectionModel::SelectionFlag> cpp_result = cppSelf->QAbstractItemView::selectionCommand(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(cpp_result);
        } else goto SbkQAbstractItemViewFunc_selectionCommand_TypeError;
    } else goto SbkQAbstractItemViewFunc_selectionCommand_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_selectionCommand_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QEvent = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.selectionCommand", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_selectionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionMode()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::SelectionMode cpp_result = cppSelf->QAbstractItemView::selectionMode();
    py_result = Shiboken::Converter<QAbstractItemView::SelectionMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_selectionModel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionModel()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QItemSelectionModel * cpp_result = cppSelf->QAbstractItemView::selectionModel();
    py_result = Shiboken::Converter<QItemSelectionModel* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_setAlternatingRowColors(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAlternatingRowColors(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setAlternatingRowColors(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setAlternatingRowColors_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setAlternatingRowColors_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setAlternatingRowColors", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setAutoScroll(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoScroll(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setAutoScroll(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setAutoScroll_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setAutoScroll_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setAutoScroll", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setAutoScrollMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAutoScrollMargin(int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setAutoScrollMargin(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setAutoScrollMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setAutoScrollMargin_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setAutoScrollMargin", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setCurrentIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setCurrentIndex(QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setCurrentIndex(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setCurrentIndex", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setDefaultDropAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::DropAction >::isConvertible(arg)) {
        Qt::DropAction cpp_arg0 = Shiboken::Converter<Qt::DropAction >::toCpp(arg);
        // setDefaultDropAction(Qt::DropAction)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setDefaultDropAction(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setDefaultDropAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setDefaultDropAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setDefaultDropAction", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setDirtyRegion(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRegion& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(arg);
        if (!Shiboken::Converter<QRegion& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        // setDirtyRegion(QRegion)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setDirtyRegion(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setDirtyRegion_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setDirtyRegion_TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setDirtyRegion", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setDragDropMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView::DragDropMode >::isConvertible(arg)) {
        QAbstractItemView::DragDropMode cpp_arg0 = Shiboken::Converter<QAbstractItemView::DragDropMode >::toCpp(arg);
        // setDragDropMode(QAbstractItemView::DragDropMode)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setDragDropMode(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setDragDropMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setDragDropMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.DragDropMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setDragDropMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setDragDropOverwriteMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDragDropOverwriteMode(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setDragDropOverwriteMode(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setDragDropOverwriteMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setDragDropOverwriteMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setDragDropOverwriteMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setDragEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDragEnabled(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setDragEnabled(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setDragEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setDragEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setDragEnabled", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setDropIndicatorShown(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDropIndicatorShown(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setDropIndicatorShown(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setDropIndicatorShown_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setDropIndicatorShown_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setDropIndicatorShown", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setEditTriggers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QAbstractItemView_EditTrigger_Check(arg)) {
        QFlags<QAbstractItemView::EditTrigger> cpp_arg0 = Shiboken::Converter<QFlags<QAbstractItemView::EditTrigger> >::toCpp(arg);
        // setEditTriggers(QFlags<QAbstractItemView::EditTrigger>)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setEditTriggers(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setEditTriggers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setEditTriggers_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.EditTriggers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setEditTriggers", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setHorizontalScrollMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView::ScrollMode >::isConvertible(arg)) {
        QAbstractItemView::ScrollMode cpp_arg0 = Shiboken::Converter<QAbstractItemView::ScrollMode >::toCpp(arg);
        // setHorizontalScrollMode(QAbstractItemView::ScrollMode)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setHorizontalScrollMode(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setHorizontalScrollMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setHorizontalScrollMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.ScrollMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setHorizontalScrollMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setIconSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setIconSize(QSize)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setIconSize(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setIconSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setIconSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setIconSize", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setIndexWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setIndexWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // setIndexWidget(QModelIndex,QWidget*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setIndexWidget(*cpp_arg0, cpp_arg1);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQAbstractItemViewFunc_setIndexWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setIndexWidget_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.setIndexWidget", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setItemDelegate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemDelegate* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemDelegate* cpp_arg0 = Shiboken::Converter<QAbstractItemDelegate* >::toCpp(arg);
        // setItemDelegate(QAbstractItemDelegate*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setItemDelegate(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setItemDelegate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setItemDelegate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemDelegate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setItemDelegate", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setItemDelegateForColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemDelegateForColumn", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QAbstractItemDelegate* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemDelegate* cpp_arg1 = Shiboken::Converter<QAbstractItemDelegate* >::toCpp(pyargs[1]);
        // setItemDelegateForColumn(int,QAbstractItemDelegate*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setItemDelegateForColumn(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_setItemDelegateForColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setItemDelegateForColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QAbstractItemDelegate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.setItemDelegateForColumn", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setItemDelegateForRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemDelegateForRow", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QAbstractItemDelegate* >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemDelegate* cpp_arg1 = Shiboken::Converter<QAbstractItemDelegate* >::toCpp(pyargs[1]);
        // setItemDelegateForRow(int,QAbstractItemDelegate*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setItemDelegateForRow(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_setItemDelegateForRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setItemDelegateForRow_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QAbstractItemDelegate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.setItemDelegateForRow", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setModel(QAbstractItemModel*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setModel(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setModel", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setRootIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setRootIndex(QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setRootIndex(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setRootIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setRootIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setRootIndex", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QRect& >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.setSelection()' not implemented.");
            return 0;
        }
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->setSelection(*cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractItemViewFunc_setSelection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setSelection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemView.setSelection", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setSelectionBehavior(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView::SelectionBehavior >::isConvertible(arg)) {
        QAbstractItemView::SelectionBehavior cpp_arg0 = Shiboken::Converter<QAbstractItemView::SelectionBehavior >::toCpp(arg);
        // setSelectionBehavior(QAbstractItemView::SelectionBehavior)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setSelectionBehavior(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setSelectionBehavior_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setSelectionBehavior_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.SelectionBehavior", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setSelectionBehavior", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setSelectionMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView::SelectionMode >::isConvertible(arg)) {
        QAbstractItemView::SelectionMode cpp_arg0 = Shiboken::Converter<QAbstractItemView::SelectionMode >::toCpp(arg);
        // setSelectionMode(QAbstractItemView::SelectionMode)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setSelectionMode(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setSelectionMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setSelectionMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.SelectionMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setSelectionMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setSelectionModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionModel* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionModel* cpp_arg0 = Shiboken::Converter<QItemSelectionModel* >::toCpp(arg);
        // setSelectionModel(QItemSelectionModel*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setSelectionModel(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setSelectionModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setSelectionModel_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setSelectionModel", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView::State >::isConvertible(arg)) {
        QAbstractItemView::State cpp_arg0 = Shiboken::Converter<QAbstractItemView::State >::toCpp(arg);
        // setState(QAbstractItemView::State)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setState(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setState_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.State", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setState", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setTabKeyNavigation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTabKeyNavigation(bool)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setTabKeyNavigation(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setTabKeyNavigation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setTabKeyNavigation_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setTabKeyNavigation", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setTextElideMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TextElideMode >::isConvertible(arg)) {
        Qt::TextElideMode cpp_arg0 = Shiboken::Converter<Qt::TextElideMode >::toCpp(arg);
        // setTextElideMode(Qt::TextElideMode)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setTextElideMode(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setTextElideMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setTextElideMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextElideMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setTextElideMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_setVerticalScrollMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView::ScrollMode >::isConvertible(arg)) {
        QAbstractItemView::ScrollMode cpp_arg0 = Shiboken::Converter<QAbstractItemView::ScrollMode >::toCpp(arg);
        // setVerticalScrollMode(QAbstractItemView::ScrollMode)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::setVerticalScrollMode(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_setVerticalScrollMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_setVerticalScrollMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.ScrollMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.setVerticalScrollMode", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_showDropIndicator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // showDropIndicator()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemView::showDropIndicator();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_sizeHintForColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sizeHintForColumn(int)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QAbstractItemView::sizeHintForColumn(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_sizeHintForColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_sizeHintForColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.sizeHintForColumn", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_sizeHintForIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // sizeHintForIndex(QModelIndex)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QAbstractItemView::sizeHintForIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_sizeHintForIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_sizeHintForIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.sizeHintForIndex", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_sizeHintForRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sizeHintForRow(int)const
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QAbstractItemView::sizeHintForRow(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_sizeHintForRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_sizeHintForRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.sizeHintForRow", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_startAutoScroll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startAutoScroll()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::startAutoScroll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_startDrag(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_DropAction_Check(arg)) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(arg);
        // startDrag(QFlags<Qt::DropAction>)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::startDrag(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_startDrag_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_startDrag_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.startDrag", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::State cpp_result = cppSelf->QAbstractItemView::state();
    py_result = Shiboken::Converter<QAbstractItemView::State >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_stopAutoScroll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stopAutoScroll()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::stopAutoScroll();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_tabKeyNavigation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabKeyNavigation()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemView::tabKeyNavigation();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_textElideMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textElideMode()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    Qt::TextElideMode cpp_result = cppSelf->QAbstractItemView::textElideMode();
    py_result = Shiboken::Converter<Qt::TextElideMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::timerEvent(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.timerEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_update(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // update()
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::update();
    } else if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // update(QModelIndex)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::update(*cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_update_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_update_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.update", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_updateEditorData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateEditorData()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::updateEditorData();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_updateEditorGeometries(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateEditorGeometries()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::updateEditorGeometries();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_updateGeometries(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometries()
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemView::updateGeometries();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractItemViewFunc_verticalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalOffset()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.verticalOffset()' not implemented.");
        return 0;
    }
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->verticalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_verticalScrollMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalScrollMode()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QAbstractItemView::ScrollMode cpp_result = cppSelf->QAbstractItemView::verticalScrollMode();
    py_result = Shiboken::Converter<QAbstractItemView::ScrollMode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_verticalScrollbarAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // verticalScrollbarAction(int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::verticalScrollbarAction(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_verticalScrollbarAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_verticalScrollbarAction_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.verticalScrollbarAction", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_verticalScrollbarValueChanged(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // verticalScrollbarValueChanged(int)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemView::verticalScrollbarValueChanged(cpp_arg0);
    } else goto SbkQAbstractItemViewFunc_verticalScrollbarValueChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemViewFunc_verticalScrollbarValueChanged_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.verticalScrollbarValueChanged", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_viewOptions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewOptions()const
    QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
    QStyleOptionViewItem cpp_result = cppSelf->QAbstractItemView::viewOptions();
    py_result = Shiboken::Converter<QStyleOptionViewItem >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractItemViewFunc_viewportEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // viewportEvent(QEvent*)
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemView::viewportEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_viewportEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_viewportEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.viewportEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_visualRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // visualRect(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRect()' not implemented.");
            return 0;
        }
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->visualRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_visualRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_visualRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.visualRect", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemViewFunc_visualRegionForSelection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // visualRegionForSelection(QItemSelection)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemView.visualRegionForSelection()' not implemented.");
            return 0;
        }
        QAbstractItemView* cppSelf = Shiboken::Converter<QAbstractItemView* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->visualRegionForSelection(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    } else goto SbkQAbstractItemViewFunc_visualRegionForSelection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemViewFunc_visualRegionForSelection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractItemView.visualRegionForSelection", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractItemView_methods[] = {
    {"alternatingRowColors", (PyCFunction)SbkQAbstractItemViewFunc_alternatingRowColors, METH_NOARGS},
    {"autoScrollMargin", (PyCFunction)SbkQAbstractItemViewFunc_autoScrollMargin, METH_NOARGS},
    {"clearSelection", (PyCFunction)SbkQAbstractItemViewFunc_clearSelection, METH_NOARGS},
    {"closeEditor", (PyCFunction)SbkQAbstractItemViewFunc_closeEditor, METH_VARARGS},
    {"closePersistentEditor", (PyCFunction)SbkQAbstractItemViewFunc_closePersistentEditor, METH_O},
    {"commitData", (PyCFunction)SbkQAbstractItemViewFunc_commitData, METH_O},
    {"currentChanged", (PyCFunction)SbkQAbstractItemViewFunc_currentChanged, METH_VARARGS},
    {"currentIndex", (PyCFunction)SbkQAbstractItemViewFunc_currentIndex, METH_NOARGS},
    {"dataChanged", (PyCFunction)SbkQAbstractItemViewFunc_dataChanged, METH_VARARGS},
    {"defaultDropAction", (PyCFunction)SbkQAbstractItemViewFunc_defaultDropAction, METH_NOARGS},
    {"dirtyRegionOffset", (PyCFunction)SbkQAbstractItemViewFunc_dirtyRegionOffset, METH_NOARGS},
    {"doAutoScroll", (PyCFunction)SbkQAbstractItemViewFunc_doAutoScroll, METH_NOARGS},
    {"doItemsLayout", (PyCFunction)SbkQAbstractItemViewFunc_doItemsLayout, METH_NOARGS},
    {"dragDropMode", (PyCFunction)SbkQAbstractItemViewFunc_dragDropMode, METH_NOARGS},
    {"dragDropOverwriteMode", (PyCFunction)SbkQAbstractItemViewFunc_dragDropOverwriteMode, METH_NOARGS},
    {"dragEnabled", (PyCFunction)SbkQAbstractItemViewFunc_dragEnabled, METH_NOARGS},
    {"dragEnterEvent", (PyCFunction)SbkQAbstractItemViewFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQAbstractItemViewFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQAbstractItemViewFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQAbstractItemViewFunc_dropEvent, METH_O},
    {"dropIndicatorPosition", (PyCFunction)SbkQAbstractItemViewFunc_dropIndicatorPosition, METH_NOARGS},
    {"edit", (PyCFunction)SbkQAbstractItemViewFunc_edit, METH_VARARGS},
    {"editTriggers", (PyCFunction)SbkQAbstractItemViewFunc_editTriggers, METH_NOARGS},
    {"editorDestroyed", (PyCFunction)SbkQAbstractItemViewFunc_editorDestroyed, METH_O},
    {"event", (PyCFunction)SbkQAbstractItemViewFunc_event, METH_O},
    {"executeDelayedItemsLayout", (PyCFunction)SbkQAbstractItemViewFunc_executeDelayedItemsLayout, METH_NOARGS},
    {"focusInEvent", (PyCFunction)SbkQAbstractItemViewFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQAbstractItemViewFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQAbstractItemViewFunc_focusOutEvent, METH_O},
    {"hasAutoScroll", (PyCFunction)SbkQAbstractItemViewFunc_hasAutoScroll, METH_NOARGS},
    {"horizontalOffset", (PyCFunction)SbkQAbstractItemViewFunc_horizontalOffset, METH_NOARGS},
    {"horizontalScrollMode", (PyCFunction)SbkQAbstractItemViewFunc_horizontalScrollMode, METH_NOARGS},
    {"horizontalScrollbarAction", (PyCFunction)SbkQAbstractItemViewFunc_horizontalScrollbarAction, METH_O},
    {"horizontalScrollbarValueChanged", (PyCFunction)SbkQAbstractItemViewFunc_horizontalScrollbarValueChanged, METH_O},
    {"iconSize", (PyCFunction)SbkQAbstractItemViewFunc_iconSize, METH_NOARGS},
    {"indexAt", (PyCFunction)SbkQAbstractItemViewFunc_indexAt, METH_O},
    {"indexWidget", (PyCFunction)SbkQAbstractItemViewFunc_indexWidget, METH_O},
    {"inputMethodEvent", (PyCFunction)SbkQAbstractItemViewFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQAbstractItemViewFunc_inputMethodQuery, METH_O},
    {"isIndexHidden", (PyCFunction)SbkQAbstractItemViewFunc_isIndexHidden, METH_O},
    {"itemDelegate", (PyCFunction)SbkQAbstractItemViewFunc_itemDelegate, METH_NOARGS|METH_O},
    {"itemDelegateForColumn", (PyCFunction)SbkQAbstractItemViewFunc_itemDelegateForColumn, METH_O},
    {"itemDelegateForRow", (PyCFunction)SbkQAbstractItemViewFunc_itemDelegateForRow, METH_O},
    {"keyPressEvent", (PyCFunction)SbkQAbstractItemViewFunc_keyPressEvent, METH_O},
    {"keyboardSearch", (PyCFunction)SbkQAbstractItemViewFunc_keyboardSearch, METH_O},
    {"model", (PyCFunction)SbkQAbstractItemViewFunc_model, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQAbstractItemViewFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQAbstractItemViewFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQAbstractItemViewFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQAbstractItemViewFunc_mouseReleaseEvent, METH_O},
    {"openPersistentEditor", (PyCFunction)SbkQAbstractItemViewFunc_openPersistentEditor, METH_O},
    {"reset", (PyCFunction)SbkQAbstractItemViewFunc_reset, METH_NOARGS},
    {"resizeEvent", (PyCFunction)SbkQAbstractItemViewFunc_resizeEvent, METH_O},
    {"rootIndex", (PyCFunction)SbkQAbstractItemViewFunc_rootIndex, METH_NOARGS},
    {"rowsAboutToBeRemoved", (PyCFunction)SbkQAbstractItemViewFunc_rowsAboutToBeRemoved, METH_VARARGS},
    {"rowsInserted", (PyCFunction)SbkQAbstractItemViewFunc_rowsInserted, METH_VARARGS},
    {"scheduleDelayedItemsLayout", (PyCFunction)SbkQAbstractItemViewFunc_scheduleDelayedItemsLayout, METH_NOARGS},
    {"scrollDirtyRegion", (PyCFunction)SbkQAbstractItemViewFunc_scrollDirtyRegion, METH_VARARGS},
    {"scrollTo", (PyCFunction)SbkQAbstractItemViewFunc_scrollTo, METH_VARARGS},
    {"scrollToBottom", (PyCFunction)SbkQAbstractItemViewFunc_scrollToBottom, METH_NOARGS},
    {"scrollToTop", (PyCFunction)SbkQAbstractItemViewFunc_scrollToTop, METH_NOARGS},
    {"selectAll", (PyCFunction)SbkQAbstractItemViewFunc_selectAll, METH_NOARGS},
    {"selectedIndexes", (PyCFunction)SbkQAbstractItemViewFunc_selectedIndexes, METH_NOARGS},
    {"selectionBehavior", (PyCFunction)SbkQAbstractItemViewFunc_selectionBehavior, METH_NOARGS},
    {"selectionChanged", (PyCFunction)SbkQAbstractItemViewFunc_selectionChanged, METH_VARARGS},
    {"selectionCommand", (PyCFunction)SbkQAbstractItemViewFunc_selectionCommand, METH_VARARGS},
    {"selectionMode", (PyCFunction)SbkQAbstractItemViewFunc_selectionMode, METH_NOARGS},
    {"selectionModel", (PyCFunction)SbkQAbstractItemViewFunc_selectionModel, METH_NOARGS},
    {"setAlternatingRowColors", (PyCFunction)SbkQAbstractItemViewFunc_setAlternatingRowColors, METH_O},
    {"setAutoScroll", (PyCFunction)SbkQAbstractItemViewFunc_setAutoScroll, METH_O},
    {"setAutoScrollMargin", (PyCFunction)SbkQAbstractItemViewFunc_setAutoScrollMargin, METH_O},
    {"setCurrentIndex", (PyCFunction)SbkQAbstractItemViewFunc_setCurrentIndex, METH_O},
    {"setDefaultDropAction", (PyCFunction)SbkQAbstractItemViewFunc_setDefaultDropAction, METH_O},
    {"setDirtyRegion", (PyCFunction)SbkQAbstractItemViewFunc_setDirtyRegion, METH_O},
    {"setDragDropMode", (PyCFunction)SbkQAbstractItemViewFunc_setDragDropMode, METH_O},
    {"setDragDropOverwriteMode", (PyCFunction)SbkQAbstractItemViewFunc_setDragDropOverwriteMode, METH_O},
    {"setDragEnabled", (PyCFunction)SbkQAbstractItemViewFunc_setDragEnabled, METH_O},
    {"setDropIndicatorShown", (PyCFunction)SbkQAbstractItemViewFunc_setDropIndicatorShown, METH_O},
    {"setEditTriggers", (PyCFunction)SbkQAbstractItemViewFunc_setEditTriggers, METH_O},
    {"setHorizontalScrollMode", (PyCFunction)SbkQAbstractItemViewFunc_setHorizontalScrollMode, METH_O},
    {"setIconSize", (PyCFunction)SbkQAbstractItemViewFunc_setIconSize, METH_O},
    {"setIndexWidget", (PyCFunction)SbkQAbstractItemViewFunc_setIndexWidget, METH_VARARGS},
    {"setItemDelegate", (PyCFunction)SbkQAbstractItemViewFunc_setItemDelegate, METH_O},
    {"setItemDelegateForColumn", (PyCFunction)SbkQAbstractItemViewFunc_setItemDelegateForColumn, METH_VARARGS},
    {"setItemDelegateForRow", (PyCFunction)SbkQAbstractItemViewFunc_setItemDelegateForRow, METH_VARARGS},
    {"setModel", (PyCFunction)SbkQAbstractItemViewFunc_setModel, METH_O},
    {"setRootIndex", (PyCFunction)SbkQAbstractItemViewFunc_setRootIndex, METH_O},
    {"setSelection", (PyCFunction)SbkQAbstractItemViewFunc_setSelection, METH_VARARGS},
    {"setSelectionBehavior", (PyCFunction)SbkQAbstractItemViewFunc_setSelectionBehavior, METH_O},
    {"setSelectionMode", (PyCFunction)SbkQAbstractItemViewFunc_setSelectionMode, METH_O},
    {"setSelectionModel", (PyCFunction)SbkQAbstractItemViewFunc_setSelectionModel, METH_O},
    {"setState", (PyCFunction)SbkQAbstractItemViewFunc_setState, METH_O},
    {"setTabKeyNavigation", (PyCFunction)SbkQAbstractItemViewFunc_setTabKeyNavigation, METH_O},
    {"setTextElideMode", (PyCFunction)SbkQAbstractItemViewFunc_setTextElideMode, METH_O},
    {"setVerticalScrollMode", (PyCFunction)SbkQAbstractItemViewFunc_setVerticalScrollMode, METH_O},
    {"showDropIndicator", (PyCFunction)SbkQAbstractItemViewFunc_showDropIndicator, METH_NOARGS},
    {"sizeHintForColumn", (PyCFunction)SbkQAbstractItemViewFunc_sizeHintForColumn, METH_O},
    {"sizeHintForIndex", (PyCFunction)SbkQAbstractItemViewFunc_sizeHintForIndex, METH_O},
    {"sizeHintForRow", (PyCFunction)SbkQAbstractItemViewFunc_sizeHintForRow, METH_O},
    {"startAutoScroll", (PyCFunction)SbkQAbstractItemViewFunc_startAutoScroll, METH_NOARGS},
    {"startDrag", (PyCFunction)SbkQAbstractItemViewFunc_startDrag, METH_O},
    {"state", (PyCFunction)SbkQAbstractItemViewFunc_state, METH_NOARGS},
    {"stopAutoScroll", (PyCFunction)SbkQAbstractItemViewFunc_stopAutoScroll, METH_NOARGS},
    {"tabKeyNavigation", (PyCFunction)SbkQAbstractItemViewFunc_tabKeyNavigation, METH_NOARGS},
    {"textElideMode", (PyCFunction)SbkQAbstractItemViewFunc_textElideMode, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQAbstractItemViewFunc_timerEvent, METH_O},
    {"update", (PyCFunction)SbkQAbstractItemViewFunc_update, METH_NOARGS|METH_O},
    {"updateEditorData", (PyCFunction)SbkQAbstractItemViewFunc_updateEditorData, METH_NOARGS},
    {"updateEditorGeometries", (PyCFunction)SbkQAbstractItemViewFunc_updateEditorGeometries, METH_NOARGS},
    {"updateGeometries", (PyCFunction)SbkQAbstractItemViewFunc_updateGeometries, METH_NOARGS},
    {"verticalOffset", (PyCFunction)SbkQAbstractItemViewFunc_verticalOffset, METH_NOARGS},
    {"verticalScrollMode", (PyCFunction)SbkQAbstractItemViewFunc_verticalScrollMode, METH_NOARGS},
    {"verticalScrollbarAction", (PyCFunction)SbkQAbstractItemViewFunc_verticalScrollbarAction, METH_O},
    {"verticalScrollbarValueChanged", (PyCFunction)SbkQAbstractItemViewFunc_verticalScrollbarValueChanged, METH_O},
    {"viewOptions", (PyCFunction)SbkQAbstractItemViewFunc_viewOptions, METH_NOARGS},
    {"viewportEvent", (PyCFunction)SbkQAbstractItemViewFunc_viewportEvent, METH_O},
    {"visualRect", (PyCFunction)SbkQAbstractItemViewFunc_visualRect, METH_O},
    {"visualRegionForSelection", (PyCFunction)SbkQAbstractItemViewFunc_visualRegionForSelection, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQAbstractItemViewSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QAbstractItemView* me = reinterpret_cast<QAbstractItemView*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractItemView_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractItemView",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractItemViewWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractItemView_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractItemView_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQAbstractItemViewSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_DragDropMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_DragDropMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DragDropMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_DragDropMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_DragDropMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_DragDropMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionBehavior",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QAbstractItemView_EditTrigger___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractItemView::EditTriggers >::toPython(
        ((QAbstractItemView::EditTriggers) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QAbstractItemView::EditTriggers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QAbstractItemView_EditTrigger___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractItemView::EditTriggers >::toPython(
        ((QAbstractItemView::EditTriggers) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QAbstractItemView::EditTriggers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QAbstractItemView_EditTrigger___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractItemView::EditTriggers >::toPython(
        ((QAbstractItemView::EditTriggers) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QAbstractItemView::EditTriggers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QAbstractItemView_EditTrigger___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QAbstractItemView::EditTriggers >::toPython(
        ~ Shiboken::Converter< QAbstractItemView::EditTriggers >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QAbstractItemView_EditTrigger_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QAbstractItemView_EditTrigger___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QAbstractItemView_EditTrigger___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QAbstractItemView_EditTrigger___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QAbstractItemView_EditTrigger___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_EditTrigger_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_EditTrigger_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EditTrigger",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QAbstractItemView_EditTrigger_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_EditTrigger_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_EditTrigger_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_EditTrigger_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_EditTriggers_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_EditTriggers_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EditTriggers",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_EditTriggers_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_EditTriggers_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QAbstractItemView_EditTriggers_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_ScrollMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_ScrollMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ScrollMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_ScrollMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_ScrollMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_ScrollMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_CursorAction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_CursorAction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_CursorAction_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CursorAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_CursorAction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_CursorAction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_CursorAction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DropIndicatorPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_ScrollHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_ScrollHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ScrollHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_ScrollHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_ScrollHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_ScrollHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_SelectionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_SelectionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_SelectionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_SelectionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_SelectionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAbstractItemView_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemView_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemView_State_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemView_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemView_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemView_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QAbstractItemView(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractItemView_Type);

    SbkQAbstractItemView_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX];
    SbkQAbstractItemView_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQAbstractItemView_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractItemView_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractItemView_Type));
    PyModule_AddObject(module, "QAbstractItemView",
        ((PyObject*)&SbkQAbstractItemView_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: DragDropMode
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_DRAGDROPMODE_IDX] = &SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "DragDropMode",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type,
        (long) QAbstractItemView::NoDragDrop, "NoDragDrop");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "NoDragDrop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type.tp_dict,
        "NoDragDrop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type,
        (long) QAbstractItemView::DragOnly, "DragOnly");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "DragOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type.tp_dict,
        "DragOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type,
        (long) QAbstractItemView::DropOnly, "DropOnly");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "DropOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type.tp_dict,
        "DropOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type,
        (long) QAbstractItemView::DragDrop, "DragDrop");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "DragDrop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type.tp_dict,
        "DragDrop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type,
        (long) QAbstractItemView::InternalMove, "InternalMove");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "InternalMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DragDropMode_Type.tp_dict,
        "InternalMove", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::DragDropMode");

    // init enum class: SelectionBehavior
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SELECTIONBEHAVIOR_IDX] = &SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "SelectionBehavior",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type,
        (long) QAbstractItemView::SelectItems, "SelectItems");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "SelectItems", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type.tp_dict,
        "SelectItems", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type,
        (long) QAbstractItemView::SelectRows, "SelectRows");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "SelectRows", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type.tp_dict,
        "SelectRows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type,
        (long) QAbstractItemView::SelectColumns, "SelectColumns");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "SelectColumns", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionBehavior_Type.tp_dict,
        "SelectColumns", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::SelectionBehavior");

    // init enum class: EditTrigger
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_EDITTRIGGER_IDX] = &SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "EditTrigger",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type));

    // init flags class: QFlags<QAbstractItemView::EditTrigger>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QABSTRACTITEMVIEW_EDITTRIGGER__IDX] = &SbkPySide_QtGui_QAbstractItemView_EditTriggers_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_EditTriggers_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_EditTriggers_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "EditTriggers",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_EditTriggers_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::NoEditTriggers, "NoEditTriggers");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "NoEditTriggers", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "NoEditTriggers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::CurrentChanged, "CurrentChanged");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "CurrentChanged", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "CurrentChanged", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::DoubleClicked, "DoubleClicked");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "DoubleClicked", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "DoubleClicked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::SelectedClicked, "SelectedClicked");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "SelectedClicked", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "SelectedClicked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::EditKeyPressed, "EditKeyPressed");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "EditKeyPressed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "EditKeyPressed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::AnyKeyPressed, "AnyKeyPressed");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "AnyKeyPressed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "AnyKeyPressed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type,
        (long) QAbstractItemView::AllEditTriggers, "AllEditTriggers");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "AllEditTriggers", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_EditTrigger_Type.tp_dict,
        "AllEditTriggers", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::EditTrigger");

    // init enum class: ScrollMode
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SCROLLMODE_IDX] = &SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "ScrollMode",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type,
        (long) QAbstractItemView::ScrollPerItem, "ScrollPerItem");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "ScrollPerItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type.tp_dict,
        "ScrollPerItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type,
        (long) QAbstractItemView::ScrollPerPixel, "ScrollPerPixel");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "ScrollPerPixel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_ScrollMode_Type.tp_dict,
        "ScrollPerPixel", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::ScrollMode");

    // init enum class: CursorAction
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_CURSORACTION_IDX] = &SbkPySide_QtGui_QAbstractItemView_CursorAction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "CursorAction",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveUp, "MoveUp");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveDown, "MoveDown");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveLeft, "MoveLeft");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveRight, "MoveRight");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveHome, "MoveHome");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveHome", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveHome", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveEnd, "MoveEnd");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveEnd", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveEnd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MovePageUp, "MovePageUp");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MovePageUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MovePageUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MovePageDown, "MovePageDown");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MovePageDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MovePageDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MoveNext, "MoveNext");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MoveNext", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MoveNext", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_CursorAction_Type,
        (long) QAbstractItemView::MovePrevious, "MovePrevious");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MovePrevious", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_CursorAction_Type.tp_dict,
        "MovePrevious", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::CursorAction");

    // init enum class: DropIndicatorPosition
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_DROPINDICATORPOSITION_IDX] = &SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "DropIndicatorPosition",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type,
        (long) QAbstractItemView::OnItem, "OnItem");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "OnItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type.tp_dict,
        "OnItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type,
        (long) QAbstractItemView::AboveItem, "AboveItem");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "AboveItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type.tp_dict,
        "AboveItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type,
        (long) QAbstractItemView::BelowItem, "BelowItem");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "BelowItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type.tp_dict,
        "BelowItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type,
        (long) QAbstractItemView::OnViewport, "OnViewport");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "OnViewport", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_DropIndicatorPosition_Type.tp_dict,
        "OnViewport", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::DropIndicatorPosition");

    // init enum class: ScrollHint
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SCROLLHINT_IDX] = &SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "ScrollHint",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type,
        (long) QAbstractItemView::EnsureVisible, "EnsureVisible");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "EnsureVisible", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type.tp_dict,
        "EnsureVisible", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type,
        (long) QAbstractItemView::PositionAtTop, "PositionAtTop");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "PositionAtTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type.tp_dict,
        "PositionAtTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type,
        (long) QAbstractItemView::PositionAtBottom, "PositionAtBottom");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "PositionAtBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type.tp_dict,
        "PositionAtBottom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type,
        (long) QAbstractItemView::PositionAtCenter, "PositionAtCenter");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "PositionAtCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_ScrollHint_Type.tp_dict,
        "PositionAtCenter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::ScrollHint");

    // init enum class: SelectionMode
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_SELECTIONMODE_IDX] = &SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "SelectionMode",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type,
        (long) QAbstractItemView::NoSelection, "NoSelection");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "NoSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type.tp_dict,
        "NoSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type,
        (long) QAbstractItemView::SingleSelection, "SingleSelection");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "SingleSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type.tp_dict,
        "SingleSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type,
        (long) QAbstractItemView::MultiSelection, "MultiSelection");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "MultiSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type.tp_dict,
        "MultiSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type,
        (long) QAbstractItemView::ExtendedSelection, "ExtendedSelection");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "ExtendedSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type.tp_dict,
        "ExtendedSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type,
        (long) QAbstractItemView::ContiguousSelection, "ContiguousSelection");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "ContiguousSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_SelectionMode_Type.tp_dict,
        "ContiguousSelection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::SelectionMode");

    // init enum class: State
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_STATE_IDX] = &SbkPySide_QtGui_QAbstractItemView_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemView_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemView_State_Type);
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtGui_QAbstractItemView_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::NoState, "NoState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "NoState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "NoState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::DraggingState, "DraggingState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "DraggingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "DraggingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::DragSelectingState, "DragSelectingState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "DragSelectingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "DragSelectingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::EditingState, "EditingState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "EditingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "EditingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::ExpandingState, "ExpandingState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "ExpandingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "ExpandingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::CollapsingState, "CollapsingState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "CollapsingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "CollapsingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemView_State_Type,
        (long) QAbstractItemView::AnimatingState, "AnimatingState");
    PyDict_SetItemString(SbkQAbstractItemView_Type.super.ht_type.tp_dict,
        "AnimatingState", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemView_State_Type.tp_dict,
        "AnimatingState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemView::State");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractItemView >("QAbstractItemView*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractItemView >(typeid(QAbstractItemView).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

