/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qabstractitemdelegate_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractItemDelegateWrapper::QAbstractItemDelegateWrapper(QObject * parent) : QAbstractItemDelegate(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractItemDelegateWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemDelegateWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QAbstractItemDelegateWrapper::createEditor(QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemDelegate::createEditor(parent, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QWidget* >::toPython(parent),
        Shiboken::Converter<QStyleOptionViewItem& >::toPython(option),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemDelegate.createEditor");
        return 0        ;
    }
    QWidget* cpp_result(Shiboken::Converter<QWidget* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QAbstractItemDelegateWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemDelegateWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractItemDelegateWrapper::editorEvent(QEvent * event, QAbstractItemModel * model, const QStyleOptionViewItem & option, const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemDelegate::editorEvent(event, model, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QEvent* >::toPython(event),
        Shiboken::Converter<QAbstractItemModel* >::toPython(model),
        Shiboken::Converter<QStyleOptionViewItem& >::toPython(option),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemDelegate.editorEvent");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractItemDelegateWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemDelegate.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractItemDelegateWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemDelegate.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAbstractItemDelegateWrapper::paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemDelegate.paint()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QPainter* >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem& >::toPython(option),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemDelegateWrapper::setEditorData(QWidget * editor, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemDelegate::setEditorData(editor, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemDelegateWrapper::setModelData(QWidget * editor, QAbstractItemModel * model, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModelData"));
    if (py_override.isNull()) {
        return this->QAbstractItemDelegate::setModelData(editor, model, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QAbstractItemModel* >::toPython(model),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QAbstractItemDelegateWrapper::sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemDelegate.sizeHint()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QStyleOptionViewItem& >::toPython(option),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractItemDelegate.sizeHint");
        return QSize()        ;
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemDelegateWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractItemDelegateWrapper::updateEditorGeometry(QWidget * editor, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometry"));
    if (py_override.isNull()) {
        return this->QAbstractItemDelegate::updateEditorGeometry(editor, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QWidget* >::toPython(editor),
        Shiboken::Converter<QStyleOptionViewItem& >::toPython(option),
        Shiboken::Converter<QModelIndex& >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractItemDelegateWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractItemDelegate::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractItemDelegateWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractItemDelegate::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractItemDelegateWrapper::~QAbstractItemDelegateWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractItemDelegate_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractItemDelegateWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractItemDelegate' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractItemDelegate", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractItemDelegate(QObject*)
        cptr = new QAbstractItemDelegateWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAbstractItemDelegate(QObject*)
        cptr = new QAbstractItemDelegateWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractItemDelegate_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractItemDelegate_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractItemDelegate_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate", overloads);
        return -1;
}

static PyObject*
SbkQAbstractItemDelegateFunc_createEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createEditor", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // createEditor(QWidget*,QStyleOptionViewItem,QModelIndex)const
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QAbstractItemDelegate::createEditor(cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QWidget* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractItemDelegateFunc_createEditor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemDelegateFunc_createEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.createEditor", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_editorEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "editorEvent", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QEvent* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemModel* >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[2]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemModel* cpp_arg1 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOptionViewItem* cpp_arg2 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QModelIndex* cpp_arg3 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[3]);
        // editorEvent(QEvent*,QAbstractItemModel*,QStyleOptionViewItem,QModelIndex)
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemDelegate::editorEvent(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractItemDelegateFunc_editorEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemDelegateFunc_editorEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent, PySide.QtCore.QAbstractItemModel, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.editorEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_helpEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "helpEvent", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QHelpEvent* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemView* >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[2]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QHelpEvent* cpp_arg0 = Shiboken::Converter<QHelpEvent* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemView* cpp_arg1 = Shiboken::Converter<QAbstractItemView* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOptionViewItem* cpp_arg2 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QModelIndex* cpp_arg3 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[3]);
        // helpEvent(QHelpEvent*,QAbstractItemView*,QStyleOptionViewItem,QModelIndex)
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemDelegate::helpEvent(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractItemDelegateFunc_helpEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemDelegateFunc_helpEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHelpEvent, PySide.QtGui.QAbstractItemView, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.helpEvent", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter* >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // paint(QPainter*,QStyleOptionViewItem,QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemDelegate.paint()' not implemented.");
            return 0;
        }
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->paint(cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQAbstractItemDelegateFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemDelegateFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.paint", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_setEditorData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEditorData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // setEditorData(QWidget*,QModelIndex)const
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemDelegate::setEditorData(cpp_arg0, *cpp_arg1);
    } else goto SbkQAbstractItemDelegateFunc_setEditorData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemDelegateFunc_setEditorData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.setEditorData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_setModelData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setModelData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemModel* >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemModel* cpp_arg1 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // setModelData(QWidget*,QAbstractItemModel*,QModelIndex)const
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemDelegate::setModelData(cpp_arg0, cpp_arg1, *cpp_arg2);
    } else goto SbkQAbstractItemDelegateFunc_setModelData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemDelegateFunc_setModelData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QAbstractItemModel, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.setModelData", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // sizeHint(QStyleOptionViewItem,QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemDelegate.sizeHint()' not implemented.");
            return 0;
        }
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->sizeHint(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    } else goto SbkQAbstractItemDelegateFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractItemDelegateFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.sizeHint", overloads);
        return 0;
}

static PyObject*
SbkQAbstractItemDelegateFunc_updateEditorGeometry(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "updateEditorGeometry", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget* >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem& >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // updateEditorGeometry(QWidget*,QStyleOptionViewItem,QModelIndex)const
        QAbstractItemDelegate* cppSelf = Shiboken::Converter<QAbstractItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemDelegate::updateEditorGeometry(cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQAbstractItemDelegateFunc_updateEditorGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemDelegateFunc_updateEditorGeometry_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractItemDelegate.updateEditorGeometry", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractItemDelegate_methods[] = {
    {"createEditor", (PyCFunction)SbkQAbstractItemDelegateFunc_createEditor, METH_VARARGS},
    {"editorEvent", (PyCFunction)SbkQAbstractItemDelegateFunc_editorEvent, METH_VARARGS},
    {"helpEvent", (PyCFunction)SbkQAbstractItemDelegateFunc_helpEvent, METH_VARARGS},
    {"paint", (PyCFunction)SbkQAbstractItemDelegateFunc_paint, METH_VARARGS},
    {"setEditorData", (PyCFunction)SbkQAbstractItemDelegateFunc_setEditorData, METH_VARARGS},
    {"setModelData", (PyCFunction)SbkQAbstractItemDelegateFunc_setModelData, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQAbstractItemDelegateFunc_sizeHint, METH_VARARGS},
    {"updateEditorGeometry", (PyCFunction)SbkQAbstractItemDelegateFunc_updateEditorGeometry, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractItemDelegate_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractItemDelegate",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractItemDelegateWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractItemDelegate_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractItemDelegate_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EndEditHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QAbstractItemDelegate(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractItemDelegate_Type);

    SbkQAbstractItemDelegate_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractItemDelegate_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractItemDelegate_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractItemDelegate_Type));
    PyModule_AddObject(module, "QAbstractItemDelegate",
        ((PyObject*)&SbkQAbstractItemDelegate_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: EndEditHint
    SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_ENDEDITHINT_IDX] = &SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type);
    PyDict_SetItemString(SbkQAbstractItemDelegate_Type.super.ht_type.tp_dict,
            "EndEditHint",((PyObject*)&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type,
        (long) QAbstractItemDelegate::NoHint, "NoHint");
    PyDict_SetItemString(SbkQAbstractItemDelegate_Type.super.ht_type.tp_dict,
        "NoHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type.tp_dict,
        "NoHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type,
        (long) QAbstractItemDelegate::EditNextItem, "EditNextItem");
    PyDict_SetItemString(SbkQAbstractItemDelegate_Type.super.ht_type.tp_dict,
        "EditNextItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type.tp_dict,
        "EditNextItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type,
        (long) QAbstractItemDelegate::EditPreviousItem, "EditPreviousItem");
    PyDict_SetItemString(SbkQAbstractItemDelegate_Type.super.ht_type.tp_dict,
        "EditPreviousItem", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type.tp_dict,
        "EditPreviousItem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type,
        (long) QAbstractItemDelegate::SubmitModelCache, "SubmitModelCache");
    PyDict_SetItemString(SbkQAbstractItemDelegate_Type.super.ht_type.tp_dict,
        "SubmitModelCache", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type.tp_dict,
        "SubmitModelCache", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type,
        (long) QAbstractItemDelegate::RevertModelCache, "RevertModelCache");
    PyDict_SetItemString(SbkQAbstractItemDelegate_Type.super.ht_type.tp_dict,
        "RevertModelCache", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAbstractItemDelegate_EndEditHint_Type.tp_dict,
        "RevertModelCache", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractItemDelegate::EndEditHint");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractItemDelegate >("QAbstractItemDelegate*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractItemDelegate >(typeid(QAbstractItemDelegate).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

