/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qsystemsemaphore_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qsystemsemaphore.h>

using namespace Shiboken;

static int
SbkQSystemSemaphore_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSystemSemaphore* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QSystemSemaphore", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
            cptr = new QSystemSemaphore(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
                cptr = new QSystemSemaphore(*cpp_arg0, cpp_arg1);
            } else if (Shiboken::Converter<QSystemSemaphore::AccessMode >::isConvertible(pyargs[2])) {
                QSystemSemaphore::AccessMode cpp_arg2 = Shiboken::Converter<QSystemSemaphore::AccessMode >::toCpp(pyargs[2]);
                // QSystemSemaphore(QString,int,QSystemSemaphore::AccessMode)
                cptr = new QSystemSemaphore(*cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQSystemSemaphore_Init_TypeError;
        } else goto SbkQSystemSemaphore_Init_TypeError;
    } else goto SbkQSystemSemaphore_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSystemSemaphore_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSystemSemaphore_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int = 0, PySide.QtCore.QSystemSemaphore.AccessMode = Open", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSystemSemaphore", overloads);
        return -1;
}

static PyObject*
SbkQSystemSemaphoreFunc_acquire(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // acquire()
    QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSystemSemaphore::acquire();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemSemaphoreFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
    QSystemSemaphore::SystemSemaphoreError cpp_result = cppSelf->QSystemSemaphore::error();
    py_result = Shiboken::Converter<QSystemSemaphore::SystemSemaphoreError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemSemaphoreFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSystemSemaphore::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemSemaphoreFunc_key(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // key()const
    QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSystemSemaphore::key();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSystemSemaphoreFunc_release(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // release(int)
        QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSystemSemaphore::release();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // release(int)
        QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSystemSemaphore::release(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSystemSemaphoreFunc_release_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSystemSemaphoreFunc_release_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSystemSemaphore.release", overloads);
        return 0;
}

static PyObject*
SbkQSystemSemaphoreFunc_setKey(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setKey", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setKey(QString,int,QSystemSemaphore::AccessMode)
            QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
            cppSelf->QSystemSemaphore::setKey(*cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setKey(QString,int,QSystemSemaphore::AccessMode)
                QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
                cppSelf->QSystemSemaphore::setKey(*cpp_arg0, cpp_arg1);
            } else if (Shiboken::Converter<QSystemSemaphore::AccessMode >::isConvertible(pyargs[2])) {
                QSystemSemaphore::AccessMode cpp_arg2 = Shiboken::Converter<QSystemSemaphore::AccessMode >::toCpp(pyargs[2]);
                // setKey(QString,int,QSystemSemaphore::AccessMode)
                QSystemSemaphore* cppSelf = Shiboken::Converter<QSystemSemaphore* >::toCpp((PyObject*)self);
                cppSelf->QSystemSemaphore::setKey(*cpp_arg0, cpp_arg1, cpp_arg2);
            } else goto SbkQSystemSemaphoreFunc_setKey_TypeError;
        } else goto SbkQSystemSemaphoreFunc_setKey_TypeError;
    } else goto SbkQSystemSemaphoreFunc_setKey_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSystemSemaphoreFunc_setKey_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int = 0, PySide.QtCore.QSystemSemaphore.AccessMode = Open", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSystemSemaphore.setKey", overloads);
        return 0;
}

static PyMethodDef SbkQSystemSemaphore_methods[] = {
    {"acquire", (PyCFunction)SbkQSystemSemaphoreFunc_acquire, METH_NOARGS},
    {"error", (PyCFunction)SbkQSystemSemaphoreFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQSystemSemaphoreFunc_errorString, METH_NOARGS},
    {"key", (PyCFunction)SbkQSystemSemaphoreFunc_key, METH_NOARGS},
    {"release", (PyCFunction)SbkQSystemSemaphoreFunc_release, METH_NOARGS|METH_O},
    {"setKey", (PyCFunction)SbkQSystemSemaphoreFunc_setKey, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSystemSemaphore_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSystemSemaphore",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSystemSemaphore >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSystemSemaphore_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSystemSemaphore_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QSystemSemaphore_AccessMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSystemSemaphore_AccessMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AccessMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSystemSemaphore_AccessMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSystemSemaphore_AccessMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QSystemSemaphore_AccessMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SystemSemaphoreError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSystemSemaphore(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSystemSemaphore_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSystemSemaphore_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSystemSemaphore_Type));
    PyModule_AddObject(module, "QSystemSemaphore",
        ((PyObject*)&SbkQSystemSemaphore_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: AccessMode
    SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX] = &SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type);
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
            "AccessMode",((PyObject*)&SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type,
        (long) QSystemSemaphore::Open, "Open");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "Open", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type.tp_dict,
        "Open", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type,
        (long) QSystemSemaphore::Create, "Create");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "Create", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_AccessMode_Type.tp_dict,
        "Create", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSystemSemaphore::AccessMode");

    // init enum class: SystemSemaphoreError
    SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX] = &SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type);
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
            "SystemSemaphoreError",((PyObject*)&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::NoError, "NoError");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::PermissionDenied, "PermissionDenied");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "PermissionDenied", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "PermissionDenied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::KeyError, "KeyError");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "KeyError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "KeyError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::AlreadyExists, "AlreadyExists");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "AlreadyExists", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "AlreadyExists", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::NotFound, "NotFound");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "NotFound", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "NotFound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::OutOfResources, "OutOfResources");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "OutOfResources", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "OutOfResources", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type,
        (long) QSystemSemaphore::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQSystemSemaphore_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Type.tp_dict,
        "UnknownError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSystemSemaphore::SystemSemaphoreError");

    Shiboken::TypeResolver::createObjectTypeResolver<QSystemSemaphore >("QSystemSemaphore*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSystemSemaphore >(typeid(QSystemSemaphore).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

