/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qmetaenum_wrapper.h"

// Extra includes
#include <qbytearray.h>

using namespace Shiboken;

static int
SbkQMetaEnum_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMetaEnum* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QMetaEnum()
    cptr = new QMetaEnum();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQMetaEnumFunc_isFlag(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFlag()const
    QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaEnum::isFlag();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaEnumFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaEnum::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaEnumFunc_key(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // key(int)const
        QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
        const char * cpp_result = cppSelf->QMetaEnum::key(cpp_arg0);
        py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    } else goto SbkQMetaEnumFunc_key_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaEnumFunc_key_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaEnum.key", overloads);
        return 0;
}

static PyObject*
SbkQMetaEnumFunc_keyCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyCount()const
    QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaEnum::keyCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaEnumFunc_keyToValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // keyToValue(const char*)const
        QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaEnum::keyToValue(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQMetaEnumFunc_keyToValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaEnumFunc_keyToValue_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaEnum.keyToValue", overloads);
        return 0;
}

static PyObject*
SbkQMetaEnumFunc_keysToValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // keysToValue(const char*)const
        QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaEnum::keysToValue(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQMetaEnumFunc_keysToValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaEnumFunc_keysToValue_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaEnum.keysToValue", overloads);
        return 0;
}

static PyObject*
SbkQMetaEnumFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QMetaEnum::name();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaEnumFunc_scope(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scope()const
    QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QMetaEnum::scope();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaEnumFunc_value(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // value(int)const
        QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QMetaEnum::value(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQMetaEnumFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaEnumFunc_value_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaEnum.value", overloads);
        return 0;
}

static PyObject*
SbkQMetaEnumFunc_valueToKey(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // valueToKey(int)const
        QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
        const char * cpp_result = cppSelf->QMetaEnum::valueToKey(cpp_arg0);
        py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    } else goto SbkQMetaEnumFunc_valueToKey_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaEnumFunc_valueToKey_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaEnum.valueToKey", overloads);
        return 0;
}

static PyObject*
SbkQMetaEnumFunc_valueToKeys(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // valueToKeys(int)const
        QMetaEnum* cppSelf = Shiboken::Converter<QMetaEnum* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QMetaEnum::valueToKeys(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    } else goto SbkQMetaEnumFunc_valueToKeys_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaEnumFunc_valueToKeys_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaEnum.valueToKeys", overloads);
        return 0;
}

static PyMethodDef SbkQMetaEnum_methods[] = {
    {"isFlag", (PyCFunction)SbkQMetaEnumFunc_isFlag, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQMetaEnumFunc_isValid, METH_NOARGS},
    {"key", (PyCFunction)SbkQMetaEnumFunc_key, METH_O},
    {"keyCount", (PyCFunction)SbkQMetaEnumFunc_keyCount, METH_NOARGS},
    {"keyToValue", (PyCFunction)SbkQMetaEnumFunc_keyToValue, METH_O},
    {"keysToValue", (PyCFunction)SbkQMetaEnumFunc_keysToValue, METH_O},
    {"name", (PyCFunction)SbkQMetaEnumFunc_name, METH_NOARGS},
    {"scope", (PyCFunction)SbkQMetaEnumFunc_scope, METH_NOARGS},
    {"value", (PyCFunction)SbkQMetaEnumFunc_value, METH_O},
    {"valueToKey", (PyCFunction)SbkQMetaEnumFunc_valueToKey, METH_O},
    {"valueToKeys", (PyCFunction)SbkQMetaEnumFunc_valueToKeys, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMetaEnum_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QMetaEnum",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMetaEnum >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMetaEnum_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMetaEnum_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QMetaEnum(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QMETAENUM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMetaEnum_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQMetaEnum_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMetaEnum_Type));
    PyModule_AddObject(module, "QMetaEnum",
        ((PyObject*)&SbkQMetaEnum_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QMetaEnum >("QMetaEnum");
    Shiboken::TypeResolver::createValueTypeResolver<QMetaEnum >(typeid(QMetaEnum).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

