/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qdir_wrapper.h"

// Extra includes
#include <QList>
#include <qchar.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQDir_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDir* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDir", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDir(QString)
        cptr = new QDir();
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QDir(QString)
        cptr = new QDir(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QDir& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QDir > cpp_arg0_auto_ptr;
        QDir* cpp_arg0 = Shiboken::Converter<QDir* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QDir& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QDir >(cpp_arg0);
        // QDir(QDir)
        cptr = new QDir(*cpp_arg0);
    } else goto SbkQDir_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDir_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDir_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir", "PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir", overloads);
        return -1;
}

static PyObject*
SbkQDirFunc_absoluteFilePath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // absoluteFilePath(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDir::absoluteFilePath(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_absoluteFilePath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_absoluteFilePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.absoluteFilePath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_absolutePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // absolutePath()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDir::absolutePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_addResourceSearchPath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addResourceSearchPath(QString)
        QDir::addResourceSearchPath(*cpp_arg0);
    } else goto SbkQDirFunc_addResourceSearchPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_addResourceSearchPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.addResourceSearchPath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_addSearchPath(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addSearchPath", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // addSearchPath(QString,QString)
        QDir::addSearchPath(*cpp_arg0, *cpp_arg1);
    } else goto SbkQDirFunc_addSearchPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_addSearchPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir.addSearchPath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_canonicalPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canonicalPath()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDir::canonicalPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_cd(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // cd(QString)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::cd(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_cd_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_cd_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.cd", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_cdUp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cdUp()
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDir::cdUp();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_cleanPath(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // cleanPath(QString)
        QString cpp_result = QDir::cleanPath(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_cleanPath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_cleanPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.cleanPath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_convertSeparators(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // convertSeparators(QString)
        QString cpp_result = QDir::convertSeparators(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_convertSeparators_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_convertSeparators_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.convertSeparators", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QDir::count();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_current(PyObject* self)
{
    PyObject* py_result = 0;

    // current()
    QDir cpp_result = QDir::current();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_currentPath(PyObject* self)
{
    PyObject* py_result = 0;

    // currentPath()
    QString cpp_result = QDir::currentPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_dirName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dirName()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDir::dirName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_drives(PyObject* self)
{
    PyObject* py_result = 0;

    // drives()
    QList<QFileInfo > cpp_result = QDir::drives();
    py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_entryInfoList(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "entryInfoList", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        QList<QFileInfo > cpp_result = cppSelf->QDir::entryInfoList();
        py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);
    } else if (Shiboken::Converter<QStringList& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (numArgs == 1) {
            // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
            QList<QFileInfo > cpp_result = cppSelf->QDir::entryInfoList(*cpp_arg0);
            py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);
        } else if (SbkPySide_QtCore_QDir_Filter_Check(pyargs[1])) {
            QFlags<QDir::Filter> cpp_arg1 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
                QList<QFileInfo > cpp_result = cppSelf->QDir::entryInfoList(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_QDir_SortFlag_Check(pyargs[2])) {
                QFlags<QDir::SortFlag> cpp_arg2 = Shiboken::Converter<QFlags<QDir::SortFlag> >::toCpp(pyargs[2]);
                // entryInfoList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
                QList<QFileInfo > cpp_result = cppSelf->QDir::entryInfoList(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);
            } else goto SbkQDirFunc_entryInfoList_TypeError;
        } else goto SbkQDirFunc_entryInfoList_TypeError;
    } else if (SbkPySide_QtCore_QDir_Filter_Check(pyargs[0])) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
            QList<QFileInfo > cpp_result = cppSelf->QDir::entryInfoList(cpp_arg0);
            py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);
        } else if (SbkPySide_QtCore_QDir_SortFlag_Check(pyargs[1])) {
            QFlags<QDir::SortFlag> cpp_arg1 = Shiboken::Converter<QFlags<QDir::SortFlag> >::toCpp(pyargs[1]);
            // entryInfoList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
            QList<QFileInfo > cpp_result = cppSelf->QDir::entryInfoList(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);
        } else goto SbkQDirFunc_entryInfoList_TypeError;
    } else goto SbkQDirFunc_entryInfoList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_entryInfoList_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters = QDir.NoFilter, PySide.QtCore.QDir.SortFlags = QDir.NoSort", "PySide.QtCore.QStringList, PySide.QtCore.QDir.Filters = QDir.NoFilter, PySide.QtCore.QDir.SortFlags = QDir.NoSort", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir.entryInfoList", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_entryList(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "entryList", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QDir::entryList();
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else if (Shiboken::Converter<QStringList& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (numArgs == 1) {
            // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
            QStringList cpp_result = cppSelf->QDir::entryList(*cpp_arg0);
            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        } else if (SbkPySide_QtCore_QDir_Filter_Check(pyargs[1])) {
            QFlags<QDir::Filter> cpp_arg1 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
                QStringList cpp_result = cppSelf->QDir::entryList(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
            } else if (SbkPySide_QtCore_QDir_SortFlag_Check(pyargs[2])) {
                QFlags<QDir::SortFlag> cpp_arg2 = Shiboken::Converter<QFlags<QDir::SortFlag> >::toCpp(pyargs[2]);
                // entryList(QStringList,QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
                QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
                QStringList cpp_result = cppSelf->QDir::entryList(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
            } else goto SbkQDirFunc_entryList_TypeError;
        } else goto SbkQDirFunc_entryList_TypeError;
    } else if (SbkPySide_QtCore_QDir_Filter_Check(pyargs[0])) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
            QStringList cpp_result = cppSelf->QDir::entryList(cpp_arg0);
            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        } else if (SbkPySide_QtCore_QDir_SortFlag_Check(pyargs[1])) {
            QFlags<QDir::SortFlag> cpp_arg1 = Shiboken::Converter<QFlags<QDir::SortFlag> >::toCpp(pyargs[1]);
            // entryList(QFlags<QDir::Filter>,QFlags<QDir::SortFlag>)const
            QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
            QStringList cpp_result = cppSelf->QDir::entryList(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        } else goto SbkQDirFunc_entryList_TypeError;
    } else goto SbkQDirFunc_entryList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_entryList_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters = QDir.NoFilter, PySide.QtCore.QDir.SortFlags = QDir.NoSort", "PySide.QtCore.QStringList, PySide.QtCore.QDir.Filters = QDir.NoFilter, PySide.QtCore.QDir.SortFlags = QDir.NoSort", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir.entryList", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_exists(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exists()const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::exists();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // exists(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::exists(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_exists_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_exists_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.exists", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_filePath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // filePath(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDir::filePath(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_filePath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_filePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.filePath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_filter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filter()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QFlags<QDir::Filter> cpp_result = cppSelf->QDir::filter();
    py_result = Shiboken::Converter<QFlags<QDir::Filter> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_fromNativeSeparators(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromNativeSeparators(QString)
        QString cpp_result = QDir::fromNativeSeparators(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_fromNativeSeparators_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_fromNativeSeparators_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.fromNativeSeparators", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_home(PyObject* self)
{
    PyObject* py_result = 0;

    // home()
    QDir cpp_result = QDir::home();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_homePath(PyObject* self)
{
    PyObject* py_result = 0;

    // homePath()
    QString cpp_result = QDir::homePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_isAbsolute(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAbsolute()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDir::isAbsolute();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_isAbsolutePath(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isAbsolutePath(QString)
        bool cpp_result = QDir::isAbsolutePath(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_isAbsolutePath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_isAbsolutePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.isAbsolutePath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_isReadable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadable()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDir::isReadable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_isRelative(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRelative()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDir::isRelative();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_isRelativePath(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isRelativePath(QString)
        bool cpp_result = QDir::isRelativePath(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_isRelativePath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_isRelativePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.isRelativePath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_isRoot(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRoot()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDir::isRoot();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_makeAbsolute(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // makeAbsolute()
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDir::makeAbsolute();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_match(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "match", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStringList& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // match(QStringList,QString)
        bool cpp_result = QDir::match(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // match(QString,QString)
        bool cpp_result = QDir::match(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_match_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_match_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QStringList, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir.match", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_mkdir(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // mkdir(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::mkdir(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_mkdir_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_mkdir_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.mkdir", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_mkpath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // mkpath(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::mkpath(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_mkpath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_mkpath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.mkpath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_nameFilters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nameFilters()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QDir::nameFilters();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_nameFiltersFromString(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // nameFiltersFromString(QString)
        QStringList cpp_result = QDir::nameFiltersFromString(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQDirFunc_nameFiltersFromString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_nameFiltersFromString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.nameFiltersFromString", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_path(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // path()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDir::path();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_refresh(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // refresh()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    cppSelf->QDir::refresh();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQDirFunc_relativeFilePath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // relativeFilePath(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDir::relativeFilePath(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_relativeFilePath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_relativeFilePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.relativeFilePath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_remove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // remove(QString)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::remove(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_remove_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_remove_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.remove", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_rename(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rename", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // rename(QString,QString)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::rename(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_rename_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_rename_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir.rename", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_rmdir(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // rmdir(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::rmdir(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_rmdir_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_rmdir_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.rmdir", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_rmpath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // rmpath(QString)const
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDir::rmpath(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_rmpath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_rmpath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.rmpath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_root(PyObject* self)
{
    PyObject* py_result = 0;

    // root()
    QDir cpp_result = QDir::root();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_rootPath(PyObject* self)
{
    PyObject* py_result = 0;

    // rootPath()
    QString cpp_result = QDir::rootPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_searchPaths(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // searchPaths(QString)
        QStringList cpp_result = QDir::searchPaths(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQDirFunc_searchPaths_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_searchPaths_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.searchPaths", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_separator(PyObject* self)
{
    PyObject* py_result = 0;

    // separator()
    QChar cpp_result = QDir::separator();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_setCurrent(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCurrent(QString)
        bool cpp_result = QDir::setCurrent(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDirFunc_setCurrent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_setCurrent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.setCurrent", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_setFilter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_QDir_Filter_Check(arg)) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(arg);
        // setFilter(QFlags<QDir::Filter>)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        cppSelf->QDir::setFilter(cpp_arg0);
    } else goto SbkQDirFunc_setFilter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_setFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.setFilter", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_setNameFilters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setNameFilters(QStringList)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        cppSelf->QDir::setNameFilters(*cpp_arg0);
    } else goto SbkQDirFunc_setNameFilters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_setNameFilters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.setNameFilters", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_setPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPath(QString)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        cppSelf->QDir::setPath(*cpp_arg0);
    } else goto SbkQDirFunc_setPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_setPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.setPath", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_setSearchPaths(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSearchPaths", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QStringList& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // setSearchPaths(QString,QStringList)
        QDir::setSearchPaths(*cpp_arg0, *cpp_arg1);
    } else goto SbkQDirFunc_setSearchPaths_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_setSearchPaths_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDir.setSearchPaths", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_setSorting(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_QDir_SortFlag_Check(arg)) {
        QFlags<QDir::SortFlag> cpp_arg0 = Shiboken::Converter<QFlags<QDir::SortFlag> >::toCpp(arg);
        // setSorting(QFlags<QDir::SortFlag>)
        QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
        cppSelf->QDir::setSorting(cpp_arg0);
    } else goto SbkQDirFunc_setSorting_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDirFunc_setSorting_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.SortFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.setSorting", overloads);
        return 0;
}

static PyObject*
SbkQDirFunc_sorting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sorting()const
    QDir* cppSelf = Shiboken::Converter<QDir* >::toCpp((PyObject*)self);
    QFlags<QDir::SortFlag> cpp_result = cppSelf->QDir::sorting();
    py_result = Shiboken::Converter<QFlags<QDir::SortFlag> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_temp(PyObject* self)
{
    PyObject* py_result = 0;

    // temp()
    QDir cpp_result = QDir::temp();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_tempPath(PyObject* self)
{
    PyObject* py_result = 0;

    // tempPath()
    QString cpp_result = QDir::tempPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDirFunc_toNativeSeparators(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toNativeSeparators(QString)
        QString cpp_result = QDir::toNativeSeparators(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQDirFunc_toNativeSeparators_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDirFunc_toNativeSeparators_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDir.toNativeSeparators", overloads);
        return 0;
}

static PyMethodDef SbkQDir_methods[] = {
    {"absoluteFilePath", (PyCFunction)SbkQDirFunc_absoluteFilePath, METH_O},
    {"absolutePath", (PyCFunction)SbkQDirFunc_absolutePath, METH_NOARGS},
    {"addResourceSearchPath", (PyCFunction)SbkQDirFunc_addResourceSearchPath, METH_O|METH_STATIC},
    {"addSearchPath", (PyCFunction)SbkQDirFunc_addSearchPath, METH_VARARGS|METH_STATIC},
    {"canonicalPath", (PyCFunction)SbkQDirFunc_canonicalPath, METH_NOARGS},
    {"cd", (PyCFunction)SbkQDirFunc_cd, METH_O},
    {"cdUp", (PyCFunction)SbkQDirFunc_cdUp, METH_NOARGS},
    {"cleanPath", (PyCFunction)SbkQDirFunc_cleanPath, METH_O|METH_STATIC},
    {"convertSeparators", (PyCFunction)SbkQDirFunc_convertSeparators, METH_O|METH_STATIC},
    {"count", (PyCFunction)SbkQDirFunc_count, METH_NOARGS},
    {"current", (PyCFunction)SbkQDirFunc_current, METH_NOARGS|METH_STATIC},
    {"currentPath", (PyCFunction)SbkQDirFunc_currentPath, METH_NOARGS|METH_STATIC},
    {"dirName", (PyCFunction)SbkQDirFunc_dirName, METH_NOARGS},
    {"drives", (PyCFunction)SbkQDirFunc_drives, METH_NOARGS|METH_STATIC},
    {"entryInfoList", (PyCFunction)SbkQDirFunc_entryInfoList, METH_VARARGS},
    {"entryList", (PyCFunction)SbkQDirFunc_entryList, METH_VARARGS},
    {"exists", (PyCFunction)SbkQDirFunc_exists, METH_NOARGS|METH_O},
    {"filePath", (PyCFunction)SbkQDirFunc_filePath, METH_O},
    {"filter", (PyCFunction)SbkQDirFunc_filter, METH_NOARGS},
    {"fromNativeSeparators", (PyCFunction)SbkQDirFunc_fromNativeSeparators, METH_O|METH_STATIC},
    {"home", (PyCFunction)SbkQDirFunc_home, METH_NOARGS|METH_STATIC},
    {"homePath", (PyCFunction)SbkQDirFunc_homePath, METH_NOARGS|METH_STATIC},
    {"isAbsolute", (PyCFunction)SbkQDirFunc_isAbsolute, METH_NOARGS},
    {"isAbsolutePath", (PyCFunction)SbkQDirFunc_isAbsolutePath, METH_O|METH_STATIC},
    {"isReadable", (PyCFunction)SbkQDirFunc_isReadable, METH_NOARGS},
    {"isRelative", (PyCFunction)SbkQDirFunc_isRelative, METH_NOARGS},
    {"isRelativePath", (PyCFunction)SbkQDirFunc_isRelativePath, METH_O|METH_STATIC},
    {"isRoot", (PyCFunction)SbkQDirFunc_isRoot, METH_NOARGS},
    {"makeAbsolute", (PyCFunction)SbkQDirFunc_makeAbsolute, METH_NOARGS},
    {"match", (PyCFunction)SbkQDirFunc_match, METH_VARARGS|METH_STATIC},
    {"mkdir", (PyCFunction)SbkQDirFunc_mkdir, METH_O},
    {"mkpath", (PyCFunction)SbkQDirFunc_mkpath, METH_O},
    {"nameFilters", (PyCFunction)SbkQDirFunc_nameFilters, METH_NOARGS},
    {"nameFiltersFromString", (PyCFunction)SbkQDirFunc_nameFiltersFromString, METH_O|METH_STATIC},
    {"path", (PyCFunction)SbkQDirFunc_path, METH_NOARGS},
    {"refresh", (PyCFunction)SbkQDirFunc_refresh, METH_NOARGS},
    {"relativeFilePath", (PyCFunction)SbkQDirFunc_relativeFilePath, METH_O},
    {"remove", (PyCFunction)SbkQDirFunc_remove, METH_O},
    {"rename", (PyCFunction)SbkQDirFunc_rename, METH_VARARGS},
    {"rmdir", (PyCFunction)SbkQDirFunc_rmdir, METH_O},
    {"rmpath", (PyCFunction)SbkQDirFunc_rmpath, METH_O},
    {"root", (PyCFunction)SbkQDirFunc_root, METH_NOARGS|METH_STATIC},
    {"rootPath", (PyCFunction)SbkQDirFunc_rootPath, METH_NOARGS|METH_STATIC},
    {"searchPaths", (PyCFunction)SbkQDirFunc_searchPaths, METH_O|METH_STATIC},
    {"separator", (PyCFunction)SbkQDirFunc_separator, METH_NOARGS|METH_STATIC},
    {"setCurrent", (PyCFunction)SbkQDirFunc_setCurrent, METH_O|METH_STATIC},
    {"setFilter", (PyCFunction)SbkQDirFunc_setFilter, METH_O},
    {"setNameFilters", (PyCFunction)SbkQDirFunc_setNameFilters, METH_O},
    {"setPath", (PyCFunction)SbkQDirFunc_setPath, METH_O},
    {"setSearchPaths", (PyCFunction)SbkQDirFunc_setSearchPaths, METH_VARARGS|METH_STATIC},
    {"setSorting", (PyCFunction)SbkQDirFunc_setSorting, METH_O},
    {"sorting", (PyCFunction)SbkQDirFunc_sorting, METH_NOARGS},
    {"temp", (PyCFunction)SbkQDirFunc_temp, METH_NOARGS|METH_STATIC},
    {"tempPath", (PyCFunction)SbkQDirFunc_tempPath, METH_NOARGS|METH_STATIC},
    {"toNativeSeparators", (PyCFunction)SbkQDirFunc_toNativeSeparators, METH_O|METH_STATIC},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQDir_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QDir& cpp_self = *Shiboken::Converter<QDir* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDir& >::isConvertible(other)) {
                QDir* cpp_other = Shiboken::Converter<QDir* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QDir >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QDir > cpp_other_auto_ptr;
                QDir* cpp_other = Shiboken::Converter<QDir* >::toCpp(other);
                if (!Shiboken::Converter<QDir >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QDir >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQDir_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDir& >::isConvertible(other)) {
                QDir* cpp_other = Shiboken::Converter<QDir* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QDir >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QDir > cpp_other_auto_ptr;
                QDir* cpp_other = Shiboken::Converter<QDir* >::toCpp(other);
                if (!Shiboken::Converter<QDir >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QDir >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQDir_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQDir_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDir_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QDir",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDir >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDir_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDir_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDir_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtCore_QDir_Filter___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::Filters >::toPython(
        ((QDir::Filters) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QDir::Filters >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QDir_Filter___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::Filters >::toPython(
        ((QDir::Filters) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QDir::Filters >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QDir_Filter___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::Filters >::toPython(
        ((QDir::Filters) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QDir::Filters >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QDir_Filter___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::Filters >::toPython(
        ~ Shiboken::Converter< QDir::Filters >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QDir_Filter_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QDir_Filter___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QDir_Filter___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QDir_Filter___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QDir_Filter___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QDir_Filter_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDir_Filter_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDir_Filter_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Filter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QDir_Filter_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QDir_Filter_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDir_Filter_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QDir_Filter_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDir_Filters_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDir_Filters_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Filters",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QDir_Filter_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDir_Filters_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QDir_Filters_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QDir_Filters_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyObject*
SbkPySide_QtCore_QDir_SortFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::SortFlags >::toPython(
        ((QDir::SortFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QDir::SortFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QDir_SortFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::SortFlags >::toPython(
        ((QDir::SortFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QDir::SortFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QDir_SortFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::SortFlags >::toPython(
        ((QDir::SortFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QDir::SortFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QDir_SortFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDir::SortFlags >::toPython(
        ~ Shiboken::Converter< QDir::SortFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QDir_SortFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QDir_SortFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QDir_SortFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QDir_SortFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QDir_SortFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QDir_SortFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDir_SortFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDir_SortFlag_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SortFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QDir_SortFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QDir_SortFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDir_SortFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QDir_SortFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QDir_SortFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QDir_SortFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SortFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QDir_SortFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QDir_SortFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QDir_SortFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QDir_SortFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QDir(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QDIR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDir_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDir_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDir_Type));
    PyModule_AddObject(module, "QDir",
        ((PyObject*)&SbkQDir_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Filter
    SbkPySide_QtCoreTypes[SBK_QDIR_FILTER_IDX] = &SbkPySide_QtCore_QDir_Filter_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDir_Filter_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDir_Filter_Type);
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
            "Filter",((PyObject*)&SbkPySide_QtCore_QDir_Filter_Type));

    // init flags class: QFlags<QDir::Filter>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER__IDX] = &SbkPySide_QtCore_QDir_Filters_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDir_Filters_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDir_Filters_Type);
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
            "Filters",((PyObject*)&SbkPySide_QtCore_QDir_Filters_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Dirs, "Dirs");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Dirs", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Dirs", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Files, "Files");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Files", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Files", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Drives, "Drives");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Drives", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Drives", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::NoSymLinks, "NoSymLinks");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "NoSymLinks", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "NoSymLinks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::AllEntries, "AllEntries");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "AllEntries", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "AllEntries", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::TypeMask, "TypeMask");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "TypeMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "TypeMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Readable, "Readable");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Readable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Readable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Writable, "Writable");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Writable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Writable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Executable, "Executable");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Executable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Executable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::PermissionMask, "PermissionMask");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "PermissionMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "PermissionMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Modified, "Modified");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Modified", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Modified", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::Hidden, "Hidden");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Hidden", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "Hidden", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::System, "System");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "System", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "System", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::AccessMask, "AccessMask");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "AccessMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "AccessMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::AllDirs, "AllDirs");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "AllDirs", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "AllDirs", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::CaseSensitive, "CaseSensitive");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "CaseSensitive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "CaseSensitive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::NoDotAndDotDot, "NoDotAndDotDot");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "NoDotAndDotDot", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "NoDotAndDotDot", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_Filter_Type,
        (long) QDir::NoFilter, "NoFilter");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "NoFilter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_Filter_Type.tp_dict,
        "NoFilter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDir::Filter");

    // init enum class: SortFlag
    SbkPySide_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX] = &SbkPySide_QtCore_QDir_SortFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDir_SortFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDir_SortFlag_Type);
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
            "SortFlag",((PyObject*)&SbkPySide_QtCore_QDir_SortFlag_Type));

    // init flags class: QFlags<QDir::SortFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG__IDX] = &SbkPySide_QtCore_QDir_SortFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QDir_SortFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QDir_SortFlags_Type);
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
            "SortFlags",((PyObject*)&SbkPySide_QtCore_QDir_SortFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::Name, "Name");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Name", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "Name", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::Time, "Time");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Time", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "Time", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::Size, "Size");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Size", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "Size", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::Unsorted, "Unsorted");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Unsorted", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "Unsorted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::SortByMask, "SortByMask");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "SortByMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "SortByMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::DirsFirst, "DirsFirst");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "DirsFirst", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "DirsFirst", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::Reversed, "Reversed");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Reversed", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "Reversed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::IgnoreCase, "IgnoreCase");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "IgnoreCase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "IgnoreCase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::DirsLast, "DirsLast");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "DirsLast", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "DirsLast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::LocaleAware, "LocaleAware");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "LocaleAware", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "LocaleAware", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::Type, "Type");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QDir_SortFlag_Type,
        (long) QDir::NoSort, "NoSort");
    PyDict_SetItemString(SbkQDir_Type.super.ht_type.tp_dict,
        "NoSort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QDir_SortFlag_Type.tp_dict,
        "NoSort", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDir::SortFlag");

    Shiboken::TypeResolver::createValueTypeResolver<QDir >("QDir");
    Shiboken::TypeResolver::createValueTypeResolver<QDir >(typeid(QDir).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

