/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qabstractanimation_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractanimation.h>
#include <qanimationgroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractAnimationWrapper::QAbstractAnimationWrapper(QObject * parent) : QAbstractAnimation(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractAnimationWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractAnimationWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractAnimationWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractAnimationWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractAnimationWrapper::duration() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "duration"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.duration()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractAnimation.duration");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractAnimationWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractAnimation::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractAnimation.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractAnimationWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QAbstractAnimation.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAbstractAnimationWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractAnimationWrapper::updateCurrentTime(int currentTime)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateCurrentTime"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.updateCurrentTime()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        currentTime
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractAnimationWrapper::updateDirection(QAbstractAnimation::Direction direction)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateDirection"));
    if (py_override.isNull()) {
        return this->QAbstractAnimation::updateDirection(direction);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractAnimation::Direction >::toPython(direction)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractAnimationWrapper::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateState"));
    if (py_override.isNull()) {
        return this->QAbstractAnimation::updateState(newState, oldState);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QAbstractAnimation::State >::toPython(newState),
        Shiboken::Converter<QAbstractAnimation::State >::toPython(oldState)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractAnimationWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractAnimation::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractAnimationWrapper::~QAbstractAnimationWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractAnimation_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractAnimationWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractAnimation' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractAnimation", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractAnimation(QObject*)
        cptr = new QAbstractAnimationWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAbstractAnimation(QObject*)
        cptr = new QAbstractAnimationWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractAnimation_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractAnimation_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQAbstractAnimation_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractAnimation", overloads);
        return -1;
}

static PyObject*
SbkQAbstractAnimationFunc_currentLoop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentLoop()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractAnimation::currentLoop();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_currentLoopTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentLoopTime()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractAnimation::currentLoopTime();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_currentTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentTime()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractAnimation::currentTime();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_direction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // direction()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    QAbstractAnimation::Direction cpp_result = cppSelf->QAbstractAnimation::direction();
    py_result = Shiboken::Converter<QAbstractAnimation::Direction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_duration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // duration()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.duration()' not implemented.");
        return 0;
    }
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->duration();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractAnimation::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQAbstractAnimationFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQAbstractAnimationFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.event", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_group(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // group()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    QAnimationGroup * cpp_result = cppSelf->QAbstractAnimation::group();
    py_result = Shiboken::Converter<QAnimationGroup* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_loopCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // loopCount()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractAnimation::loopCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_pause(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pause()
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    cppSelf->QAbstractAnimation::pause();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractAnimationFunc_resume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resume()
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    cppSelf->QAbstractAnimation::resume();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractAnimationFunc_setCurrentTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentTime(int)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::setCurrentTime(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_setCurrentTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_setCurrentTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.setCurrentTime", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_setDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation::Direction >::isConvertible(arg)) {
        QAbstractAnimation::Direction cpp_arg0 = Shiboken::Converter<QAbstractAnimation::Direction >::toCpp(arg);
        // setDirection(QAbstractAnimation::Direction)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::setDirection(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_setDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_setDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.Direction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.setDirection", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_setLoopCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLoopCount(int)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::setLoopCount(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_setLoopCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_setLoopCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.setLoopCount", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_setPaused(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setPaused(bool)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::setPaused(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_setPaused_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_setPaused_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.setPaused", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // start(QAbstractAnimation::DeletionPolicy)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::start();
    } else if (Shiboken::Converter<QAbstractAnimation::DeletionPolicy >::isConvertible(arg)) {
        QAbstractAnimation::DeletionPolicy cpp_arg0 = Shiboken::Converter<QAbstractAnimation::DeletionPolicy >::toCpp(arg);
        // start(QAbstractAnimation::DeletionPolicy)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::start(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_start_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_start_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.DeletionPolicy = KeepWhenStopped", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.start", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    QAbstractAnimation::State cpp_result = cppSelf->QAbstractAnimation::state();
    py_result = Shiboken::Converter<QAbstractAnimation::State >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    cppSelf->QAbstractAnimation::stop();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQAbstractAnimationFunc_totalDuration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalDuration()const
    QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractAnimation::totalDuration();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQAbstractAnimationFunc_updateCurrentTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // updateCurrentTime(int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAnimation.updateCurrentTime()' not implemented.");
            return 0;
        }
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->updateCurrentTime(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_updateCurrentTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_updateCurrentTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.updateCurrentTime", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_updateDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation::Direction >::isConvertible(arg)) {
        QAbstractAnimation::Direction cpp_arg0 = Shiboken::Converter<QAbstractAnimation::Direction >::toCpp(arg);
        // updateDirection(QAbstractAnimation::Direction)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::updateDirection(cpp_arg0);
    } else goto SbkQAbstractAnimationFunc_updateDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_updateDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.Direction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractAnimation.updateDirection", overloads);
        return 0;
}

static PyObject*
SbkQAbstractAnimationFunc_updateState(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "updateState", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[1])) {
        QAbstractAnimation::State cpp_arg0 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[0]);
        QAbstractAnimation::State cpp_arg1 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[1]);
        // updateState(QAbstractAnimation::State,QAbstractAnimation::State)
        QAbstractAnimation* cppSelf = Shiboken::Converter<QAbstractAnimation* >::toCpp((PyObject*)self);
        cppSelf->QAbstractAnimation::updateState(cpp_arg0, cpp_arg1);
    } else goto SbkQAbstractAnimationFunc_updateState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractAnimationFunc_updateState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.State, PySide.QtCore.QAbstractAnimation.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractAnimation.updateState", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractAnimation_methods[] = {
    {"currentLoop", (PyCFunction)SbkQAbstractAnimationFunc_currentLoop, METH_NOARGS},
    {"currentLoopTime", (PyCFunction)SbkQAbstractAnimationFunc_currentLoopTime, METH_NOARGS},
    {"currentTime", (PyCFunction)SbkQAbstractAnimationFunc_currentTime, METH_NOARGS},
    {"direction", (PyCFunction)SbkQAbstractAnimationFunc_direction, METH_NOARGS},
    {"duration", (PyCFunction)SbkQAbstractAnimationFunc_duration, METH_NOARGS},
    {"event", (PyCFunction)SbkQAbstractAnimationFunc_event, METH_O},
    {"group", (PyCFunction)SbkQAbstractAnimationFunc_group, METH_NOARGS},
    {"loopCount", (PyCFunction)SbkQAbstractAnimationFunc_loopCount, METH_NOARGS},
    {"pause", (PyCFunction)SbkQAbstractAnimationFunc_pause, METH_NOARGS},
    {"resume", (PyCFunction)SbkQAbstractAnimationFunc_resume, METH_NOARGS},
    {"setCurrentTime", (PyCFunction)SbkQAbstractAnimationFunc_setCurrentTime, METH_O},
    {"setDirection", (PyCFunction)SbkQAbstractAnimationFunc_setDirection, METH_O},
    {"setLoopCount", (PyCFunction)SbkQAbstractAnimationFunc_setLoopCount, METH_O},
    {"setPaused", (PyCFunction)SbkQAbstractAnimationFunc_setPaused, METH_O},
    {"start", (PyCFunction)SbkQAbstractAnimationFunc_start, METH_NOARGS|METH_O},
    {"state", (PyCFunction)SbkQAbstractAnimationFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkQAbstractAnimationFunc_stop, METH_NOARGS},
    {"totalDuration", (PyCFunction)SbkQAbstractAnimationFunc_totalDuration, METH_NOARGS},
    {"updateCurrentTime", (PyCFunction)SbkQAbstractAnimationFunc_updateCurrentTime, METH_O},
    {"updateDirection", (PyCFunction)SbkQAbstractAnimationFunc_updateDirection, METH_O},
    {"updateState", (PyCFunction)SbkQAbstractAnimationFunc_updateState, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractAnimation_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QAbstractAnimation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QAbstractAnimationWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractAnimation_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractAnimation_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QAbstractAnimation_Direction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QAbstractAnimation_Direction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QAbstractAnimation_Direction_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Direction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QAbstractAnimation_Direction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QAbstractAnimation_Direction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QAbstractAnimation_Direction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DeletionPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QAbstractAnimation_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QAbstractAnimation_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QAbstractAnimation_State_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QAbstractAnimation_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QAbstractAnimation_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QAbstractAnimation_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QAbstractAnimation(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractAnimation_Type);

    SbkQAbstractAnimation_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractAnimation_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractAnimation_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractAnimation_Type));
    PyModule_AddObject(module, "QAbstractAnimation",
        ((PyObject*)&SbkQAbstractAnimation_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Direction
    SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX] = &SbkPySide_QtCore_QAbstractAnimation_Direction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QAbstractAnimation_Direction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QAbstractAnimation_Direction_Type);
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
            "Direction",((PyObject*)&SbkPySide_QtCore_QAbstractAnimation_Direction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_Direction_Type,
        (long) QAbstractAnimation::Forward, "Forward");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "Forward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_Direction_Type.tp_dict,
        "Forward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_Direction_Type,
        (long) QAbstractAnimation::Backward, "Backward");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "Backward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_Direction_Type.tp_dict,
        "Backward", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractAnimation::Direction");

    // init enum class: DeletionPolicy
    SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX] = &SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type);
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
            "DeletionPolicy",((PyObject*)&SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type,
        (long) QAbstractAnimation::KeepWhenStopped, "KeepWhenStopped");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "KeepWhenStopped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type.tp_dict,
        "KeepWhenStopped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type,
        (long) QAbstractAnimation::DeleteWhenStopped, "DeleteWhenStopped");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "DeleteWhenStopped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Type.tp_dict,
        "DeleteWhenStopped", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractAnimation::DeletionPolicy");

    // init enum class: State
    SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX] = &SbkPySide_QtCore_QAbstractAnimation_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QAbstractAnimation_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QAbstractAnimation_State_Type);
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtCore_QAbstractAnimation_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_State_Type,
        (long) QAbstractAnimation::Stopped, "Stopped");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "Stopped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_State_Type.tp_dict,
        "Stopped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_State_Type,
        (long) QAbstractAnimation::Paused, "Paused");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "Paused", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_State_Type.tp_dict,
        "Paused", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QAbstractAnimation_State_Type,
        (long) QAbstractAnimation::Running, "Running");
    PyDict_SetItemString(SbkQAbstractAnimation_Type.super.ht_type.tp_dict,
        "Running", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QAbstractAnimation_State_Type.tp_dict,
        "Running", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractAnimation::State");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractAnimation >("QAbstractAnimation*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractAnimation >(typeid(QAbstractAnimation).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

