/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "test_dynamic_slot.h"
#include "pyside.hpp"
#include "pyqt_signal_slot.hpp"

#include <QtTest/QTest>
#include <QTimer>
#include <QMetaMethod>
#include <QDebug>

using namespace boost::python;
using namespace PySide;

void test_dynamic_slot::init()
{
}

void test_dynamic_slot::cleanup()
{
}

void test_dynamic_slot::test_register_dynamic_signal()
{
    Py_Initialize();
    object main_module = import("__main__");
    object qt_module = import("PySide.QtCore");

    try {
        type_manager::instance(); // register type converters
        signal_manager& sm = signal_manager::instance();

        QTimer timer;

        QObject *d = sm.register_dynamic_signal(0, &timer, pyqt_signal("timeout()"), pyqt_signal("dsignal()"));
        QVERIFY(d->metaObject()->indexOfSignal("dsignal()") != -1);
    } catch(error_already_set&) {
        PyErr_Print();
        QFAIL("Python raised an error!");
    }
    Py_Finalize();
}

void test_dynamic_slot::test_register_dynamic_slot()
{
    Py_Initialize();
    object main_module = import("__main__");

    try {
        type_manager::instance(); // register type converters
        signal_manager& sm = signal_manager::instance();

        const int DELTA = QObject::metaObject()->methodCount();
        QObject qobj;

        object callback = eval("lambda : None");
        QString funcName = extract<QString>(str(callback));
        funcName.replace(QRegExp("[ \\.<>]"), "") += "()";

        QString slotName;
        sm.register_dynamic_slot(&qobj, callback, slotName);
        const QMetaObject* metaobj = sm.get_dynamic_metaobject(&qobj);
        QCOMPARE(metaobj->className(), "QObject");
        QCOMPARE(metaobj->methodCount(), DELTA+1);
        QCOMPARE(metaobj->indexOfSlot(qPrintable(funcName)), DELTA);
        QCOMPARE(QString(metaobj->method(DELTA).signature()), funcName);
    } catch(error_already_set&) {
        PyErr_Print();
        QFAIL("Python raised an error!");
    }
    Py_Finalize();
}

QTEST_APPLESS_MAIN( test_dynamic_slot )
#include "test_dynamic_slot.moc"
