/**
 * Support a QByteArray as format value
 **/
static bool
qimage_save(const QImage &self,
            const QString &fileName,
            const QByteArray &format,
            int quality = -1)
{
    return self.save(fileName, (const char *) format, quality);
}

/**
 * Support a python string as format value
 **/
static QImage
qimage_from_data(const python::str &data, const python::str &format)
{
    const uchar* chr_data = python::extract<const uchar*>(data);
    const char* chr_format = python::extract<const char*>(format);

    return QImage::fromData(chr_data, len(data), chr_format);
}

/**
 * Support a python::string as data and format value
 **/
static bool
qimage_load_from_data(QImage &self,
                      const python::str &data,
                      const python::str &format)
{
    const uchar* chr_data = python::extract<const uchar*>(data);
    const char* chr_format = python::extract<const char*>(format);

    return self.loadFromData(chr_data, len(data), chr_format);
}
