    python_cls
       /**[sphinx-begin]
        *
        *  .. method:: QLayout.addLayout(layout, row, column, alignment)
        *      .. param: layout - QLayout
        *      .. param: row - int
        *      .. param: column - int
        *      .. param: alignment - Qt.Alignment
        *
        * Places the layout at position (row, column) in the grid. The top-left position is (0, 0).
        * The alignment is specified by alignment. The default alignment is 0, which means that the widget fills the entire cell.
        * A non-zero alignment indicates that the layout should not grow to fill the available space but should be sized according to sizeHint().
        *
        [sphinx-end]**/
        .def("addLayout", qgridlayout_addLayout,
                (python::arg(0), python::arg(0), python::arg(0), python::arg(0) = 0))
       /**[sphinx-begin]
        *
        *  .. method:: QLayout.addLayout(layout, row, column, rowspam, colspam, alignment)
        *      .. param: layout - QLayout
        *      .. param: row - int
        *      .. param: column - int
        *      .. param: rowspam - int
        *      .. param: colspam - int
        *      .. param: alignment - Qt.Alignment
        *
        * This is an overloaded function.
        * This version adds the layout layout to the cell grid, spanning multiple rows/columns. The cell will start at row, column spanning rowSpan rows and columnSpan columns.
        * If rowSpan and/or columnSpan is -1, then the layout will extend to the bottom and/or right edge, respectively.
        *
        [sphinx-end]**/
        .def("addLayout", qgridlayout_addLayout_with_span,
                (python::arg(0), python::arg(0), python::arg(0), python::arg(0), python::arg(0) = 0))
       /**[sphinx-begin]
        *
        *  .. method:: QLayout.addWidget(widget, row, column, alignment)
        *      .. param: widget - QWidget
        *      .. param: row - int
        *      .. param: column - int
        *      .. param: alignment - Qt.Alignment
        *
        * Adds the given widget to the cell grid at row, column. The top-left position is (0, 0) by default.
        * The alignment is specified by alignment. The default alignment is 0, which means that the widget fills the entire cell.
        *
        [sphinx-end]**/
        .def("addWidget", qgridlayout_addWidget,
                (python::arg(0), python::arg(0), python::arg(0), python::arg(0) = 0))
       /**[sphinx-begin]
        *
        *  .. method:: QLayout.addWidget(widget, row, column, rowspam, colspam, alignment)
        *      .. param: widget - QWidget
        *      .. param: row - int
        *      .. param: column - int
        *      .. param: rowspam - int
        *      .. param: colspam - int
        *      .. param: alignment - Qt.Alignment
        *
        * This is an overloaded function.
        * This version adds the given widget to the cell grid, spanning multiple rows/columns. The cell will start at fromRow, fromColumn spanning rowSpan rows and columnSpan columns. The widget will have the given alignment.
        * If rowSpan and/or columnSpan is -1, then the widget will extend to the bottom and/or right edge, respectively.
        *
        [sphinx-end]**/
        .def("addWidget", qgridlayout_addWidget_with_span,
                (python::arg(0), python::arg(0), python::arg(0), python::arg(0), python::arg(0) = 0));

