/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "qhandle.hpp"
#include "boost_headers.hpp"


using namespace boost;

namespace PySide
{

qhandle::qhandle(Qt::HANDLE h)
    :m_handle(h)
{
}

qhandle::qhandle(const qhandle &other)
{
    m_handle = other.get_handle();
}

Qt::HANDLE qhandle::get_handle() const
{
    return m_handle;
}

unsigned long qhandle::to_long() const
{
#if defined(Q_WS_X11)
    return m_handle;
#else
    return reinterpret_cast<unsigned long>(m_handle);
#endif
}

void qhandle::export_python_class()
{
    python::class_<qhandle>("QHANDLE", python::no_init)
        .def("__int__", &qhandle::to_long);
    python::implicitly_convertible<Qt::HANDLE, qhandle>();
}

} // namespace PySide


