#ifndef SEQUENCE_HELPER_HPP
#define SEQUENCE_HELPER_HPP

#include <boost/python/slice.hpp>
#include <boost/python/str.hpp>

template<typename Container>
static boost::python::object sequence_len(const Container& self)
{
    return boost::python::object(self.length());
}

template<typename Container>
static boost::python::object sequence_get_item_by_pos(const Container& self, const int& pos)
{
    int new_pos = pos;

    if (pos < 0)
        new_pos = self.length() + pos;

    if (new_pos < self.length() && new_pos >= 0) {
        return boost::python::object(self[new_pos]);
    } else {
        throw std::out_of_range("index out-of-range");
    }
}

template<typename Container>
static boost::python::object sequence_get_item_slice(const Container& self, const boost::python::slice& slice)
{
//     PyObject* pyObj = slice.ptr();
    Py_ssize_t start = 0;
    Py_ssize_t stop = -1;

    if (slice.start().ptr() != Py_None)
        start = boost::python::extract<Py_ssize_t>(slice.start());

    if (slice.stop().ptr() != Py_None)
        stop = boost::python::extract<Py_ssize_t>(slice.stop());

    return boost::python::object(self.mid(start, stop));
}

template<typename Container>
static void sequence_set_item(Container& self, const int& pos, const char& new_value)
{
    int new_pos = pos;

    if (pos < 0)
        new_pos = self.length() + pos;

    if (new_pos < self.length() && new_pos >= 0)
        self[new_pos] = new_value;
    else
        throw std::out_of_range("index out-of-range");
}

#endif
