/**
 * Tranfer objects ownership form layout to widget
 **/
static void
qwidget_reparent_layout(QWidget *parent, QLayout *layout)
{
    PySide::qptr<QWidget> ptr_parent(parent);

    for (int i=0; i < layout->count(); i++)
    {
        QLayoutItem *item = layout->itemAt(i);
        QWidget *w = item->widget();

        if (w)
        {
            python::object obj(PySide::ptr(w));
            PySide::qptr<QWidget> ptr_item(obj.ptr());
            ptr_parent.add_child(ptr_item);
        }
        else
        {
            QLayout *l = item->layout();
            if (l)
                qwidget_reparent_layout(parent, l);
        }
    }

    PySide::qptr<QLayout> ptr_layout(layout);
    ptr_parent.add_child(ptr_layout);
}

static void
qwidget_set_layout(QWidget *self, QLayout *layout)
{
    if (self->layout())
        return;

    qwidget_reparent_layout(self, layout);
    self->setLayout(layout);
}
