/**
 * Pythonic QShortcut constructor
 * Ex: QShortcut(QKeySequence, parent, SLOT("member"), SLOT("abigousMember"), context)
 **/
qshortcut_wrapper::qshortcut_wrapper(PyObject *self, const QKeySequence & key,
                                     QWidget* parent,
                                     const pyqt_slot& member,
                                     const pyqt_slot& ambiguousMember,
                                     Qt::ShortcutContext context)
    : QShortcut(key, parent,
                (member.is_null() ?
                    (const char *)0 : member.toQtStyleSignature().data()),
                 (ambiguousMember.is_null() ?
                    (const char *)0 : ambiguousMember.toQtStyleSignature().data()),
                context), wrapper(self)
{
}

/**
 * Pythonic QShortcut constructor
 * Ex: QShortcut(QKeySequence, parent, python-callbak, python-callback, context)
 **/
qshortcut_wrapper::qshortcut_wrapper(PyObject *self, const QKeySequence & key,
                                     QWidget* parent,
                                     python::object& member,
                                     python::object ambiguousMember,
                                     Qt::ShortcutContext context )
    : QShortcut(parent), wrapper(self)
{
    setKey(key);
    setContext(context);
    signal_manager& sm = signal_manager::instance();
    if (member) {
        sm.connect(this, pyqt_signal("activated()"), member);
    }
    if (ambiguousMember) {
        sm.connect(this, pyqt_signal("activatedAmbiguously()"), ambiguousMember);
    }
}
