#!/usr/bin/env python

import sys
import os
from subprocess import Popen, PIPE

'''Run all python scripts inside the given directories or try to find
the tests in the current directory'''

def run_test(filename, timeout):
    #these classes are needed only here
    from processtimer import ProcessTimer, TimeoutException

    deadlock = False

    sys.stdout.write("Running test file %-60s" % filename)
    proc = Popen(['python', filename], stdout=PIPE, stderr=PIPE)

    #retcode = proc.wait()

    t = ProcessTimer(proc,timeout)
    try:
       t.waitfor()
    except TimeoutException:
       #timeout; possible deadlock
       os.kill(proc.pid,9)
       deadlock = True

    if deadlock:
       print 'timeout: %s seconds' % (timeout)
       return False
    else: 
       retcode = proc.poll()
       if retcode == 0:
           print 'ok'
           return True
       else:
           print 'failed'
           return False

def run_directory(directory):
    tests = filter(lambda x: x.endswith('.py'), os.listdir(directory))
    tests.sort()

    passed = 0
    failed = []

    for test in tests:
        # for the time being the timeout is fixed in 10 seconds;
        # if needed, specific timeouts by test can be used (so longer
        # tests can run without being mercilessly killed)
        if run_test(os.path.join(directory, test), 10):
            passed += 1
        else:
            failed.append(test)

    return passed, failed


def main(argv=None):
    if argv is None:
        argv = sys.argv

    ignore_dirs = ['util']

    # Add util to path. Couldn't modify sys.path as needs to be
    # passed to the sub processes
    extra_path = os.path.join(os.getcwd(),'util')
    try:
        os.environ['PYTHONPATH'] += ':' + extra_path
    except KeyError:
        os.environ['PYTHONPATH'] = extra_path

    # as this file needs a class inside extra_path, add
    # it to sys.path for using it locally and import
    # the class in the needed function
    sys.path.append(extra_path)

    if len(argv) == 1:
        dirs = filter(lambda x: os.path.isdir(x), os.listdir(os.getcwd()))
    else:
        dirs = [arg[:-1] for arg in argv[1:] if arg[-1] == os.path.sep] + \
               [arg for arg in argv[1:] if arg[-1] != os.path.sep]
        dirs = [os.path.basename(arg) for arg in dirs if os.path.isdir(arg)]

    dirs = [x for x in dirs if not (x in ignore_dirs)]
    dirs.sort()

    passed = 0
    failed = []

    for directory in dirs:
        print 'Running tests inside %s' % directory
        x, y = run_directory(directory)
        passed += x
        failed += y

    print('-'*79)
    print('Successful tests: %d' % passed)
    print('Failed tests: %d' % len(failed))
    for test in failed:
        print('\t%s' % test)


if __name__ == '__main__':
    main()
