/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __QAPP_POLICY_HPP__
#define __QAPP_POLICY_HPP__

#include <boost_headers.hpp>
#include <pyside_global.hpp>

namespace PySide
{

//this function update qApp attribute
void PYSIDE_API set_qApp_macro(PyObject *qApp_value, bool initialize = false);
bool PYSIDE_API check_qApp_instance();

static int app_argc = 0;
static char** app_argv = 0;

template <
    std::size_t list_argument
  , class BasePolicy_ = boost::python::default_call_policies>
struct PYSIDE_LOCAL application_object_constructor : BasePolicy_
{
    // Ownership of this argument tuple will ultimately be adopted by
    // the caller.
    template <class ArgumentPackage>
    static bool
    precall(ArgumentPackage const& args_)
    {
        if (check_qApp_instance()) {
            PyErr_SetString(PyExc_RuntimeError,
                            "Application error: There should be only one application object");
            return false;
        }


        if (app_argv != 0) {
            for (int i = 0; i < app_argc; i++) {
                delete[] app_argv;
            }
            delete[] app_argv;
            app_argv = 0;
        }

        PyObject *app_args = boost::python::detail::get_prev<list_argument>::execute(args_);
        if (PyList_Check(app_args)) {
            app_argc = PyList_GET_SIZE(app_args);
            if (app_argc != 0) {
                app_argv = new char*[app_argc];
                for (int i = 0; i < app_argc; ++i) {
                    char *orig_arg = PyString_AS_STRING(PyList_GET_ITEM(app_args, i));
                    int size = strlen(orig_arg);
                    app_argv[i] = new char[size+1];
                    app_argv[i] = strcpy(app_argv[i], orig_arg);
                }
            }
        }
        return BasePolicy_::precall(args_);
    }

    template <class ArgumentPackage>
    static PyObject*
    postcall(ArgumentPackage const& args_, PyObject* result)
    {

         result = BasePolicy_::postcall(args_, result);

         PyObject *self =  boost::python::detail::get_prev<1>::execute(args_, result);
         // The QApplication instance can never be deleted, because we dont
         // know the PyObjects destruction order, so we never destroy the
         // QApplication PyObject and schedule the QApplication destrution in
         // a Py_AtExit function.
         Py_IncRef(self);
         set_qApp_macro(boost::python::incref(self));
         return result;
    }

};

} // namespace PySide

#endif
