/**
 * SIGNAL/SLOT class implemenation
 **/
static python::str
pyqt_slot_to_str(pyqt_slot& self)
{
    return python::str(self.toQtStyleSignature().constData());
}

static bool
pyobject_inherits(PyObject *obj, const char *class_name)
{
    if (!PyType_Check(obj))
        return false;

    PyObject *name = PyObject_GetAttrString(obj, "__name__");
    char *str_name = PyString_AS_STRING(name);
    Py_DECREF(name);

    if (strcmp(str_name, class_name) == 0)
        return true;

    PyObject *base = (PyObject *) ((PyTypeObject *)obj)->tp_base;
    if (base == 0)
        return false;

    return pyobject_inherits(base, class_name);
}

/**
 * Compatible with Python inherits implementation
 **/
static bool
qobject_inherits(QObject *obj,
                 const char *class_name)
{
    python::object py_obj(PySide::ptr(obj));
    PyObject *py_type = PyObject_Type(py_obj.ptr());

    bool ret = pyobject_inherits(py_type, class_name);
    Py_DECREF(py_type);

    if (ret)
        return true;
    else
        return obj->inherits(class_name);
}

/**
 * Implements QObject.findChildren using PyType as object type
 **/
static PyObject*
qobject_find_children(QObject *self,
                      const python::object &type,
                      const QString &object_name)
{
    PyObject* ret = PyList_New(0);
    std::string type_name =
        python::extract<std::string>(type.attr("__name__"));

    QList<QObject *> objs = self->children();
    foreach(QObject *o, objs)
    {
        if ((object_name.isEmpty() || object_name == o->objectName()) &&
            qobject_inherits(self, type_name.c_str()))
        {
            PyList_Append(ret,
                          python::incref(python::object(PySide::ptr(o)).ptr()));
        }
    }

    Py_INCREF(ret);
    return ret;
}

/**
 * Implements QObject.findChild using PyType as object type
 **/
static PyObject*
qobject_find_child(QObject *self,
                   const python::object &type,
                   const QString &object_name)
{
    std::string type_name =
        python::extract<std::string>(type.attr("__name__"));

    QList<QObject *> objs = self->children();
    foreach(QObject *o, objs)
    {
        if ((object_name.isEmpty() || object_name == o->objectName()) &&
            qobject_inherits(self, type_name.c_str()))
        {
            return python::incref(python::object(PySide::ptr(o)).ptr());
        }
    }

    Py_RETURN_NONE;
}

/**
 * Pythonic way of emit QObject signal
 **/
static python::tuple
emit_python_signal(const python::tuple &args, const python::dict &kw)
{
    //sender
    QObject *q_object = python::extract<QObject*>(args[0]);

    //signal
    const pyqt_signal* signal = python::extract<pyqt_signal*>(args[1]);

    //args
    int n = len(args);
    python::list func_args;
    for (int i=2; i < n; i++)
        func_args.append(args[i]);

    signal_manager::instance().emit_(q_object, *signal, func_args);
    return python::tuple();
}

/**
 * Pythonic way of connect signal -> python-callback
 * E.g. object.connect(SIGNAL("signal-name"), python-callback)
 **/
static bool
connect_python_signal(QObject &o,
                      const pyqt_signal& signal,
                      python::object callback, Qt::ConnectionType type)
{
    return signal_manager::instance().connect(&o, signal, callback, type);
}

/**
 * Pythonic way of coonect signal/slot
 * E.g. object.connect(SIGNAL("signa-name"), object, SLOT("slot-name"))
 **/
static bool
connect_python_signal2(QObject& sender,
                       const pyqt_signal& signal,
                       QObject& receiver,
                       const pyqt_slot& slot,
                       Qt::ConnectionType type)
{
    return signal_manager::instance().connect(&sender, signal, &receiver, slot, type);
}

/**
 * PyQt4 compatibility
 * E.g. QObject.connect(object, SIGNAL("signal-name"), python-callback)
 */
static bool
connect_python_signal3(QObject&,
                       QObject& src, const pyqt_signal& signal,
                       python::object callback,
                       Qt::ConnectionType type)
{
    return signal_manager::instance().connect(&src, signal, callback, type);
}

/**
 * PyQt4 compatibility static use
 * E.g. QObject.connect(object, SIGNAL("signal-name"), object, SLOT("slot-name"))
 */
static bool
connect_python_signal4(QObject&,
                       QObject& sender,
                       const pyqt_signal& signal,
                       QObject& receiver,
                       const pyqt_slot& slot,
                       Qt::ConnectionType type)
{
    return signal_manager::instance().connect(&sender, signal, &receiver, slot, type);
}

/**
 * PyQt4 compatibility
 * E.g. object.connect(object, SIGNAL("signal-name"), SLOT("slot-name"))
 **/
static bool
connect_python_signal5(QObject& self,
                       QObject& sender,
                       const pyqt_signal& signal,
                       const pyqt_slot& slot,
                       Qt::ConnectionType type)
{
    return signal_manager::instance().connect(&sender, signal, &self, slot, type);
}

/**
 * Pythonic disconnect
 * E.g. object.disconnect(SIGNAL("signal-name"), python-callback)
 **/
static bool
disconnect_python_signal(QObject& o,
                         const pyqt_signal& signal,
                         boost::python::object callback)
{
    return signal_manager::instance().disconnect(&o, signal, callback);
}

/**
 * Pythonic disconnect
 * E.g. object.disconnect(object, SIGNAL("signal-name"), object, SLOG("slot-name")
 **/
static bool
disconnect_python_signal2(QObject& sender,
                          const pyqt_signal& signal,
                          QObject& receiver,
                          const pyqt_slot& slot)
{
    return signal_manager::instance().disconnect(&sender,
                                                 signal,
                                                 &receiver,
                                                 slot);
}

/**
 * PyQt4 compatibility static use
 * E.g. QObject.disconnect(object, SIGNAL("signal-name"), python-callbak)
 */
static bool
disconnect_python_signal3(QObject&,
                          QObject& src,
                          const pyqt_signal& signal,
                          boost::python::object callback)
{
    return signal_manager::instance().disconnect(&src, signal, callback);
}

/**
 * PyQt4 compatibility static use
 * E.g. QObject.discoonect(object, SIGNAL("signal-name"), object, SLOT("slot-name"))
 **/
static bool
disconnect_python_signal4(QObject &,
                          QObject &sender,
                          const pyqt_signal& signal,
                          QObject& receiver,
                          const pyqt_slot& slot)
{
    return signal_manager::instance().disconnect(&sender,
                                                 signal,
                                                 &receiver,
                                                 slot);
}

/**
 * For Debug use
 */
#ifndef NDEBUG
static void _qobject_dump(QObject *self)
{
       PyObject *py_self;

        {
            python::object wrapper(PySide::ptr(self));
            py_self = wrapper.ptr();
        }
        long hash = 0;
        long refcount = -1;

        hash = PyObject_Hash(py_self);
        refcount = py_self->ob_refcnt;

        printf("pyobj: %p, c++: %p, hash: %ld, refcount: %ld\n",
                py_self, &self, hash, refcount);

}
#endif

/**
 * PyQt4 tr compatibility
 **/
static QString
qobject_tr(const QObject &self,
           const char *sourceText,
           const char *comment = 0,
           int n = -1)
{
    QString result;
    if (QCoreApplication::instance()) {
        python::object wrapper(PySide::ptr(&self));
        const char *cname = python::extract<const char*>(wrapper.attr("__class__").attr("__name__"));


        result = QString(QCoreApplication::instance()->translate(cname,
                         sourceText, comment,
                         QCoreApplication::CodecForTr, n));
    } else {
        result = QString(QString::fromLatin1(sourceText));
    }
    return result;
}

/**
 * PyQt4 tr compatibility
 **/
static QString
qobject_trutf8(const QObject &self,
               const char *sourceText,
               const char *comment = 0,
               int n = -1)
{
    QString result;
    if (QCoreApplication::instance()) {
        python::object wrapper(PySide::ptr(&self));
        const char *cname = python::extract<const char*>(wrapper.attr("__class__").attr("__name__"));

        result = QString(QCoreApplication::instance()->translate(cname,
                         sourceText, comment,
                         QCoreApplication::UnicodeUTF8, n));
    } else {
        result = QString(QString::fromLatin1(sourceText));
    }
    return result;
}

/**
 * Wrapper function to overload QObject.metaObject to return
 * a dynamical metaObject base on new Python QObject functions (slots/signals)
 **/
static const
QMetaObject* qobject_metaObject(QObject& self)
{
    return signal_manager::instance().get_dynamic_metaobject(&self);
}
