/**
 * Implement convertion from QByteArray to python string
 **/
static python::object
qbytearray_to_string(QByteArray &self)
{
        std::string str(const_cast<char *>(self.data()));
        return python::object(str);
}

/**
 * Implement QByteArray.radd function with a python string in last argument
 **/
static python::object
qbytearray_operator_radd(python::object& self, const python::object& other)
{
    PyObject* pyOther= other.ptr();
    if (PyString_Check(pyOther)) {
        QByteArray cppSelf = python::extract<QByteArray>(self);
        QByteArray result(PyString_AS_STRING(pyOther));
        result += cppSelf;
        return python::object(result);
    } else if (PyUnicode_Check(pyOther)) {
        PyObject *result = PyUnicode_Concat(pyOther, self.ptr());
        return python::object(python::handle<>(python::detail::borrowed_reference(result)));
    } else {
        // FIXME throw a type error
        python::throw_error_already_set();
        return python::object();
    }
}

/**
 * Python buffer protocol function
 * see: http://www.python.org/dev/peps/pep-3118/
 **/
static Py_ssize_t
qbytearray_getsegcount(PyObject *self, Py_ssize_t *lenp)
{
    if (lenp) {
        python::object boost_self = python::object(python::handle<>(python::detail::borrowed_reference(self)));
        QByteArray qbytearray = python::extract<QByteArray>(boost_self);
        *lenp = qbytearray.size();
    }
    return 1;
}

static Py_ssize_t
qbytearray_getreadbuffer_getcharbuffer(PyObject *self, Py_ssize_t segment, void **ptrptr)
{
    if (segment != 0) {
        PyErr_SetString(PyExc_SystemError, "accessing non-existent QByteArray segment");
        return -1;
    }
    python::object boost_self = python::object(python::handle<>(python::detail::borrowed_reference(self)));
    QByteArray qbytearray = python::extract<QByteArray>(boost_self);

    *ptrptr = (void *)qbytearray.data();
    return qbytearray.size();
}
