import hildon
from lxml import etree
import pyrecipe_utils
import gettext

def show_info_banner(widget, msg):
    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

class GourmetXML:
    def __init__ (self, exp_recipe_list, window, widget):
        rid = 0
        for recipe in range(len(exp_recipe_list)):

            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            imagesrc = exp_recipe_list[recipe][9]

            if recipe == 0:
                xmldocu = self.write_xml(title, instructions, category,
                        ingredients, preptime, cooktime, servings, notes, None,
                        rid, imagesrc)
            else:
                xmldocu = self.write_xml(title, instructions, category,
                        ingredients, preptime, cooktime, servings, notes,
                        xmldocu, rid, imagesrc)

            rid += 1


        if len(exp_recipe_list) > 1:
            title = _('Recipes')

        namefile = pyrecipe_utils.show_filechooser_dialog(window, 'save',
                        _('Save recipe as '), title, 'Gourmet XML', 'grmt')

        if namefile == None:
            print 'No saving recipe.'
            return

        success = pyrecipe_utils.save_xml_file(namefile, xmldocu)

        if success == True:
            show_info_banner(widget, _('Recipes saved'))
        else:
            show_info_banner(widget, _('Error ocurred while exporting the file'))

    def write_xml(self, title, instructions, category, ingredients, \
                  preptime, cooktime, servings, notes, xmldocu, rid, image):

        if xmldocu is None:
            xmldocu  = etree.Element("gourmetDoc")
        else:
            xmldocu = etree.XML(xmldocu)


        recipe = etree.SubElement(xmldocu, "recipe")
        recipe.set("id", str(rid))

        title_element = etree.SubElement(recipe, 'title')
        title_element.text = title

        category_element = etree.SubElement(recipe, 'category')
        category_element.text = category


        img_element = etree.SubElement(recipe, 'image')
        img_element.set("format", "jpg")
        image = "<![CDATA[" + image.replace('"""', '') + "]]>"
        img_element.text = image


        preptime_element = etree.SubElement(recipe, 'preptime')
        preptime_element.text = preptime

        cooktime_element = etree.SubElement(recipe, 'cooktime')
        cooktime_element.text = cooktime

        servings_element = etree.SubElement(recipe, 'servings')
        servings_element.text = servings

        ing_list_element = etree.SubElement(recipe, 'ingredient-list')

        ing_list = pyrecipe_utils.ingredients_to_inglist(ingredients)

        for i in range(len(ing_list)):
            ingredient_element = etree.SubElement(ing_list_element, 'ingredient')
            amount_element = etree.SubElement(ingredient_element, 'amount')
            amount_element.text = ing_list[i][0]

            units_element = etree.SubElement(ingredient_element, 'unit')
            units_element.text = ing_list[i][1]

            items_element = etree.SubElement(ingredient_element, 'item')
            items_element.text = ing_list[i][2]


        instructions_element = etree.SubElement(recipe, 'instructions')
        instructions_element.text = instructions

        notes_element = etree.SubElement(recipe, 'modifications')
        notes_element.text = notes

        xmldocu = (etree.tostring(xmldocu, pretty_print=True))

        return xmldocu
