import xmlrpclib
from urllib2 import urlopen
from urllib2 import ProxyHandler
from urllib2 import build_opener
from urllib2 import install_opener
import time

import crypt
import keys
import sys

def _inttime():
        return int( time.time() )

class PandoraError(Exception):
	def __init__( self, value ):
		self.value = value
	def __str__( self ):
		return repr( self.value )

class Pandora:
        rid = ""
        lid = ""
        authToken = ""
        curStation = ""
        curFormat = "mp3" #Default to mp3 if not specified
        protocol_version=31
        base_url = "https://www.pandora.com/radio/xmlrpc/v%d?" %protocol_version
        base_url_rid = base_url + "rid=%sP&method=%s"
        base_url_lid = base_url + "rid=%sP&lid=%s&method=%s"
        proxy = ""

        def __init__( self ):
                self.rid = "%07i" %( time.time() % 10000000 )

        def __init__( self, format, pv ):
                self.rid = "%07i" %( time.time() % 10000000 )
                if pv > self.protocol_version:
                    self.protocol_version=pv
		self.dataDir = sys.path[0]+"/libpiano/"
                self.base_url = "https://www.pandora.com/radio/xmlrpc/v%d?" %(self.protocol_version)
                self.base_url_rid = self.base_url + "rid=%sP&method=%s"
                self.base_url_lid = self.base_url + "rid=%sP&lid=%s&method=%s"
		self.keys = keys.Keys( self.dataDir, self.protocol_version )
		if not self.keys.loadKeys():
			raise PandoraError("Unable to load Keys");
                self.curFormat = format

        def set_proxy( self, proxy ):
                if len(proxy)>0:
                        proxy_handler = ProxyHandler({"http": proxy})
                else:
                        proxy_handler = ProxyHandler({})
                opener = build_opener(proxy_handler)
                install_opener(opener)

        def sync( self ):
                reqUrl = self.base_url_rid %( self.rid, "sync" )

                req = xmlrpclib.dumps( (), "misc.sync" ).replace( "\n", "" )
                enc = crypt.encryptString( req )

                try:
                        u = urlopen( reqUrl, enc )
                        resp = u.read()
                        u.close()
                except:
                        return False

        def authListener( self, user, pwd ):
                new_version = self.protocol_version
                while True:
                        reqUrl = self.base_url_rid %( self.rid, "authenticateListener" )
                        req = xmlrpclib.dumps( ( _inttime(), user, pwd ), \
                                                "listener.authenticateListener" )
                        req = req.replace( "\n", "" )
                        enc = crypt.encryptString( req, self.keys['out'] )
                        try:
                                u = urlopen( reqUrl, enc )
                                resp = u.read()
                                if resp.find('INCOMPATIBLE_VERSION')>0:
                                    new_version = new_version+1
                                    if new_version - self.protocol_version < 15:
                                            print "INCOMPATIBLE VERSION DETECTED, BUMPING."
                                            self.base_url = "https://www.pandora.com/radio/xmlrpc/v%d?" %(new_version)
                                            self.base_url_rid = self.base_url + "rid=%sP&method=%s"
                                            self.base_url_lid = self.base_url + "rid=%sP&lid=%s&method=%s"
                                            continue
                                    else:
                                            return False
                                u.close()
                        except:
                                return False
                        try:
                                parsed = xmlrpclib.loads( resp )[0][0]
                        except xmlrpclib.Fault, fault:
                                print "Error:", fault.faultString
                                print "Code:", fault.faultCode
                                return False

                        self.authToken = parsed["authToken"]
                        self.lid = parsed["listenerId"]
                        self.protocol_version=new_version
                        return True

        def getStations( self ):
                reqUrl = self.base_url_lid %( self.rid, self.lid, "getStations" )

                req = xmlrpclib.dumps( ( _inttime(), self.authToken ), \
                                                                "station.getStations" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close()

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def addFeedback( self, stationId=None, song=None, rating=None ):
                if stationId == None:
                        stationId = self.curStation
                if song[1]["musicId"] == None:
                        return
                if rating == None:
                        return

                reqUrl = self.base_url_lid %( self.rid, self.lid, "addFeedback" )

                args = ( _inttime(), self.authToken, stationId, song[1]["musicId"], \
                        song[1]["matchingSeed"], song[1]["userSeed"], song[1]["focusTraitId"], '', rating, False )

                req = xmlrpclib.dumps( args, "station.addFeedback" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close()

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def addSeed( self, stationId=None, musicId=None):
                if stationId == None:
                        stationId = self.curStation
                if musicId == None:
                        return

                reqUrl = self.base_url_lid %( self.rid, self.lid, "addSeed" )

                args = ( _inttime(), self.authToken, stationId, musicId )

                req = xmlrpclib.dumps( args, "station.addSeed" )

                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def setTired( self, identity=None ):
                if identity == None:
                        return

                reqUrl = self.base_url_lid %( self.rid, self.lid, "addTiredSong" )

                args = ( _inttime(), self.authToken, identity )

                req = xmlrpclib.dumps( args, "listener.addTiredSong" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def searchPandora( self, search=None ):
                if search==None:
                        return

                reqUrl = self.base_url_lid %( self.rid, self.lid, "search" )

                args = ( _inttime(), self.authToken, search )

                req = xmlrpclib.dumps( args, "music.search" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def createStation( self, musicId=None ):
                if musicId == None:
                        return

                reqUrl = self.base_url_lid %( self.rid, self.lid, "createStation" )

                args = ( _inttime(), self.authToken, "mi"+musicId, "" )

                req = xmlrpclib.dumps( args, "station.createStation" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def deleteStation( self, stationId=None ):
                if stationId==None:
                        return

                reqUrl = self.base_url_lid %( self.rid, self.lid, "removeStation" )

                args = ( _inttime(), self.authToken, stationId )

                req = xmlrpclib.dumps( args, "station.removeStation" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                return parsed

        def getFragment( self, stationId=None, format=None ):
                if stationId == None:
                        stationId = self.curStation
                if format == None:
                        format = self.curFormat
                reqUrl = self.base_url_lid %( self.rid, self.lid, "getFragment" )

                args = ( _inttime(), self.authToken, stationId, "0", "", "", \
                                        format, "0", "0" )
                req = xmlrpclib.dumps( args, "playlist.getFragment" )
                req = req.replace( "\n", "" )
                enc = crypt.encryptString( req, self.keys['out'] )

                u = urlopen( reqUrl, enc )
                resp = u.read()
                u.close()

                try:
                        parsed = xmlrpclib.loads( resp )[0][0]
                except xmlrpclib.Fault, fault:
                        parsed = resp
                        print "Error:", fault.faultString
                        print "Code:", fault.faultCode

                #last 48 chars of URL encrypted, padded w/ 8 * '\x08'
                for i in range( len( parsed ) ):
                        url = parsed[i]["audioURL"]
                        url = url[:-48] + crypt.decryptString( url[-48:], self.keys['in'] )[:-8]
                        parsed[i]["audioURL"] = url

                self.curStation = stationId
                self.curFormat = format

                return parsed

