import xmlrpclib
from urllib2 import urlopen
import time

import crypt

PROTOCOL_VERSION=31
BASE_URL = "http://www.pandora.com/radio/xmlrpc/v%d?" %PROTOCOL_VERSION
BASE_URL_RID = BASE_URL + "rid=%sP&method=%s"
BASE_URL_LID = BASE_URL + "rid=%sP&lid=%s&method=%s"

def _inttime():
	return int( time.time() )

class Pandora:
	rid = ""
	lid = ""
	authToken = ""
	curStation = ""
	curFormat = "mp3" #Default to mp3 if not specified

	def __init__( self ):
		self.rid = "%07i" %( time.time() % 10000000 )

	def __init__( self, format ):
		self.rid = "%07i" %( time.time() % 10000000 )
		self.curFormat = format

	def sync( self ):
		reqUrl = BASE_URL_RID %( self.rid, "sync" )

		req = xmlrpclib.dumps( (), "misc.sync" ).replace( "\n", "" )
		enc = crypt.encryptString( req )

		try:
			u = urlopen( reqUrl, enc )
			resp = u.read()
			u.close()
		except:
			return False

	def authListener( self, user, pwd ):
		reqUrl = BASE_URL_RID %( self.rid, "authenticateListener" )

		req = xmlrpclib.dumps( ( _inttime(), user, pwd ), \
								"listener.authenticateListener" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		try:
			u = urlopen( reqUrl, enc )
			resp = u.read()
			u.close()
		except:
			return False

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			print "Error:", fault.faultString
			print "Code:", fault.faultCode
			return False

		self.authToken = parsed["authToken"]
		self.lid = parsed["listenerId"]
		return True

	def getStations( self ):
		reqUrl = BASE_URL_LID %( self.rid, self.lid, "getStations" )

		req = xmlrpclib.dumps( ( _inttime(), self.authToken ), \
								"station.getStations" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close()
		
		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed

	def addFeedback( self, stationId=None, song=None, rating=None ):
		if stationId == None:
			stationId = self.curStation
		if song[1]["musicId"] == None:
			return
		if rating == None:
			return

		reqUrl = BASE_URL_LID %( self.rid, self.lid, "addFeedback" )
		
		args = ( _inttime(), self.authToken, stationId, song[1]["musicId"], \
			song[1]["matchingSeed"], song[1]["userSeed"], song[1]["focusTraitId"], '', rating, False )

		req = xmlrpclib.dumps( args, "station.addFeedback" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req ) 

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close()

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed

	def addSeed( self, stationId=None, musicId=None):
		if stationId == None:
			stationId = self.curStation
		if musicId == None:
			return

		reqUrl = BASE_URL_LID %( self.rid, self.lid, "addSeed" )

		args = ( _inttime(), self.authToken, stationId, musicId )

		req = xmlrpclib.dumps( args, "station.addSeed" )

		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )
	
		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed

	def setTired( self, identity=None ):
		if identity == None:
			return

		reqUrl = BASE_URL_LID %( self.rid, self.lid, "addTiredSong" )

		args = ( _inttime(), self.authToken, identity )

		req = xmlrpclib.dumps( args, "listener.addTiredSong" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed

	def searchPandora( self, search=None ):
		if search==None:
			return
		
		reqUrl = BASE_URL_LID %( self.rid, self.lid, "search" )
		
		args = ( _inttime(), self.authToken, search )

		req = xmlrpclib.dumps( args, "music.search" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed  	

	def createStation( self, musicId=None ):
		if musicId == None:
			return

		reqUrl = BASE_URL_LID %( self.rid, self.lid, "createStation" )
		
		args = ( _inttime(), self.authToken, "mi"+musicId )

		req = xmlrpclib.dumps( args, "station.createStation" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed  
				
	def deleteStation( self, stationId=None ):
		if stationId==None:
			return
		
		reqUrl = BASE_URL_LID %( self.rid, self.lid, "removeStation" )
		
		args = ( _inttime(), self.authToken, stationId )

		req = xmlrpclib.dumps( args, "station.removeStation" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close
		
		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		return parsed  

	def getFragment( self, stationId=None, format=None ):
		if stationId == None:
			stationId = self.curStation
		if format == None:
			format = self.curFormat
		reqUrl = BASE_URL_LID %( self.rid, self.lid, "getFragment" )

		args = ( _inttime(), self.authToken, stationId, "0", "", "", \
					format, "0", "0" )
		req = xmlrpclib.dumps( args, "playlist.getFragment" )
		req = req.replace( "\n", "" )
		enc = crypt.encryptString( req )

		u = urlopen( reqUrl, enc )
		resp = u.read()
		u.close()

		try:
			parsed = xmlrpclib.loads( resp )[0][0]
		except xmlrpclib.Fault, fault:
			parsed = resp
			print "Error:", fault.faultString
			print "Code:", fault.faultCode

		#last 48 chars of URL encrypted, padded w/ 8 * '\x08'
		for i in range( len( parsed ) ):
			url = parsed[i]["audioURL"]
			url = url[:-48] + crypt.decryptString( url[-48:] )[:-8]
			parsed[i]["audioURL"] = url

		self.curStation = stationId
		self.curFormat = format

		return parsed

