#!/usr/bin/python2.5
import sys,time
import re
import os

from subprocess import Popen,PIPE

from PyQt4 import QtGui,QtCore
from PyQt4.QtGui import *
from pyPianobar_ui import *

class Config:
	def __init__(self):
		self.user = ""
		self.password = ""
		self.lastfm_user = ""
		self.lastfm_password = ""
		self.lastfm_scrobble_percent = "50"
		self.control_proxy = ""
		self.act_help = "?"
		self.act_songlove = "+"
		self.act_songban = "-"
		self.act_stationaddmusic = "a"
		self.act_stationcreate = "c"
		self.act_stationdelete = "d"
		self.act_songexplain = "e"
		self.act_stationaddbygenre = "g"
		self.act_songinfo = "i"
		self.act_addshared = "j"
		self.act_songmove = "m"
		self.act_songnext = "n"
		self.act_songpause = "p"
		self.act_quit = "q"
		self.act_stationrename = "r"
		self.act_stationchange = "s"
		self.act_songtired = "t"
		self.act_upcoming = "u"
		self.act_stationselectquickmix = "x"
		self.audio_format = "mp3"
		self.autostart_station = ""
		self.config_opts = ['user','password','lastfm_user','lastfm_password','lastfm_scrobble_percent',
			'control_proxy','act_help','act_songlove','act_songban', 'act_stationaddmusic',
			'act_stationcreate', 'act_stationdelete', 'act_songexplain', 'act_stationaddbygenre',
			'act_songinfo', 'act_addshared', 'act_songmove', 'act_songpause', 'act_quit', 
			'act_stationrename', 'act_stationchange', 'act_songtired', 'act_upcoming', 
			'act_stationselectquickmix', 'audio_format', 'autostart_station', 'event_command']
		self.event_command = ""
		
	def load(self):
		if os.path.exists(os.path.expanduser("~")+'/.config/pianobar/config'):
			f = open(os.path.expanduser("~")+'/.config/pianobar/config', 'r')
			for line in f:
				line = line.replace(" ", "")
				
				if re.match("^#.*",line) is not None:
					continue
			
				for opt in self.config_opts:
					if re.match("^"+opt+"=(.+)$",line) is not None:
						setattr(self,opt,self.get_var(opt,line))
			f.close()
		
	def write(self):
		newfile = ""
		if os.path.exists(os.path.expanduser("~")+'/.config/pianobar/config'):
			f = open(os.path.expanduser("~")+'/.config/pianobar/config', 'r')
			for line in f:
				line = line.replace(" ", "")
				if len(self.user)>0 and re.match("#*user=",line) is not None:
					newfile+="user="+self.user+"\n"
				elif len(self.password)>0 and re.match("#*password=",line) is not None:
					newfile+="password="+self.password+"\n"
				elif len(self.lastfm_user)>0 and re.match("#*lastfm_user=",line) is not None:
					newfile+="lastfm_user="+self.lastfm_user+"\n"
				elif len(self.lastfm_password)>0 and re.match("#*lastfm_password=",line) is not None:
					newfile+="lastfm_password="+self.lastfm_password+"\n"
				else:
					newfile+=line
			f.close()
		else:
			if not os.path.exists(os.path.expanduser("~")+'/.config/pianobar'):
				os.mkdir(os.path.expanduser("~")+'/.config/pianobar')
			for opt in self.config_opts:
				if len(getattr(self,opt))>0:
					newfile+=opt+"="+getattr(self,opt)+"\n"
				else:
					newfile+="#"+opt+"="+getattr(self,opt)+"\n"

		f = open(os.path.expanduser("~")+'/.config/pianobar/config', 'w')
		newfile = newfile.replace("=", " = ")
		f.write(newfile)
		f.close()

	def get_var(self,var,line):
		r = re.match("^"+var+"=(.+)$",line)
		return r.group(1)
		
class tPandora(QtCore.QThread):

	__pyqtSignals__ = ( "stations","newsong", "showUsername", "showPassword", "oops", "second" )

	def __init__(self, c):
		self.sTitle = ""
		self.sArtist = ""
		self.sAlbum = ""
		self.sLike = ""
		self.last = ""
		self.playing = 0
		self.drun = 1
		self.stations = [""] 
		self.length = ""
		self.error = ""
		self.crash = 0
		self.c = c
		QtCore.QThread.__init__(self)

	def run(self):
		self.pandora = Popen("pianobar",stdout=PIPE,stdin=PIPE)
		newline = ""
		listStation = 0
		while self.drun:
			char = self.pandora.stdout.read(1)
			newline += char
			if re.match(".+Username$",newline) is not None and "Error" not in newline:
				self.emit(QtCore.SIGNAL("showUsername"), self.sTitle)
				self.last = "username"
					
			if re.match(".+Password$",newline) is not None:
				self.emit(QtCore.SIGNAL("showPassword"), self.sTitle)
				self.last = "password"
			
			elif char == "\n":
				output = newline.split("|>")
				newline = ""
				for line in output:
					if line == "":
						continue
					title = re.match(".+\"(.+)\".+by.+\"(.+)\".+on.+\"(.+)\"(.*)",line)
					stations = re.match("\s+(\d+)\)\s(.+)$",line)
					merror = re.match(".*Error: (.+)$",line)
						
					if merror is not None:
						self.error = merror.group(1)
						self.emit(QtCore.SIGNAL("oops"))
						self.drun = 0
						self.pandora.stdin.close()
						self.pandora.stdout.close()

					if stations is not None:
						if int(stations.group(1)) == 0:
							self.stations = []
							self.crash = 0

						if re.match("^[Q|q]\s+(.+)",stations.group(2).lstrip()):
							station = re.match("^[Q|q]\s+(.+)",stations.group(2).lstrip()).group(1)
						else:
							station = stations.group(2).lstrip()

						if len(self.stations) > int(stations.group(1)):
							
							self.stations[int(stations.group(1))] = station
						else:
							self.stations.append(station)

						self.last = "stations"	
						self.emit(QtCore.SIGNAL("stations"), self.sTitle)
						
					
					if title is not None:
						self.close = 0
						self.sTitle = title.group(1)
						self.sArtist = title.group(2)
						self.sAlbum = title.group(3)
						if re.match(".+\<3",title.group(4)):
							self.sLike = 1
						else:
							self.sLike = 0
						
						self.last = "song"
						self.emit(QtCore.SIGNAL("newsong"), self.sTitle)
		
			elif re.match("^.+(\d+\:\d+)\/(\d+\:\d\d)$",newline):
				stime = re.match("^.+(\d+\:\d+)\/(\d+\:\d\d)$",newline)
				self.length = stime.group(1)+"/"+stime.group(2)
				self.emit(QtCore.SIGNAL("second"))
				newline = ""
			else:
				continue
			

class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		QtGui.QWidget.__init__(self, parent)
		self.station = 0;
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)
		self.c = Config()
		self.c.load()
		self.p = tPandora(self.c)
		self.p.start()
		
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('newsong'), self.newsong)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('stations'), self.stations)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('oops'), self.doError)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('showUsername'), self.showUsername)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('showPassword'), self.showPassword)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('second'), self.uSecond)
		QtCore.QObject.connect(self.ui.btnLove, QtCore.SIGNAL('clicked()'), self.doLove)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('clicked()'), self.doHate)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('clicked()'), self.doNext)
		QtCore.QObject.connect(self.ui.btnPlay, QtCore.SIGNAL('clicked()'), self.doPlayPause)
		QtCore.QObject.connect(self.ui.btnSleep, QtCore.SIGNAL('clicked()'), self.sQuit)
		QtCore.QObject.connect(self.ui.actionUser_Pass, QtCore.SIGNAL('triggered()'), self.setUserPass)
		QtCore.QObject.connect(self.ui.actionLastfm_User_Pass, QtCore.SIGNAL('triggered()'), self.setLastfm)
		QtCore.QObject.connect(self.ui.actionDelete, QtCore.SIGNAL('triggered()'), self.deleteStation)
		QtCore.QObject.connect(self.ui.actionCreate, QtCore.SIGNAL('triggered()'), self.createStation)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('pressed()'), self.nextActive)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('released()'), self.nextInactive)
		QtCore.QObject.connect(self.ui.listStations, QtCore.SIGNAL('itemDoubleClicked(QListWidgetItem *)'), self.setStation)
		QtCore.QObject.connect(self.ui.centralwidget, QtCore.SIGNAL('destroyed()'), self.sQuit)

	def setUserPass(self):
		self.showUsername()
		self.showPassword()

	def createStation(self):
		station, ok = QtGui.QInputDialog.getText(self,"Artist or Track Name", "Enter an Artist or Track Name:")
		if len(station)>0:
			if self.p.last == "stations":
				self.p.pandora.stdin.write("\n")
			elif self.p.last == "song":
				self.p.pandora.stdin.write(self.c.act_stationchange)
				self.p.pandora.stdin.write("\n")

			self.p.pandora.stdin.write(self.c.act_stationcreate)
			self.p.pandora.stdin.write(station+"\n")
			what = QtGui.QMessageBox.question(self, 'Artist or Track?', 'Is this an artist or track name?','Artist','Track')
			if what == 0:
				self.p.pandora.stdin.write("a")
			else:
				self.p.pandora.stdin.write("t")

			ok = QtGui.QMessageBox.warning(self,'Select Match','Double click the closest title from the station list.')
			self.p.last = 'create'

	def deleteStation(self):
		reply = QtGui.QMessageBox.question(self, 'Delete Station',
			"Really delete "+self.ui.listStations.currentItem().text()+"?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		if reply == QtGui.QMessageBox.Yes:
			if self.p.last == "stations":
				self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")
				self.p.pandora.stdin.write(self.c.act_stationdelete)
				self.p.pandora.stdin.write("y\n")
				self.p.pandora.stdin.write(self.c.act_stationchange)
			elif self.p.last == "song":
				self.p.pandora.stdin.write(self.c.act_stationchange)
				self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")
				self.p.pandora.stdin.write(self.c.act_stationdelete)
				self.p.pandora.stdin.write("y\n")
				self.p.pandora.stdin.write(self.c.act_stationchange)
	
	def stations(self):
		self.ui.listStations.clear()
		for station in self.p.stations:
			self.ui.listStations.addItem(station)
			self.ui.listStations.setCurrentRow(self.station)

	def setStation(self, listaItem):
		if self.p.last == 'create':
			self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")
			self.p.pandora.stdin.write(self.c.act_stationchange)
			QtGui.QMessageBox.warning(self, 'Station Created', 'Your station has been created.')
		else:
			if self.p.last == "song":
				self.p.pandora.stdin.write(self.c.act_stationchange)
		
			self.station = self.ui.listStations.currentRow()
			self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")
			self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/playing.png);")

	def uSecond(self):
		self.ui.lblTime.setText(self.p.length)

	def nextActive(self):
		self.ui.btnNext.setStyleSheet("background-image: url(:/img/img/skip-active.png);")

	def nextInactive(self):
		self.ui.btnNext.setStyleSheet("background-image: url(:/img/img/skip.png);")

	def newsong(self):
		self.ui.lblSong.setText(self.p.sTitle)
		self.ui.lblArtist.setText("by: " + self.p.sArtist)
		self.ui.lblAlbum.setText("on: " + self.p.sAlbum)
		if self.p.sLike:
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/plus-active.png);")
		else:
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/plus.png);")
		if not self.p.playing:
			self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/playing.png);")
			self.p.playing = 1
		
	def doLove(self):
		if self.p.last == "song":
	 		self.p.pandora.stdin.write(self.c.act_songlove)
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/plus-active.png);")
		
	def doHate(self):
		if self.p.last == "song":
			self.p.pandora.stdin.write(self.c.act_songban)

	def doNext(self):
		if self.p.last == "song":
			self.p.pandora.stdin.write(self.c.act_songnext)

	def doPlayPause(self):
		if self.p.last == "stations":
			self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")
		else:
			self.p.pandora.stdin.write(self.c.act_songpause)

		if self.p.playing:
			self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/paused.png);")
			self.p.playing = 0
		else:
			self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/playing.png);")
			self.p.playing = 1
	
	def sQuit(self):
		self.p.drun = 0
		self.p.pandora.stdin.write('\n'+self.c.act_quit)
		self.p.pandora.wait()
		self.p.exit()
		self.doQuit()
	
	def doError(self):
		if self.p.crash < 2:
			ok = QtGui.QMessageBox.warning( self, "Pianobar Error", "Pianobar experienced an error.\nPianobar Output:\n" + self.p.error + "\nRestarting Pianobar.", QtGui.QMessageBox.Ok )
			self.p.crash += 1
			self.p.drun = 1
			self.p.start()
		else:
			ok = QtGui.QMessageBox.warning( self, "Pianobar Error", "Pianobar crashed 3 times in a row.\nPianobar Output:\n" + self.p.error + "\nQuitting now..", QtGui.QMessageBox.Ok )
			self.p.drun = 0
			self.p.pandora.wait()
			self.p.exit()
			self.doQuit()
			
		
	def doQuit(self):
		quit()
	
	def setLastfm(self):
		username,ok = QtGui.QInputDialog.getText(self,"Username", "Last.fm Username:")
		if ok:
			self.c.lastfm_user = username
		password,ok =  QtGui.QInputDialog.getText(self,"Password", "Last.fm Password:",QLineEdit.Password)
		if ok:
			self.c.lastfm_password = password
			self.c.write()

	def showUsername(self):
		username,ok = QtGui.QInputDialog.getText(self,"Username", "Pandora Username:")
		if ok:
			self.c.user = username
			self.p.pandora.stdin.write(self.c.user+"\n")
		else:
			self.p.drun = 0
			self.p.exit()
			self.doQuit()
	
	def showPassword(self):
		password,ok = QtGui.QInputDialog.getText(self,"Password", "Pandora Password:",QLineEdit.Password)
		if ok:
			self.c.password = password
			self.p.pandora.stdin.write(self.c.password+"\n")
			self.c.write()
		else:
			self.p.drun = 0
			self.p.exit()
			self.doQuit()

if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())
