#ifndef SMILY_H
#define SMILY_H

#include <QPoint>
#include <QColor>
#include <QObject>
#include <QImage>
#include <QTimer>
#include <QDataStream>
#include "animable.h"

static const int SMILY_SIZE = 60; //pixel

class QPainter;

class BoardPos
{

public:

    BoardPos( int aRow = -1 , int aColumn = -1 )
    {
        setPos( aRow, aColumn );
    }

    void setPos( int aRow, int aColumn )
    {
        mRow = aRow;
        mColumn = aColumn;
    }

    void setRow( int aRow )
    {
        mRow = aRow;
    }

    void setColumn( int aColumn )
    {
        mColumn = aColumn;
    }

    int column() const
    {
        return mColumn;
    }

    int row() const
    {
        return mRow;
    }

private:

    int mRow;
    int mColumn;
};

class Smily: public Animable
{

public:

    Smily( int aColor, BoardPos aBoardPos );

    void fall();

    void slide ( int aDirection );

    void draw(  QPainter& aPainter);

    BoardPos boardPos()
    {
        return mBoardPos;
    }

    int color()
    {
        return mColor;
    }

    void updatePixelPos()
    {
        mPos = QPoint( mBoardPos.column() * SMILY_SIZE, mBoardPos.row() * SMILY_SIZE );
    }

    void setSize( int aSize) { mSize = aSize; }

    int size() { return mSize; }

    bool animate();

public:

    static void loadImages();

    static void unloadImages();

private :

    QPoint pos()
    {
        return mPos;
    }

private:

    BoardPos mBoardPos;
    QPoint mPos;
    int mColor;
    int mSize;
    static QMap<int,QImage*> mMap;
    QImage* mImage;

    friend class Pair;
};


//board()

//smilypair()

#endif // SMILY_H
