#ifndef GMAEWINDOW_H
#define GAMEWINDOW_H

#include <QWidget>
#include "smily.h"

class Pair;
class Board;
class MotionSenser;
class QTimer;
class GameThread;

class GameWindow : public QWidget
{
Q_OBJECT

public:

    explicit GameWindow(QWidget *parent = 0);

    ~GameWindow();

public slots:

    void paintEvent(QPaintEvent* aPaintEvent );

    void keyPressEvent( QKeyEvent* aKeyEvent );

    void mousePressEvent( QMouseEvent* aMouseEvent );

    void newGame();

    void resumeGame();

    void stopGame();

    void render();

    QSize sizeHint() const;

    void slotGameEnded();

signals:

    void pauseGame();

    void gameEnded();

    void pointsEarned(int aPoints);

private:

    enum GameState
    {
        GameNotStated = 0,
        GameStarted,
        GamePaused,
        GameEnded
    };

    GameThread* mThread;
    QTimer* mRenderTimer;
    Pair* mPair;
    Board* mBoard;
    MotionSenser *mSenser;    
    GameState mGameState;

};

#endif // WINDOW_H
