#ifndef BOARD_H
#define BOARD_H

#include <QSize>
#include <QList>
#include <QMap>
#include <QPoint>
#include <QHash>

#include "smily.h"

class QPainter;
class Animation;

class Board : public QObject
{
    Q_OBJECT

public:

    Board( QSize aSizeOfBoard , QObject* aParent = 0 );

    ~Board();
    
    void append( Smily* aSmily );

    void checkForMatch();

    void draw(  QPainter& aPainter);

    bool isColliding( Smily& aSmily );

    bool canSlide( Smily& aSmily, int aDirection );

    void drawCellNo() { mDrawCellNo = !mDrawCellNo; }

    int boradIndexToArrayIndex( int aRow, int aColumn )
    {
        //x + y * width
        return ( aColumn + ( aRow * mBoardSize.width() ) );
    }

    BoardPos arrayIndexToBoardIndex( int aArrayIndex )
    {
        int row = aArrayIndex / mBoardSize.width();
        int column = aArrayIndex % mBoardSize.width();
        return BoardPos(row, column);  // x is row, y is column
    }

    QSize size() { return mBoardSize; }


    bool isTouchingTop();

private:

    void collepseIfRequired();

    bool checkForMatchingRow( int aIndexToCheck );

    bool checkForMatchingColumn( int aIndexToCheck );

    bool checkForMatchingBlock( int aIndexToCheck );

    void startAnimation( const QList<Animable*>& aList );

    Smily* smilyFromBoardPos( int aRow, int aColumn )
    {
        int boardIndex = boradIndexToArrayIndex(aRow, aColumn );
        return mSmilys.value(boardIndex,0);
    }


private slots:

    void animationComplete( Animation *aAnimation );

signals:

    void pointsEarned(int aPoints);

private:

    int mCellCount;
    QSize mBoardSize;    
    QMap<int,Smily*> mSmilys;
    QList<Smily*> mDrawList;
    bool mDrawCellNo;
    QList<Animation*> mAnimationList;    
};

#endif // BOARD_H
