#ifndef PAIR_H
#define PAIR_H

#include "smily.h"
#include <QMutex>

class Board;

class Pair
{
public:

    Pair();

    ~Pair();

    void createPair( int aColumn );

    void draw( QPainter& aPainter );

    void fall();

    void slide(Board& aBoard, int aDirection);

    int count();

    Smily* operator[]( int aIndex );

    Smily* remove( int aIndex );

    QList<Smily*> removeIfCollidingWith( Board& aBoard );

    void rotate(Board& aBoard );

    bool isValid();

private:

   void append( Smily* aSmily );

   bool isVerticale();

   bool canSlide(Board& aBoard, int aDirection );

   void rotate( Board& aBoard, Smily* aSmily,int aColMove,int aRowMove );

private:

    QList<Smily*> mList;
    QMutex mMutex;
};

#endif // PAIR_H
