#include "motionsenser.h"

#include <QTimerEvent>
#include <QFile>
#include <QCoreApplication>
#include <QKeyEvent>
#include <QRegExp>
#include <QDebug>

static const QString PROC_ENTRY = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

MotionSenser::MotionSenser(QObject *parent)
    : QObject(parent),mParent(0)
{
    mLastPos = mCurrentPos = QPointF(0,0);
    this->startTimer(100);
}


void MotionSenser::setObserver( QObject* aObserver )
{
    mParent = aObserver;
}

void MotionSenser::timerEvent(QTimerEvent* /*aEvent*/)
{
    if( !mParent ) {
        return;
    }

    readCurrentPos();

    if( qAbs( mLastPos.y() - mCurrentPos.y() ) > 100 ) {
        if( mCurrentPos.y() > 200 ) {
            qDebug() << "####### Posting right event";
            QCoreApplication::postEvent(mParent,new QKeyEvent(QEvent::KeyPress,Qt::Key_Right,Qt::NoModifier));
        }
        else if ( mCurrentPos.y() < -200 ) {
            qDebug() << "####### Posting left event";
            QCoreApplication::postEvent(mParent,new QKeyEvent(QEvent::KeyPress,Qt::Key_Left,Qt::NoModifier));
        }
    } else if ( qAbs( mLastPos.x() - mCurrentPos.x() ) > 80 ) {
        if( mCurrentPos.x() < -650 ) {
            qDebug() << "####### Posting up event";
            QCoreApplication::postEvent(mParent,new QKeyEvent(QEvent::KeyPress,Qt::Key_Up,Qt::NoModifier));
        }        
    }



    mLastPos = mCurrentPos;
}

void MotionSenser::readCurrentPos()
{
    QFile f(PROC_ENTRY);
    if (!f.exists() or !f.open(QIODevice::ReadOnly | QIODevice::Text)) {
        //pos->pitch = (rand() % 100)-30;
        //pos->roll = (rand() % 100)-30;
        //generate some random number for emulator
        //qDebug() << "could not read motion data";
    }
    else {
        QByteArray line = f.readLine();
        QRegExp rx("([0-9-]+) ([0-9-]+) ([0-9-]+)");

        rx.indexIn(line);
        qreal x = rx.cap(1).toInt();
        qreal y = rx.cap(2).toInt();
        qreal z = rx.cap(3).toInt();

        mCurrentPos.setX(x);
        mCurrentPos.setY(y);

        //qDebug() << "Old pos:" << mLastPos;
        //qDebug() << "Cur pos" << mCurrentPos;
        qDebug() << "x,y,z" << x << ","<< y <<"," << z;

        //-700,500,-450
        //-600,-500,-500

        //qreal pitch = atan2((qreal) x, (qreal) -y);
        //qreal roll = atan2((qreal) y, (qreal) -z);


        //pos->pitch = (pitch * 180/M_PI)*-1;
        //pos->roll = (roll * 180/M_PI) + 90;
        f.close();
    }
}
