#ifndef GAMETHREAD_H_
#define GAMETHREAD_H_

#include <QThread>

class Board;
class Pair;
class QTimer;

class GameThread : public QThread
{
    Q_OBJECT

public:

    GameThread( Board* aBoard, Pair* aPair, QObject* aParent = 0 );

    void startGame();

    void pauseGame();

private:

    void run();

    void createPair();

    bool checkForCollision();

    bool checkCollisionWithBoard();

private slots:

    void timeout();

signals:

    void gameEnded();

private:

    Board* mBoard;
    Pair* mPair;
    QTimer* mTimer;
};

#endif //GAMETHREAD_H_
