#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/*
  PushIt - A simple Sokoban solving game
  Copyright (C) 2006  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <string>
#include <vector>

#include <Lum/Images/Image.h>

#include "Sokoban.h"

//
// Levels
//

class Level
{
private:
  std::wstring title;

public:
  Sokoban sokoban;

public:
  void SetTitle(const std::wstring& title);

  std::wstring GetTitle() const;
};

//
// Collections
//

class Collection
{
private:
  std::wstring       title;
  std::wstring       description;
  std::wstring       email;
  std::wstring       url;
  std::wstring       copyright;
  std::vector<Level> levels;
  size_t             current;

  static std::vector<Collection*> collections;

public:
  Collection();

  void SetTitle(const std::wstring& title);
  void SetDescription(const std::wstring& description);
  void SetEmail(const std::wstring& email);
  void SetUrl(const std::wstring& url);
  void SetCopyright(const std::wstring& copyright);
  void SetCurrent(size_t current);

  std::wstring GetTitle() const;
  size_t GetCurrent() const;

  void AddLevel(const Level& level);

  size_t GetLevelCount() const;
  Level GetLevel(const size_t pos) const;
  Level& GetLevel(const size_t pos);
  bool IsFinished() const;

  static void AddCollection(Collection* collection);
  static size_t GetCollectionCount();
  static Collection* GetCollection(size_t pos);

  static void Free();
};

//
// Themes
//

enum Image {
  floorImage      = 0,
  goalImage       = 1,
  packageImage    = 2,
  sokobanImage    = 3,
  wallImage       = 4,
  leftImage       = 5,
  upImage         = 6,
  rightImage      = 7,
  downImage       = 8,

  countImage      = 9
};

class Theme
{
public:
  std::wstring          name;
  Lum::Images::ImageRef images[countImage];
  size_t                boxSize;
};

extern std::vector<Theme> themes;
extern std::wstring       themeName;
extern Collection         *collection;

/*
extern void SetUserName(const std::wstring& name);
extern std::wstring GetUserName();
*/
extern bool LoadConfig();
extern bool LoadLevels();
extern bool LoadThemes();
extern void ChooseTheme();
extern void ChooseCollection();

extern bool SaveConfig();
extern void FreeConfig();

#endif
