#include "options.h"
#include "ui_options.h"
QStringList current_config=QStringList();
QString current_core="";
options::options(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::options)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    connect (ui->checkBox_2,SIGNAL(clicked()),this,SLOT(psx4m_hwa_block()));


        QDir dir( bios_path);
                 dir.setFilter(QDir::Files);
                 dir.setSorting(QDir::Name);
        dir.setNameFilters(QStringList()<<"*.bin");

                 QFileInfoList list = dir.entryInfoList();
                 for (int i = 0; i < list.size(); ++i) {
                     QFileInfo fileInfo = list.at(i);
                     ui->comboBox_4->addItem(fileInfo.fileName());
                 }

                 load_cfg();

}

options::~options()
{
    delete ui;
}
void options::hideEvent(QHideEvent *){
    if (!this->isVisible()){
        QDialog *dlg=new QDialog(this);
        dlg->setWindowTitle(tr("Confirm"));
        QGridLayout *lay=new QGridLayout(dlg);
        QLabel *lbl=new QLabel(tr("Do you want to save settings?"),dlg);
        lay->addWidget(lbl,1,0,1,2);
        QPushButton *yes=new QPushButton(tr("Yes"),dlg);
        QPushButton *no=new QPushButton(tr("No"),dlg);
        connect (yes,SIGNAL(clicked()),dlg,SLOT(accept()));
        connect (no,SIGNAL(clicked()),dlg,SLOT(reject()));
        connect (dlg,SIGNAL(accepted()),this,SLOT(save_cfg()));
        lay->addWidget(yes,2,0);
        lay->addWidget(no ,2,1);
        dlg->exec();
    }
}

void options::load_cfg(){
    QString path="";
    if (game!="")
        path=cfg_path+game;
    else
       path=cfg_path+"default";

    QStringList configs=QStringList()<<"core"<<"sound"<<"bios";
    configs<<"psx4m-cycle"<<"psx4m-frame"<<"psx4m-hwa"<<"psx4m-fps"<<"psx4m-fullscreen"<<"psx4m-afix";
    configs<<"pcsx-threadedspu"<<"pcsx-hwa"<<"pcsx-bios"<<"pcsx-frameskip";
    configs<<"accel";
    configs<<"cdda" <<    "xa" <<    "rcnt"<<    "sio"<<    "spuirq"<<    "vsync";
    configs<<"fsaa"<<"pcsx-fullscreen";
    configs<<"pcsx-fps"<<"pcsx-cpu"<<"pcsx-nofl";

    ui->comboBox_5->setCurrentIndex(0);
    ui->checkBox_4->setChecked(false);
    ui->checkBox_18->setChecked(false);
    ui->checkBox_19->setChecked(false);

    if (QFile::exists(path)){

        QFile file(path);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
            qDebug(QString("Can't open file : %1\n").arg(path).toAscii());
            return;
        }

             QTextStream in(&file);
             while (!in.atEnd()) {
                 QStringList line = QString(in.readLine()).split("=");
                 QString value=line.at(1);
                 switch (configs.indexOf(line.at(0).trimmed())){
                 case 0: // core
                     if (value=="1")ui->radioButton_2->setChecked(true); else ui->radioButton->setChecked(true);
                     break;
                 case 1: // sound
                     if (value=="1")ui->checkBox->setChecked(true);else ui->checkBox->setChecked(false);
                     break;
                 case 2: // bios
if (value=="")value="scph1001.bin";
                     if (ui->comboBox_4->findText(value)!=1)
                         ui->comboBox_4->setCurrentIndex(ui->comboBox_4->findText(value));
                         break;
                 case 3: // psx4m-cycle
                     if (ui->comboBox->findText(value)!=1)
                         ui->comboBox->setCurrentIndex(ui->comboBox->findText(value));
                     break;
                 case 4: // psx4m-frame
                     if (ui->comboBox_2->findText(value)!=1)
                         ui->comboBox_2->setCurrentIndex(ui->comboBox_2->findText(value));
                     break;
                 case 5: // psx4m-hwa
                     if (value=="1")ui->checkBox_2->setChecked(true);else ui->checkBox_2->setChecked(false);
                     break;
                 case 6: //psx4m-fps
                     if (value=="1")ui->checkBox_6->setChecked(true);else ui->checkBox_6->setChecked(false);
                     break;
                 case 7: //psx4m-fullscreen
                     if (value=="1")ui->checkBox_7->setChecked(true);else ui->checkBox_7->setChecked(false);
                     break;
                 case 8: //psx4m-afix
                     if (value=="1")ui->checkBox_8->setChecked(true);else ui->checkBox_8->setChecked(false);
                     break;
                 case 9: // pcsx-threadedspu
                      if (value=="1")ui->checkBox_3->setChecked(true);else ui->checkBox_3->setChecked(false);
                      break;
                 case 10:// pcsx-hwa
                     if (ui->comboBox_5->findText(value)!=1)
                         ui->comboBox_5->setCurrentIndex(ui->comboBox_5->findText(value));
                      break;
                 case 11:// pcsx-bios
                      if (value=="1")ui->checkBox_5->setChecked(true);else ui->checkBox_5->setChecked(false);
                      break;
                 case 12:// pcsx-frameskip
                      if (ui->comboBox_3->findText(value)!=-1)
                          ui->comboBox_3->setCurrentIndex(ui->comboBox_3->findText(value));
                      break;
                 case 13:
                      if (value=="1")ui->checkBox_9->setChecked(true);else ui->checkBox_9->setChecked(false);
                      break;
                 case 14:
                      if (value=="1")ui->checkBox_10->setChecked(true);else ui->checkBox_10->setChecked(false);
                      break;
                 case 15:
                      if (value=="1")ui->checkBox_11->setChecked(true);else ui->checkBox_11->setChecked(false);
                      break;
                 case 16:
                      if (value=="1")ui->checkBox_12->setChecked(true);else ui->checkBox_12->setChecked(false);
                      break;
                 case 17:
                      if (value=="1")ui->checkBox_13->setChecked(true);else ui->checkBox_13->setChecked(false);
                      break;
                 case 18:
                      if (value=="1")ui->checkBox_14->setChecked(true);else ui->checkBox_14->setChecked(false);
                      break;
                 case 19:
                      if (value=="1")ui->checkBox_15->setChecked(true);else ui->checkBox_15->setChecked(false);
                      break;
                 case 20:
                      if (value=="1")ui->checkBox_16->setChecked(true);else ui->checkBox_16->setChecked(false);
                      break;
                 case 21:
                      if (value=="1")ui->checkBox_17->setChecked(true);else ui->checkBox_17->setChecked(false);
                      break;
                 case 22:
                      if (value=="1")ui->checkBox_4->setChecked(true);else ui->checkBox_4->setChecked(false);
                      break;
                 case 23:
                      if (value=="1")ui->checkBox_18->setChecked(true);else ui->checkBox_18->setChecked(false);
                      break;
                 case 24:
                      if (value=="1")ui->checkBox_19->setChecked(true);else ui->checkBox_19->setChecked(false);
                      break;
                 default:
                      qDebug(QString("Undefined setting:%1 = %2").arg(line.at(0)).arg(value).toAscii());
                      break;
                 }
             }
             file.close();

             // checking
             psx4m_hwa_block();

             if (!ui->comboBox_4->currentIndex()>-1)ui->comboBox_4->setCurrentIndex(0);

             createCfg();
    }
}


void options::createCfg(){
    current_config=QStringList();
    if (ui->checkBox->isChecked())current_config<<"-nosound";
    if (ui->checkBox_9->isChecked())current_config<<"-accel";

    if (ui->checkBox_10->isChecked())current_config<<"-xa";
    if (ui->checkBox_11->isChecked())current_config<<"-cdda";
    if (ui->checkBox_12->isChecked())current_config<<"-sio";
    if (ui->checkBox_13->isChecked())current_config<<"-spuirq";
    if (ui->checkBox_14->isChecked())current_config<<"-rcnt";
    if (ui->checkBox_15->isChecked())current_config<<"-vsync";



    if (ui->radioButton_2->isChecked())
    {
        current_core="pcsx";

        if (ui->checkBox_3->isChecked())current_config<<"-sputhreaded";
        if (ui->comboBox_5->currentText()=="oldgpu")current_config<<"-oldgpu";
        else if (ui->comboBox_5->currentText()=="gpu-gles")current_config<<"-gles";
        else if (ui->comboBox_5->currentText()=="gpu_unai")current_config<<"-unai";
        else if (ui->comboBox_5->currentText()=="gpu_4all")current_config<<"-4all";

        if (ui->checkBox_5->isChecked())
            if (!ui->comboBox_4->currentText().isEmpty() && !bios_path.isEmpty())
                      current_config<<"-bios"<<ui->comboBox_4->currentText()<<"-bdir"<<bios_path;
        if (ui->comboBox_3->currentIndex()>=0)
            current_config<<"-frameskip"<<QString("%1").arg(ui->comboBox_3->currentIndex() - 1);
        if (ui->checkBox_17->isChecked())current_config<<"-fullscreen";
        if (ui->checkBox_4->isChecked())current_config<<"-fps";
        if (ui->checkBox_18->isChecked())current_config<<"-cpu";
        if (ui->checkBox_19->isChecked())current_config<<"-nofl";


        current_config<<"-cdfile";

    }
    else{
        if (ui->comboBox->currentText()!="Disabled")current_config<<"-cyclemult"<<ui->comboBox->currentText();
        current_config<<"-bios"<<ui->comboBox_4->currentText()<<"-bdir"<<bios_path;
    if (ui->checkBox_2->isChecked())
        {
        current_core="psx4m-gles";

        }
    else
    {
        current_core="psx4m";
        if (ui->comboBox_2->currentText()!="Disabled"){
            if (ui->comboBox_2->currentText()=="Auto")current_config<<"-autoskip";
            else current_config<<"-frameskip"<<ui->comboBox_2->currentText();
        }
        if (ui->checkBox_6->isChecked())current_config<<"-showfps";
        if (ui->checkBox_7->isChecked())current_config<<"-fullscreen";
        if (ui->checkBox_8->isChecked())current_config<<"-abbeyfix";



              }
    current_config<<"-runcd";
}
}

void options::save_cfg(){
    createCfg();
    QString path="";
    if (game!="")
        path=cfg_path+game;
    else
       path=cfg_path+"default";

    QString config=QString(
                   "core=%1\n" \
                   "sound=%2\n" \
                   "bios=%3\n" \
                   "psx4m-cycle=%4\n" \
                   "psx4m-frame=%5\n" \
                   "psx4m-hwa=%6\n" \
                   "psx4m-fps=%7\n" \
                   "psx4m-fullscreen=%8\n" \
                   "psx4m-afix=%9\n" \
                   "pcsx-threadedspu=%10\n" \
                   "pcsx-hwa=%11\n" \
                   "pcsx-bios=%12\n" \
                   "pcsx-frameskip=%13\n" \
                   "accel=%14\n" \
                   "cdda=%15\n" \
                   "xa=%16\n" \
                   "rcnt=%17\n" \
                   "sio=%18\n" \
                   "spuirq=%19\n" \
                   "vsync=%20\n" \
                   "fsaa=%21\n" \
                   "pcsx-fullscreen=%22\n"\
                   "pcsx-fps=%23\n" \
                "pcsx-cpu=%24\n" \
                "pcsx-nofl=%25\n")
            .arg(ui->radioButton_2->isChecked()?"1":"0")
            .arg(ui->checkBox->isChecked()?"1":"0")
            .arg(ui->comboBox_4->currentText())
            .arg(ui->comboBox->currentText())
            .arg(ui->comboBox_2->currentText())
.arg(ui->checkBox_2->isChecked()?"1":"0")
.arg(ui->checkBox_6->isChecked()?"1":"0")
.arg(ui->checkBox_7->isChecked()?"1":"0")
.arg(ui->checkBox_8->isChecked()?"1":"0")
            .arg(ui->checkBox_3->isChecked()?"1":"0")
            .arg(ui->comboBox_5->currentText())
            .arg(ui->checkBox_5->isChecked()?"1":"0")
            .arg(ui->comboBox_3->currentText())
.arg(ui->checkBox_9->isChecked()?"1":"0")
.arg(ui->checkBox_10->isChecked()?"1":"0")
.arg(ui->checkBox_11->isChecked()?"1":"0")
.arg(ui->checkBox_12->isChecked()?"1":"0")
.arg(ui->checkBox_13->isChecked()?"1":"0")
.arg(ui->checkBox_14->isChecked()?"1":"0")
.arg(ui->checkBox_15->isChecked()?"1":"0")
        .arg(ui->checkBox_16->isChecked()?"1":"0")
        .arg(ui->checkBox_17->isChecked()?"1":"0")
            .arg(ui->checkBox_4->isChecked()?"1":"0")
            .arg(ui->checkBox_18->isChecked()?"1":"0")
            .arg(ui->checkBox_19->isChecked()?"1":"0")
;

    QFile file(path);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
        qDebug(QString("Can't save %1").arg(path).toAscii());
        return;}

         QTextStream out(&file);
         out <<config;

         file.close();

}

void options::psx4m_hwa_block(){
    if (ui->checkBox_2->checkState()==Qt::Checked){
        ui->checkBox_6->setEnabled(false);
        ui->checkBox_7->setEnabled(false);
        ui->checkBox_8->setEnabled(false);
        ui->comboBox_2->setEnabled(false);
        ui->checkBox_16->setEnabled(true);
    }else{
        ui->checkBox_6->setEnabled(true);
        ui->checkBox_7->setEnabled(true);
        ui->checkBox_8->setEnabled(true);
        ui->comboBox_2->setEnabled(true);
        ui->checkBox_16->setEnabled(false);
    }
}
