#include "savestateselect.h"
#include "ui_savestateselect.h"

#include <QDir>
#include "cfg.h"

SavestateSelect::SavestateSelect(QWidget *parent, RomInfo* rom) :
    QDialog(parent),
    ui(new Ui::SavestateSelect)
{
    ui->setupUi(this);

    ui->listWidget->setIconSize(QSize(160, 112));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(ui->pbnDelete, SIGNAL(clicked()), this, SLOT(DeleteSavestate()));
#ifdef Q_WS_MAEMO_5
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(SavestateSelected(QListWidgetItem*)));
#else
    connect(ui->listWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(SavestateSelected(QListWidgetItem*)));
#endif

    m_Rom = rom;
    FillList();
}

SavestateSelect::~SavestateSelect()
{
    delete ui;
}

void SavestateSelect::FillList()
{
    m_List.clear();
    ui->listWidget->clear();

    foreach (QString name, m_Rom->SaveStateNames){
        //qDebug() << "Savestate:" << name;
        QFileInfo f(name);
        QDir dir;
        dir.setPath(GetSavestatePath());
        dir.setFilter(QDir::Files);
        dir.setSorting(QDir::Name | QDir::IgnoreCase);
        dir.setNameFilters(QStringList()<< QString("%1*").arg(f.completeBaseName()));

        foreach (QFileInfo f, dir.entryInfoList()) {
            if (f.size() > 0){
                QIcon icon;
                QString screenshot = QString("%1%2.%3").arg(screenshots_path).arg(m_Rom->FileName).arg(f.suffix());
                if (QFile::exists(screenshot))
                    icon = QIcon(screenshot);
                else{
                    QPixmap p("/opt/psx4m/no_data.png");
                    icon = QIcon(p.scaled(160,112));
                }

                int slot = f.suffix().toInt();
                if (slot == 99)
                    ui->listWidget->insertItem(0, new QListWidgetItem(icon, QString("Slot %1: %2").arg("Autosave")
                                                                      .arg(f.lastModified().toString(Qt::SystemLocaleLongDate))));
                else
                    ui->listWidget->addItem(new QListWidgetItem(icon, QString("Slot %1: %2").arg(slot + 1)
                                                                .arg(f.lastModified().toString(Qt::SystemLocaleLongDate))));

                m_List.append(f.absoluteFilePath());
            }
        }
    }

    if (m_List.count() > 0){
        ui->listWidget->setCurrentRow(0);
        SavestateSelected(NULL);
    }else{
        m_Selected.clear();
    }
}

void SavestateSelect::SavestateSelected(QListWidgetItem*)
{
    m_Selected = m_List.at(ui->listWidget->currentRow());
}

int SavestateSelect::Selected()
{
    if (m_Selected.isEmpty())
        return -1;

    QFileInfo f(m_Selected);
    return f.suffix().toInt() + 1;
}

int SavestateSelect::SelectedDisc()
{
    if (m_Selected.isEmpty())
        return 0;

    if (m_Rom->IsMultiDisc()){
        QFileInfo f(m_Selected);
        QString base = f.baseName();
        qDebug() << "base" << base;
        int disc = 0;
        foreach (QString name, m_Rom->SaveStateNames){
            qDebug() << "name" << name;
            if (name.startsWith(base))
                return disc + 1;
            disc++;
        }
    }
    return 0;
}

void SavestateSelect::DeleteSavestate()
{
    if (!m_Selected.isEmpty()){
        QFileInfo f(m_Selected);
        int slot = f.suffix().toInt() + 1;

        QMessageBox msg(this);
        msg.setWindowTitle(tr("Confirm"));
        if (slot == 100)
            msg.setText(tr("Delete savestate slot %1?").arg("Autosave"));
        else
            msg.setText(tr("Delete savestate slot %1?").arg(slot));
        msg.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        if (msg.exec() == QMessageBox::Yes){
            QString screenshot = QString("%1%2.%3").arg(screenshots_path).arg(m_Rom->FileName).arg(f.suffix());
            QString savestate  = m_Selected;
            qDebug() << "Deleting:" << savestate;
            QFile::remove(savestate);
            qDebug() << "Deleting:" << screenshot;
            QFile::remove(screenshot);

            FillList();
            if (m_List.count() == 0)
                reject();
        }
    }
}

QString SavestateSelect::GetSavestatePath()
{
    if (current_core == "pcsx")
        return sstate_path;
    return rom_path;
}
