#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include "options.h"
#include "keys.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QSettings *settings;

public slots:
    void rom_config();
    void rom_exec();

    void def_cfg();
    void gui_cfg();
    void open_help();
    void set_keys();

    void currentRowChanged ( int );
	void set_rom_dir();
	void set_bios_dir();
    void process_finished(int);
    void memory_cards();

private:
    void get_roms();

    Ui::MainWindow *ui;
    QStringList roms;
    options *cfg;
    keys *keyopt;
    QLabel* lbl1;
    QLabel* lbl2;
    QProcess* myProcess;
};

#endif // MAINWINDOW_H
