#include "accelerometerconfig.h"
#include "ui_accelerometerconfig.h"

#include <QPainter>
#include <QFile>
#include <QDebug>

AccelerometerConfig::AccelerometerConfig(QWidget *parent,int sens, int ydef, int maxValue) :
    QMainWindow(parent),
    ui(new Ui::AccelerometerConfig)
{
    ui->setupUi(this);

#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    ui->numSens->setValue(sens);
    ui->numYDef->setValue(ydef);
    ui->numMaxValue->setValue(maxValue);

    m_Loop = NULL;
    m_Pen = QPen(Qt::DashDotLine);
    m_Pen.setColor(Qt::white);
    m_Brush = QBrush(Qt::white,Qt::SolidPattern);
}

AccelerometerConfig::~AccelerometerConfig()
{
    delete ui;

    if (m_Loop)
        delete m_Loop;
}

void AccelerometerConfig::paintEvent(QPaintEvent*)
{
    int radius = 30;
    int x = 0;
    int y = 0;

    QFile f("/sys/class/i2c-adapter/i2c-3/3-001d/coord");
    if (!f.open(QIODevice::ReadOnly))
        qDebug() << "Failed to open accel";
    else{
        QString accel = f.readAll();
        QStringList elem = accel.split(" ", QString::SkipEmptyParts);
        if (elem.count() > 2){
            x = elem.at(0).toInt();
            y = elem.at(1).toInt();

            qDebug() << "X:" << x << "Y:" << y;
            if (x > ui->numMaxValue->value()) x = ui->numMaxValue->value();
            else if (x < -ui->numMaxValue->value()) x = -ui->numMaxValue->value();

            y += ui->numYDef->value();
            if (y > ui->numMaxValue->value()) y = ui->numMaxValue->value();
            else if (y < -ui->numMaxValue->value()) y = -ui->numMaxValue->value();
        }
        f.close();
    }

    m_Pixmap.fill(Qt::black);

    QPainter painter(&m_Pixmap);
    painter.setPen(m_Pen);
    painter.setBrush(m_Brush);

    int centerX = m_Pixmap.width() / 2;
    int centerY = m_Pixmap.height() / 2;
    painter.drawLine(0, centerY, m_Pixmap.width(), centerY);
    painter.drawLine(centerX, 0, centerX, m_Pixmap.height());

    int padX = 127;
    int padY = 127;

    int maxValue = ui->numMaxValue->value() - ui->numSens->value();
    if (x > ui->numSens->value()){
        x -= ui->numSens->value();
        centerX = (-x + maxValue ) * (m_Pixmap.width() / (maxValue * 2.0));
        padX = (-x + maxValue ) * (255 / (maxValue * 2.0));
    }else if (x < -ui->numSens->value()){
        x += ui->numSens->value();
        centerX = (-x + maxValue ) * (m_Pixmap.width() / (maxValue * 2.0));
        padX = (-x + maxValue ) * (255 / (maxValue * 2.0));
    }

    if (y > ui->numSens->value()){
        y -= ui->numSens->value();
        centerY = (-y + maxValue ) * (m_Pixmap.height() / (maxValue * 2.0));
        padY = (-y + maxValue ) * (255 / (maxValue * 2.0));
    }else if (y < -ui->numSens->value()){
        y += ui->numSens->value();
        centerY = (-y + maxValue ) * (m_Pixmap.height() / (maxValue * 2.0));
        padY = (-y + maxValue ) * (255 / (maxValue * 2.0));
    }

    painter.drawEllipse(centerX - radius / 2, centerY - radius / 2, radius, radius);

    ui->lblPad->setText(QString("X: %1\nY: %2").arg(padX).arg(padY));
    ui->lblRender->setPixmap(m_Pixmap);
}

void AccelerometerConfig::hideEvent(QHideEvent *){
    if (!isVisible())
        m_Loop->quit();
}
void AccelerometerConfig::show()
{
    QWidget::show();

    m_Pixmap = QPixmap(ui->lblRender->width(), ui->lblRender->height());

    ui->lblRender->setPixmap(m_Pixmap);
    m_Loop = new QEventLoop(this);
    m_Loop->exec();
}

int AccelerometerConfig::GetSens()
{
    return ui->numSens->value();
}

int AccelerometerConfig::GetYDef()
{
    return ui->numYDef->value();
}

int AccelerometerConfig::GetMaxValue()
{
    return ui->numMaxValue->value();
}
