#include "sdl.h"
#include <assert.h>

#define sdlscreen gp2x_sdlwrapper_screen

void	*gp2x_sdlwrapper_screen_pixels=NULL;
SDL_Surface *gp2x_sdlwrapper_screen=NULL;
SDL_Surface *screen_real;

#define REAL_X 800
#define REAL_Y 480
#define BUFFER_X 480
#define BUFFER_Y 240

int gp2x_sdlwrapper_bpp=16;
unsigned short* gp2xscreen = NULL;

extern "C" {
unsigned long gp2x_keys[256];
/** This arrays contains generic info about each of the mappable buttons the
	GUI shows */
typedef struct ButtonEntry {
	const char * gconf_key;
	unsigned long key;
} ButtonEntry;

ButtonEntry buttons[] = {
#define HELP(...)
#define P(x) MAEMOKEY_##x
#define BUTTON(description, slug, actions, d, f) \
	{ G_STRINGIFY(slug), actions },
#define LAST \
	{ NULL, 0 }
#include "buttons.inc"
#undef HELP
#undef P
#undef BUTTON
#undef LAST
};
}

void (*gp2x_printfchar)(gp2x_font *f, unsigned char c);
#include "font.h"

void gp2x_printfchar15(gp2x_font *f, unsigned char c)
{
  unsigned short *dst=&((unsigned short*)sdlscreen->pixels)[f->x+f->y*(sdlscreen->pitch>>1)],w,h=f->h;
//unsigned char  *src=f->data[ (c%16)*f->w + (c/16)*f->h ];
  unsigned char  *src=&f->data[c*10];

 if(f->solid)
         while(h--)
         {
          w=f->wmask;
          while(w)
          {
           if( *src & w ) *dst++=f->fg; else *dst++=f->bg;
           w>>=1;
          }
          src++;

          dst+=(sdlscreen->pitch>>1)-(f->w);
         }
 else
         while(h--)
         {
          w=f->wmask;
          while(w)
          {
           if( *src & w ) *dst=f->fg;
           dst++;
           w>>=1;
          }
          src++;

          dst+=(sdlscreen->pitch>>1)-(f->w);
         }
}

void gp2x_printf(gp2x_font *f, int x, int y, const char *format, ...)
{
 char buffer[4096]; int c; gp2x_font *g=&gp2x_default_font;
 va_list  args;

 va_start(args, format);
 vsprintf(buffer, format, args);
 va_end(args);
 //printf("%s\n", buffer);

 if(f!=NULL) g=f;

 if(x<0) x=g->x; else g->x=x;
 if(y<0) y=g->y; else g->y=y;

 for(c=0;buffer[c];c++)
 {
  switch(buffer[c])
  {
   case '\b': g->x=x;g->y=y; break;

   case '\n': g->y+=g->h;
   case '\r': g->x=x;
              break;

   default:   gp2x_printfchar(g, (unsigned char)buffer[c]);
              g->x+=g->w;
              break;
  }
 }

 //gp2x_video_flip_single();
}

void gp2x_printf_init(gp2x_font *f, int w, int h, void *data, int fg, int bg, int solid)
{
 gp2x_printfchar=gp2x_printfchar15;
 f->x=f->y=0;
 f->wmask=1<<(w-1);
 f->w=w;
 f->h=h;
 f->data=(unsigned char *)data;
 f->fg=fg;
 f->bg=bg;
 f->solid=solid;
}

void gp2x_deinit(void)
{
	//SDL_Quit();  // hangs!!!??

#ifdef DEBUG
	fclose(fdbg);
#endif
}

void gp2x_init(int ticks_per_second, int bpp, int rate, int bits, int stereo, int hz, int solid_font)
{
	int res;

#ifdef DEBUG
	fdbg = fopen("debug.txt", "a+");
	fprintf(fdbg, "\n\n");
#endif

	res = SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK | SDL_INIT_NOPARACHUTE);
	assert(res == 0);
#ifdef RENDER_DOUBLE
	screen_real = SDL_SetVideoMode(REAL_X, REAL_Y, bpp, SDL_DOUBLEBUF | SDL_FULLSCREEN);
	assert(screen_real);
	gp2x_sdlwrapper_screen = SDL_CreateRGBSurface(
					0, BUFFER_X, BUFFER_Y, bpp,
					screen_real->format->Rmask,
					screen_real->format->Gmask,
					screen_real->format->Bmask,
					screen_real->format->Amask);

	if(SDL_MUSTLOCK(screen_real)) SDL_LockSurface(screen_real);
#else
	gp2x_sdlwrapper_screen = SDL_SetVideoMode(REAL_X, REAL_Y, bpp, SDL_DOUBLEBUF | SDL_FULLSCREEN);
#endif

	if(gp2x_sdlwrapper_screen == NULL)
	{
		exit(0);
		return;
	}
	gp2x_sdlwrapper_bpp=bpp;
	gp2x_sdlwrapper_screen_pixels=gp2x_sdlwrapper_screen->pixels;

	if(SDL_MUSTLOCK(sdlscreen)) SDL_LockSurface(sdlscreen);

	SDL_WM_SetCaption(APP_NAME, "psx4all");

	SDL_SysWMinfo      info;
	SDL_VERSION(&info.version);
	if (SDL_GetWMInfo(&info) == 1) {
		if (info.subsystem == SDL_SYSWM_X11) {

			int one = 1;
			Display *display = info.info.x11.gfxdisplay;
			Window window  = info.info.x11.wmwindow;
			
			XChangeProperty(display, window, XInternAtom (display, "_HILDON_NON_COMPOSITED_WINDOW", False), 
					XA_INTEGER, 32, PropModeReplace, (unsigned char*)&one, 1);

			Atom actions, no_trans;
			actions = XInternAtom (display, "_NET_WM_ALLOWED_ACTIONS", False);
			no_trans = XInternAtom (display, "_HILDON_WM_ACTION_NO_TRANSITIONS", False);
			XChangeProperty (display, window, actions,
					 XA_ATOM, 32, PropModeReplace,
					 (unsigned char *)&no_trans, 1);

		}
	}

	Display *dpy = info.info.x11.display;
	Window win;
	if (dpy){
		win = info.info.x11.fswindow;
		if (win) XStoreName(dpy, win, APP_NAME);
		win = info.info.x11.wmwindow;
		if (win) XStoreName(dpy, win, APP_NAME);
	}

	//SDL_EnableUNICODE(1);
	//SDL_WM_GrabInput(SDL_GRAB_ON);
	SDL_EventState(SDL_ACTIVEEVENT,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEMOTION,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEBUTTONDOWN,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEBUTTONUP,SDL_IGNORE);
	SDL_EventState(SDL_SYSWMEVENT,SDL_IGNORE);
	SDL_EventState(SDL_VIDEORESIZE,SDL_IGNORE);
	SDL_EventState(SDL_USEREVENT,SDL_IGNORE);
	SDL_ShowCursor(SDL_DISABLE);

	//init font
	gp2x_printf_init(&gp2x_default_font,6,10,gp2x_fontf,0xFFFF,0x0000,solid_font);

	atexit(gp2x_deinit);
}

static void keyprocess(Uint32 *st, unsigned long key, SDL_bool pressed)
{
	Uint32 val = gp2x_keys[key & 0xff];

	if (pressed)
		(*st) |= val;
	else
		(*st) &= ~val;
	//printf("%d->%x\n", key, val);
}

unsigned long gp2x_joystick_read(void)
{
	static Uint32 st=0;
	SDL_Event event;

	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
			case SDL_QUIT:
				gp2x_deinit();
				exit(0);
				break;
			case SDL_KEYDOWN:
				keyprocess(&st,event.key.keysym.scancode,SDL_TRUE);
				//keyprocess(&st,event.key.keysym.unicode,SDL_TRUE);
				//keyprocess(&st,event.key.keysym.sym,SDL_TRUE);
				break;
			case SDL_KEYUP:
				keyprocess(&st,event.key.keysym.scancode,SDL_FALSE);
				//keyprocess(&st,event.key.keysym.unicode,SDL_FALSE);
				//keyprocess(&st,event.key.keysym.sym,SDL_FALSE);
				break;
		}

		if(st & MAEMOKEY_QUIT)
		{
			gp2x_deinit();
			exit(0);
		}
	}

	return st;
}

void gp2x_video_RGB_clearscreen16(void)
{
  memset(sdlscreen->pixels, 0, sdlscreen->pitch*sdlscreen->h);
}

u64 gp2x_timer_read(void)
{
  struct timeval current_time;
  gettimeofday(&current_time, NULL);

  return (((u64)current_time.tv_sec * 1000000ll + current_time.tv_usec) / 1000);
}

void gp2x_video_flip()
{
	static int x = 0;
	x++;
	if((x&0x1)) return;
	
#ifdef RENDER_DOUBLE
	int i, j;

	for(i=0; i<BUFFER_Y; i++)
	{
		for(j=0; j<320; j++)
		{
			((Uint16*)screen_real->pixels)[80 + REAL_X*i*2 + 2*j] =
			((Uint16*)screen_real->pixels)[80 + REAL_X*i*2 + 2*j + 1] =
			((Uint16*)screen_real->pixels)[80 + REAL_X*(i*2+1) + 2*j] =
			((Uint16*)screen_real->pixels)[80 + REAL_X*(i*2+1) + 2*j + 1] =

//			((Uint16*)screen_real->pixels)[240 + REAL_X*(i+120) + j] = 
			((Uint16*)sdlscreen->pixels)[BUFFER_X*i + j];
		}
	}

	if(SDL_MUSTLOCK(sdlscreen)) SDL_UnlockSurface(sdlscreen);
	if(SDL_MUSTLOCK(screen_real)) SDL_UnlockSurface(screen_real);


	SDL_Flip(screen_real);

	if(SDL_MUSTLOCK(screen_real)) SDL_LockSurface(screen_real);
#else
	if(SDL_MUSTLOCK(sdlscreen)) SDL_UnlockSurface(sdlscreen);

	SDL_Flip(sdlscreen);
#endif

	if(SDL_MUSTLOCK(sdlscreen)) SDL_LockSurface(sdlscreen);
}

