#include "gui.h"

#include <string.h>
#include <unistd.h>
#include "psxTypes.h"

#define _

extern s8* newpackfile;

static struct _gui_data
{
	HildonProgram *program;
	GtkWidget *window;

	GConfClient * gcc;

	HildonAppMenu *menu;

	GtkWidget* grid;

	HildonButton* select_rom_btn;
	HildonButton* run_btn;
	GtkCheckButton* sound_check;
	GtkCheckButton* display_fps_check;
} gui_data;

int destroy = 0;


void gui_init(int *argc, char ***argv)
{
	/* Inititialize GTK+ and hildon: */
	hildon_gtk_init (argc, argv);

	if (!g_thread_supported()) {
		g_thread_init (NULL);
	}

	/* Create the hildon application and setup the title: */
	gui_data.program = HILDON_PROGRAM (hildon_program_get_instance ());
	g_set_application_name (APP_NAME);
}


void gui_destroy_main_window() {
	destroy = 1;
	gtk_widget_destroy(gui_data.window);
	gui_data.window = NULL;
	destroy = 0;
	gtk_main_quit();
	while (gtk_events_pending()) gtk_main_iteration();
	signal(SIGINT, SIG_DFL);
}

static inline GtkWindow* get_parent_window() {
	return GTK_WINDOW(gui_data.window);
}

static void set_rom(const char * rom_file)
{
	if (newpackfile) g_free(newpackfile);
	if (!rom_file || strlen(rom_file) == 0) {
		newpackfile = NULL;
		hildon_button_set_value(gui_data.select_rom_btn, _("<no rom selected>"));
		gtk_widget_set_sensitive(gui_data.run_btn, FALSE);
		return;
	}

	newpackfile = g_strdup(rom_file);

	gchar * utf8_filename = g_filename_display_basename(rom_file);
	hildon_button_set_value(gui_data.select_rom_btn, utf8_filename);
	g_free(utf8_filename);

	gtk_widget_set_sensitive(gui_data.run_btn, TRUE);
/*
	current_rom_file_exists = g_file_test(newpackfile,
		G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);

	game_state_update();
	save_clear();
*/
}

static void select_rom_callback(GtkWidget * button, gpointer data)
{
	GtkWidget * dialog;
	GtkFileFilter * filter;
	gchar * filename = NULL;

	filter = gtk_file_filter_new();
	gtk_file_filter_add_pattern(filter, "*.bin");
	gtk_file_filter_add_pattern(filter, "*.cbn");
	gtk_file_filter_add_pattern(filter, "*.img");
	gtk_file_filter_add_pattern(filter, "*.mdf");
	gtk_file_filter_add_pattern(filter, "*.iso");
	gtk_file_filter_add_pattern(filter, "*.BIN");
	gtk_file_filter_add_pattern(filter, "*.CBN");
	gtk_file_filter_add_pattern(filter, "*.IMG");
	gtk_file_filter_add_pattern(filter, "*.MDF");
	gtk_file_filter_add_pattern(filter, "*.ISO");

	dialog = hildon_file_chooser_dialog_new_with_properties(
		get_parent_window(),
		"action", GTK_FILE_CHOOSER_ACTION_OPEN,
		"local-only", TRUE,
		"filter", filter,
		NULL);
	hildon_file_chooser_dialog_set_show_upnp(HILDON_FILE_CHOOSER_DIALOG(dialog),
		FALSE);

/*	if (current_rom_file_exists) {
		// By default open showing the last selected file
		gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(dialog), 
			current_rom_file);
	}
*/
	gtk_widget_show_all(GTK_WIDGET(dialog));
	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK) {
		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
	}

	gtk_widget_destroy(dialog);

	if (filename) {
		set_rom(filename);
		g_free(filename);
	}
}

static void settings_item_callback(GtkWidget * button, gpointer data)
{
	//settings_dialog(get_parent_window());
	unlink(CONFIG_FILE);
}

static void about_item_callback(GtkWidget * button, gpointer data)
{
	about_dialog(get_parent_window());
}

static HildonAppMenu *
create_menu (void)
{
	HildonSizeType button_size = HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH;
	HildonAppMenu *menu = HILDON_APP_MENU (hildon_app_menu_new ());
	GtkWidget *button;
	button = hildon_gtk_button_new (button_size);
	gtk_button_set_label (GTK_BUTTON (button), "Settings…");
	g_signal_connect (G_OBJECT (button), "clicked",
		            G_CALLBACK (settings_item_callback), NULL);
	hildon_app_menu_append (menu, GTK_BUTTON (button));
	button = hildon_gtk_button_new (button_size);
	gtk_button_set_label (GTK_BUTTON (button), "About…");
	g_signal_connect (G_OBJECT (button), "clicked",
		            G_CALLBACK (about_item_callback), NULL);
	hildon_app_menu_append (menu, GTK_BUTTON (button));
	gtk_widget_show_all (GTK_WIDGET (menu));
	return menu;
}

void gui_select_game()
{
	/* Create the window for our application: */
	gui_data.window = hildon_window_new();
	hildon_program_add_window (gui_data.program, HILDON_WINDOW(gui_data.window));

	/* Create and set application menu */
	gui_data.menu = create_menu ();
	hildon_window_set_app_menu (HILDON_WINDOW (gui_data.window), gui_data.menu);

	/* GConf data */
	g_type_init();
	gui_data.gcc = gconf_client_get_default();

	/* Add widgets */
	gui_data.grid = gtk_vbox_new(FALSE, HILDON_MARGIN_DEFAULT);

	/* Select ROM button */
	gui_data.select_rom_btn = HILDON_BUTTON(hildon_button_new_with_text(
		HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_THUMB_HEIGHT,
		HILDON_BUTTON_ARRANGEMENT_VERTICAL,
		_("ROM…"),
		NULL));
	hildon_button_set_alignment(gui_data.select_rom_btn, 0.0f, 0.5f, 0.9f, 0.2f);
	gtk_box_pack_start(GTK_BOX(gui_data.grid), GTK_WIDGET(gui_data.select_rom_btn), FALSE, FALSE, 0);

	/* First row of widgets */
	GtkBox* opt_hbox1 = GTK_BOX(gtk_hbox_new(FALSE, HILDON_MARGIN_DEFAULT));

	gui_data.sound_check =
		HILDON_CHECK_BUTTON(hildon_check_button_new(
			HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT));
	gtk_button_set_label(GTK_BUTTON(gui_data.sound_check), _("Sound"));

	gui_data.display_fps_check =
		HILDON_CHECK_BUTTON(hildon_check_button_new(
			HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT));
	gtk_button_set_label(GTK_BUTTON(gui_data.display_fps_check), _("Display framerate"));

	gtk_box_pack_start_defaults(opt_hbox1, GTK_WIDGET(gui_data.sound_check));
	gtk_box_pack_start_defaults(opt_hbox1, GTK_WIDGET(gui_data.display_fps_check));
	gtk_box_pack_start(GTK_BOX(gui_data.grid), GTK_WIDGET(opt_hbox1), FALSE, FALSE, 0);

	/* Run button */
	gui_data.run_btn = HILDON_BUTTON(hildon_button_new_with_text(
		HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_THUMB_HEIGHT,
		HILDON_BUTTON_ARRANGEMENT_VERTICAL,
		_("Run"),
		NULL));
	hildon_button_set_alignment(gui_data.run_btn, 0.5f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_sensitive(gui_data.run_btn, FALSE);
	gtk_box_pack_start(GTK_BOX(gui_data.grid), GTK_WIDGET(gui_data.run_btn), FALSE, FALSE, 0);

	/* Load current configuration from GConf */
	hildon_check_button_set_active(gui_data.sound_check,
		gconf_client_get_bool(gui_data.gcc, kGConfSound, NULL));
	hildon_check_button_set_active(gui_data.display_fps_check,
		gconf_client_get_bool(gui_data.gcc, kGConfDisplayFramerate, NULL));

	set_rom(gconf_client_get_string(gui_data.gcc, kGConfRomFile, NULL));

	// Connect signals
	g_signal_connect(G_OBJECT(gui_data.window), "delete_event",
					G_CALLBACK(gui_destroy_main_window), NULL);
	g_signal_connect(G_OBJECT(gui_data.select_rom_btn), "clicked",
					G_CALLBACK(select_rom_callback), NULL);
	g_signal_connect(G_OBJECT(gui_data.run_btn), "clicked",
					G_CALLBACK(gui_destroy_main_window), NULL);

	/* catch SIGINT */
	signal(SIGINT, gui_destroy_main_window);
	
	/* Show the main window and start the mainloop */
	gtk_container_add(GTK_CONTAINER (gui_data.window), GTK_WIDGET (gui_data.grid));
	gtk_widget_show_all (GTK_WIDGET (gui_data.window));

	gtk_main();
}

