#include "minimal.h"
#include "profiler.h"

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <SDL_syswm.h>

#ifdef PROFILER_PSX4ALL
#include "timeval.h"
#endif

extern int     psx4all_emulating;

#ifdef __WIN32__
int __errno;
#endif

int gp2x_sdlwrapper_bpp=16;

void		*gp2x_sdlwrapper_screen_pixels=NULL;
SDL_Surface	*gp2x_sdlwrapper_screen=NULL;
SDL_Surface	*hw_screen=NULL;
double		gp2x_sdlwrapper_ticksdivisor=1.0;

unsigned long	gp2x_ticks_per_second = 1000;

#include "font.h"

extern int soundcard;
extern int closing_sound;
extern void init_sound(unsigned rate, int stereo, int bits);
extern void quit_sound(void);

int gp2x_double_buffer=0;

#define REAL_X 800
#define REAL_Y 480
#define BUFFER_X 480
#define BUFFER_Y 240

#ifdef DEBUG
FILE* fdbg;
#endif

void (*gp2x_printfchar)(gp2x_font *f, unsigned char c);

void gp2x_printfchar15(gp2x_font *f, unsigned char c)
{
  unsigned short *dst=&((unsigned short*)sdlscreen->pixels)[f->x+f->y*(sdlscreen->pitch>>1)],w,h=f->h;
//unsigned char  *src=f->data[ (c%16)*f->w + (c/16)*f->h ];
  unsigned char  *src=&f->data[c*10];

 if(f->solid)
         while(h--)
         {
          w=f->wmask;
          while(w)
          {
           if( *src & w ) *dst++=f->fg; else *dst++=f->bg;
           w>>=1;
          }
          src++;

          dst+=(sdlscreen->pitch>>1)-(f->w);
         }
 else
         while(h--)
         {
          w=f->wmask;
          while(w)
          {
           if( *src & w ) *dst=f->fg;
           dst++;
           w>>=1;
          }
          src++;

          dst+=(sdlscreen->pitch>>1)-(f->w);
         }
}

void gp2x_printf(gp2x_font *f, int x, int y, const char *format, ...)
{
 char buffer[4096]; int c; gp2x_font *g=&gp2x_default_font;
 va_list  args;

 va_start(args, format);
 vsprintf(buffer, format, args);

 if(f!=NULL) g=f;

 if(x<0) x=g->x; else g->x=x;
 if(y<0) y=g->y; else g->y=y;

 for(c=0;buffer[c];c++)
 {
  switch(buffer[c])
  {
   case '\b': g->x=x;g->y=y; break;

   case '\n': g->y+=g->h;
   case '\r': g->x=x;
              break;

   default:   gp2x_printfchar(g, (unsigned char)buffer[c]);
              g->x+=g->w;
              break;
  }
 }

 //gp2x_video_flip_single();
}

void gp2x_printf_init(gp2x_font *f, int w, int h, void *data, int fg, int bg, int solid)
{
 gp2x_printfchar=gp2x_printfchar15;
 f->x=f->y=0;
 f->wmask=1<<(w-1);
 f->w=w;
 f->h=h;
 f->data=(unsigned char *)data;
 f->fg=fg;
 f->bg=bg;
 f->solid=solid;
}

SDL_Surface* screen_real;

void gp2x_init(int ticks_per_second, int bpp, int rate, int bits, int stereo, int hz, int solid_font)
{
	SDL_Event e;

#ifdef DEBUG
	fdbg = fopen("debug.txt", "a+");
	fprintf(fdbg, "\n\n");
#endif

	SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK | SDL_INIT_AUDIO | SDL_INIT_NOPARACHUTE);
#ifdef RENDER_DOUBLE
	screen_real = SDL_SetVideoMode(REAL_X, REAL_Y, 16, SDL_DOUBLEBUF|SDL_FULLSCREEN);
	gp2x_sdlwrapper_screen = SDL_CreateRGBSurface(0,

		BUFFER_X, BUFFER_Y, 16, screen_real->format->Rmask,
					  screen_real->format->Gmask,
					  screen_real->format->Bmask,
					  screen_real->format->Amask);

	if(SDL_MUSTLOCK(screen_real)) SDL_LockSurface(screen_real);
#else
	gp2x_sdlwrapper_screen = SDL_SetVideoMode(REAL_X, REAL_Y, 16, SDL_DOUBLEBUF | SDL_FULLSCREEN);
#endif

	if(SDL_MUSTLOCK(sdlscreen)) SDL_LockSurface(sdlscreen);

	SDL_WM_SetCaption("psx4all - SDL Version", "psx4all");

	SDL_SysWMinfo      info;

	SDL_VERSION(&info.version);

	if (SDL_GetWMInfo(&info) == 1) {
		if (info.subsystem == SDL_SYSWM_X11) {

			int one = 1;
			Display *display = info.info.x11.gfxdisplay;
			Window window  = info.info.x11.wmwindow;
			
			XChangeProperty(display, window, XInternAtom (display, "_HILDON_NON_COMPOSITED_WINDOW", False), 
					XA_INTEGER, 32, PropModeReplace, (unsigned char*)&one, 1);

			Atom actions, no_trans;
			actions = XInternAtom (display, "_NET_WM_ALLOWED_ACTIONS", False);
			no_trans = XInternAtom (display, "_HILDON_WM_ACTION_NO_TRANSITIONS", False);
			XChangeProperty (display, window, actions,
					 XA_ATOM, 32, PropModeReplace,
					 (unsigned char *)&no_trans, 1);

		}
	}



	if(gp2x_sdlwrapper_screen == NULL)
	{
		exit(0);
		return;
	}
	gp2x_sdlwrapper_bpp=bpp;
	gp2x_sdlwrapper_screen_pixels=gp2x_sdlwrapper_screen->pixels;

	SDL_EventState(SDL_ACTIVEEVENT,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEMOTION,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEBUTTONDOWN,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEBUTTONUP,SDL_IGNORE);
	SDL_EventState(SDL_SYSWMEVENT,SDL_IGNORE);
	SDL_EventState(SDL_VIDEORESIZE,SDL_IGNORE);
	SDL_EventState(SDL_USEREVENT,SDL_IGNORE);
	SDL_ShowCursor(SDL_DISABLE);

	//init font
	gp2x_printf_init(&gp2x_default_font,6,10,gp2x_fontf,0xFFFF,0x0000,solid_font);

	atexit(gp2x_deinit);
}

void gp2x_change_res(int w, int h)
{
	gp2x_sdlwrapper_screen = SDL_SetVideoMode(w, h, 16, SDL_HWSURFACE);
	SDL_EventState(SDL_ACTIVEEVENT,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEMOTION,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEBUTTONDOWN,SDL_IGNORE);
	SDL_EventState(SDL_MOUSEBUTTONUP,SDL_IGNORE);
	SDL_EventState(SDL_SYSWMEVENT,SDL_IGNORE);
	SDL_EventState(SDL_VIDEORESIZE,SDL_IGNORE);
	SDL_EventState(SDL_USEREVENT,SDL_IGNORE);
	SDL_ShowCursor(SDL_DISABLE);
}

void gp2x_deinit(void)
{
	SDL_Quit();

#ifdef DEBUG
	fclose(fdbg);
#endif
}

unsigned long keystate = 0;

unsigned long gp2x_joystick_read(void)
{
  //events
  SDL_Event event;
  unsigned long ret = keystate;

  while(SDL_PollEvent(&event))
  {
	  switch(event.type)
	  {
		  case SDL_QUIT:
		  	gp2x_deinit(); exit(0);

		  	break;
		  case SDL_KEYDOWN:
		  	switch(event.key.keysym.sym)
		  	{
		  		case SDLK_ESCAPE:
					gp2x_deinit(); exit(0);
					break;

				case SDLK_UP:    ret |= GP2X_UP;    break;
				case SDLK_DOWN:  ret |= GP2X_DOWN;  break;
				case SDLK_LEFT:  ret |= GP2X_LEFT;  break;
				case SDLK_RIGHT: ret |= GP2X_RIGHT; break;

				case SDLK_a: ret |= GP2X_A; break;
				case SDLK_x: ret |= GP2X_B; break;
				case SDLK_s: ret |= GP2X_Y; break;
				case SDLK_z: ret |= GP2X_X; break;

				case SDLK_w: ret |= GP2X_L; break;
				case SDLK_q: ret |= GP2X_VOL_DOWN; break;
				case SDLK_e: ret |= GP2X_R; break;
				case SDLK_r: ret |= GP2X_VOL_UP; break;

				case SDLK_KP_ENTER: ret |= GP2X_START; break;
				case SDLK_SPACE: ret |= GP2X_SELECT; break;

				default: break;
			}
			break;
		case SDL_KEYUP:
		  	switch(event.key.keysym.sym)
		  	{
				case SDLK_UP:    ret &= ~GP2X_UP;    break;
				case SDLK_DOWN:  ret &= ~GP2X_DOWN;  break;
				case SDLK_LEFT:  ret &= ~GP2X_LEFT;  break;
				case SDLK_RIGHT: ret &= ~GP2X_RIGHT; break;

				case SDLK_a: ret &= ~GP2X_A; break;
				case SDLK_x: ret &= ~GP2X_B; break;
				case SDLK_s: ret &= ~GP2X_Y; break;
				case SDLK_z: ret &= ~GP2X_X; break;

				case SDLK_w: ret &= ~GP2X_L; break;
				case SDLK_q: ret &= ~GP2X_VOL_DOWN; break;
				case SDLK_e: ret &= ~GP2X_R; break;
				case SDLK_r: ret &= ~GP2X_VOL_UP; break;

				case SDLK_KP_ENTER: ret &= GP2X_START; break;
				case SDLK_SPACE: ret &= GP2X_SELECT; break;

				default: break;
			}
			break;
		default: break;
	  }
  }

  keystate = ret;

  return ret;
}

void gp2x_video_RGB_clearscreen16(void)
{
  memset(sdlscreen->pixels, 0, sdlscreen->pitch*sdlscreen->h);
}
/*
void gp2x_timer_delay(unsigned long ticks)
{
  SDL_Delay(ticks);
}

void gp2x_timer_delay_raw(unsigned long raws)
{
  //
}

unsigned long gp2x_timer_read(void)
{
  //
}

unsigned long gp2x_timer_raw(void)
{
  //
}
*/
void gp2x_video_flip()
{
	static int x = 0;
	x++;
	if((x&0x1)) return;
	
#ifdef RENDER_DOUBLE
	int i, j;

	for(i=0; i<BUFFER_Y; i++)
	{
		for(j=0; j<320; j++)
		{
			((Uint16*)screen_real->pixels)[80 + REAL_X*i*2 + 2*j] =
			((Uint16*)screen_real->pixels)[80 + REAL_X*i*2 + 2*j + 1] =
			((Uint16*)screen_real->pixels)[80 + REAL_X*(i*2+1) + 2*j] =
			((Uint16*)screen_real->pixels)[80 + REAL_X*(i*2+1) + 2*j + 1] =

//			((Uint16*)screen_real->pixels)[240 + REAL_X*(i+120) + j] = 
			((Uint16*)sdlscreen->pixels)[BUFFER_X*i + j];
		}
	}

	if(SDL_MUSTLOCK(sdlscreen)) SDL_UnlockSurface(sdlscreen);
	if(SDL_MUSTLOCK(screen_real)) SDL_UnlockSurface(screen_real);


	SDL_Flip(screen_real);

	if(SDL_MUSTLOCK(screen_real)) SDL_LockSurface(screen_real);
#else
	if(SDL_MUSTLOCK(sdlscreen)) SDL_UnlockSurface(sdlscreen);

	SDL_Flip(sdlscreen);
#endif

	if(SDL_MUSTLOCK(sdlscreen)) SDL_LockSurface(sdlscreen);
}
