#include "proximityd.h"



int ProximityDaemon::checkProcess()
{
	toKeep.clear();
	counterCheck=0;

	DIR *dir_p;
	struct dirent *dir_entry_p;
	dir_p = opendir("/proc/"); 																
	while(NULL != (dir_entry_p = readdir(dir_p))) 
	{											
		if (strspn(dir_entry_p->d_name, "0123456789") == strlen(dir_entry_p->d_name)) 
		{		 
			int ppid = atoi(dir_entry_p->d_name);
			
			for (int i=0; i<pids.size(); ++i)
			{
				if (ppid==pids[i])
				{
					toKeep.push_back(ppid);
					break;
				}
			}
		}
	}
	pids.swap(toKeep);

	if (pids.size()==0)
	{
		active=0;
		intervalUsec=INTERVAL_IDLE;
	}	
	closedir(dir_p);
	return 0;

}

void ProximityDaemon::listen()
{

	{
		dbus_connection_read_write(connMth, 0);
      		msgMth = dbus_connection_pop_message(connMth);
		

		if (NULL != msgMth)
		{		
		 	if (dbus_message_is_method_call(msgMth, "proximityd.method.change", "Change"))
				handleMethodCall();
		} 
      	}
}

void ProximityDaemon::handleMethodCall()
{


	bool stat = true;
	dbus_uint32_t serial = 0;
		

	if (!dbus_message_iter_init(msgMth, &argsMth))
		std::cout<<"PROXIMITY: Message has no arguments"<<std::endl;
	else if (DBUS_TYPE_STRING != dbus_message_iter_get_arg_type(&argsMth))
		std::cout<<"PROXIMITY: Argument is not string"<<std::endl;
	else
      		dbus_message_iter_get_basic(&argsMth, &paramMth);

	if (!dbus_message_iter_next(&argsMth))
	std::cout<<"PROXIMITY: Message has too few arguments"<<std::endl;
	else if (DBUS_TYPE_INT32 != dbus_message_iter_get_arg_type(&argsMth))
		std::cout<<"PROXIMITY: Argument is not int"<<std::endl;
	else
      		dbus_message_iter_get_basic(&argsMth, &paramMthPid);

	
	
	if (strcmp(paramMth,"turnOff")==0 && paramMthPid!=0)
	{
		turnOff();

	} 

	else if (strcmp(paramMth,"turnOn")==0 && paramMthPid!=0)
	{
		turnOn();
	}
	
	replyMth = dbus_message_new_method_return(msgMth);
		
	dbus_message_iter_init_append(replyMth, &argsMth);
	
	std::string rep = "ERROR";
		
	if (active==0)
	{
		rep = "turnedOff";
	}
	else 
	{
		rep = "turnedOn";
	}

	if (!dbus_message_iter_append_basic(&argsMth, DBUS_TYPE_STRING, &rep)) 
	{
		std::cout<<"PROXIMITY: Out Of Memory"<<std::endl;
		return;
	}
	
	if (!dbus_connection_send(connMth, replyMth, &serial)) 
	{
		std::cout<<"PROXIMITY: Out Of Memory"<<std::endl;
      		return;
	}
	

}


void ProximityDaemon::turnOff()
{
	
	for (int i=0; i<pids.size();++i)
	{
		if (pids[i]==paramMthPid)
		{
			pids.erase(pids.begin()+i);
			break;
		}
	}

	if (pids.size()==0)
	{
		active=0;
		intervalUsec=INTERVAL_IDLE;
	}
	


}


void ProximityDaemon::turnOn()
{
	pids.push_back(paramMthPid);
	active=1;
	intervalUsec=INTERVAL_ACTIVE;
}



void ProximityDaemon::connectToDbusMethod()
{

	dbus_error_init(&errMth);
	connMth = dbus_bus_get_private(DBUS_BUS_SESSION, &errMth);

	if (dbus_error_is_set(&errMth)) 
	{
		std::cout<<"PROXIMITY: Connection Error"<<errMth.message<<std::endl;
		dbus_error_free(&errMth);
	}
	if (NULL == connMth) 
	{
		std::cout<<"PROXIMITY: Connection Null"<<std::endl;
		exit(1);
	}

	retMth = dbus_bus_request_name(connMth, "proximityd.method.change", DBUS_NAME_FLAG_REPLACE_EXISTING , &errMth);
	if (dbus_error_is_set(&errMth)) 
	{
		std::cout<<"PROXIMITY: Name Error"<<errMth.message<<std::endl;
		dbus_error_free(&errMth);
	}
	      
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retMth) 
	{
		std::cout<<"PROXIMITY: Not Primary Owner"<<std::endl;
		exit(1);
	}
	      
	   
	


}


ProximityDaemon::ProximityDaemon()
{

	intervalUsec=INTERVAL_IDLE;
	active=0;
	currentState='n';

	file="/sys/devices/platform/gpio-switch/proximity/state";

	connectToDbusSignal();
	connectToDbusMethod();
	readProx();
	counterCheck=0;
}

ProximityDaemon::~ProximityDaemon()
{

}

void ProximityDaemon::readProx()
{
	if (currentState=='n')
	{
		fp = fopen (file,"r") ;
		currentState = fgetc (fp); 
		fclose (fp);

	}

	 
	while(1)
	{
		listen();
		if (active)
		{
			++counterCheck;
			if (counterCheck==200)
				checkProcess();
	 		readSensor();
		}
		usleep(intervalUsec);
	}


}


void ProximityDaemon::readSensor()
{


	fp = fopen (file,"r") ;
	char ch = fgetc (fp); 
	fclose (fp);
		
	if (ch=='c' && currentState=='o')
	{
		emitState('c');
		currentState=ch;
	}	
	else if (ch=='o' && currentState=='c')
	{
		emitState('o');
		currentState=ch;
	}

}


void ProximityDaemon::emitState(char newState_)
{
	
	const char* sigvalue;
	
	if (newState_=='c')
	{
		sigvalue="closed";
	}
	else 
	{
		 sigvalue="open";
	}
	
	msgSig = dbus_message_new_signal("/proximityd/signal/state", // object name of the signal
		      			"proximityd.signal.state", // interface name of the signal
					"changed"); // name of the signal


	if (NULL == msgSig)
	{
		std::cout<<"PROXIMITY: Message Null"<<std::endl;
		return;
	}

	dbus_message_iter_init_append(msgSig, &argsSig);
	if (!dbus_message_iter_append_basic(&argsSig, DBUS_TYPE_STRING, &sigvalue)) 
	{
		std::cout<<"PROXIMITY: Out of Memory"<<std::endl;
		return;
	}
	   

	if (!dbus_connection_send(connSig, msgSig, &serialSig)) 
	{	
		std::cout<<"PROXIMITY: Out of Memory"<<std::endl;
		return;
	}
	   



}



void ProximityDaemon::connectToDbusSignal()
{
	dbus_error_init(&errSig);
	connSig = dbus_bus_get_private(DBUS_BUS_SESSION, &errSig);
	
	if (dbus_error_is_set(&errSig)) 
	{
		std::cout<<"PROXIMITY: Connection error"<<std::endl;
		dbus_error_free(&errSig);
	}
	
	if (NULL == connSig) 
	{
		exit(1);
	}

	retSig = dbus_bus_request_name(connSig, "proximity.signal.source", DBUS_NAME_FLAG_REPLACE_EXISTING , &errSig);
	
	if (dbus_error_is_set(&errSig)) 
	{
		std::cout<<"PROXIMITY: Name error"<<std::endl;
		dbus_error_free(&errSig);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retSig) 
	{
		exit(1);
	}
	      
	



}



int main(int argc, char **argv)
{
	ProximityDaemon* pd = new ProximityDaemon();
	


	

return 0;
}
