#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include <QLibraryInfo>
#include <QDesktopServices>
#include <QUrl>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    QSettings settings;
    ui->heightBox->setValue(settings.value(PCW_SETTING_HEIGHT, PCW_SETTING_HEIGHT_DEFAULT).toInt());
    ui->widthBox->setValue(settings.value(PCW_SETTING_WIDTH, PCW_SETTING_WIDTH_DEFAULT).toInt());
    ui->spinBoxOpacity->setValue(settings.value(PCW_SETTING_OPACITY, PCW_SETTING_OPACITY_DEFAULT).toInt());
    ui->checkBoxNextProfile->setChecked(settings.value(PCW_SETTING_SHOWNEXTPROFILE, PCW_SETTING_SHOWNEXTPROFILE_DEFAULT).toBool());
    connect(this, SIGNAL(rejected()), this, SLOT(close()));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    QSettings settings;
    if (ui->heightBox->text().isEmpty() || ui->widthBox->text().isEmpty()) {
        this->showInformation(tr("Fields cannot be empty!"));
        return;
    }

    settings.setValue(PCW_SETTING_WIDTH, ui->widthBox->value());
    settings.setValue(PCW_SETTING_HEIGHT, ui->heightBox->value());
    settings.setValue(PCW_SETTING_OPACITY, ui->spinBoxOpacity->value());
    settings.setValue(PCW_SETTING_SHOWNEXTPROFILE, ui->checkBoxNextProfile->isChecked());
    emit settingsChanged();
    this->close();
}

void SettingsDialog::showAbout()
{
    QDialog *aboutDialog = new QDialog(0);
    aboutDialog->setAttribute(Qt::WA_DeleteOnClose);
    aboutDialog->setWindowTitle(tr("About Profile Changer Widget"));
    QLabel *aboutText = new QLabel(aboutDialog);
    QString about;
    about.append(tr("Profile Changer Widget"));
    about.append("\n");
    about.append(tr("Small widget intended to enable an easy change between general and silent profiles."));
    about.append("\n\n");
    about.append(tr("Version:"));
    about.append(" ");
    about.append(QApplication::applicationVersion());
    about.append(", ");
    about.append(QString::fromUtf8("© 2012 Harald Schmitt\n"));
    aboutText->setText(about);
    aboutText->setWordWrap(true);
    QScrollArea *aboutScroll = new QScrollArea(aboutDialog);
    QVBoxLayout *scrollLayout = new QVBoxLayout(aboutScroll);
    scrollLayout->addWidget(aboutText);
    QVBoxLayout *layout = new QVBoxLayout(aboutDialog);
    layout->addWidget(aboutScroll);
    aboutDialog->setLayout(layout);
    aboutDialog->show();
    this->close();
}

void SettingsDialog::checkVersion() {
    QSettings settings;
    QString oldVersion = settings.value(PCW_SETTING_LASTVERSION, PCW_SETTING_LASTVERSION_DEFAULT).toString();
    QString curVersion = QApplication::applicationVersion();
    if(oldVersion != curVersion) {
        settings.setValue(PCW_SETTING_LASTVERSION, curVersion);
        QString tmpInfo;
        if(oldVersion == PCW_SETTING_LASTVERSION_DEFAULT) {
            //Show info for user that have installed the app for the first time.
            tmpInfo.append(tr("Thank you for installing profile changer widget version %1.").arg(curVersion));
        } else {
            //Show update info
            tmpInfo.append(tr("Thank you for updating profile changer widget from version %1 to %2.").arg(oldVersion).arg(curVersion));
        }
        tmpInfo.append("\n");
        tmpInfo.append(tr("Feel free to support my work by testing the application in order to get it to Extras -repository."));
        tmpInfo.append("\n");
        tmpInfo.append(tr("Therefore you can use the \"Feedback\" button."));
        this->showQuestion(tmpInfo);
    }
}

void SettingsDialog::on_buttonAbout_clicked()
{
    this->showAbout();
}

void SettingsDialog::on_buttonQa_clicked()
{
    this->openBrowser("http://maemo.org/packages/view/profile-changer-widget/");
    this->close();
}

void SettingsDialog::on_buttonDonate_clicked()
{
    //TODO
    //this->openBrowser("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=");
    //this->close();
    this->showInformation(tr("Not yet implemented."));
}

void SettingsDialog::on_buttonBox_accepted()
{
    this->accept();
}

void SettingsDialog::on_buttonBox_rejected()
{
    this->close();
}

void SettingsDialog::openBrowser(QString url)
{
    //QDBusMessage msg = QDBusMessage::createMethodCall(
    //    "com.nokia.osso_browser", // --dest
    //    "/com/nokia/osso_browser/request", // destination object path
    //    "com.nokia.osso_browser", // message name (w/o method)
    //    "load_url" // method
    //);
    //msg << url;
    //msg = QDBusConnection::systemBus().call(msg);
    QDesktopServices::openUrl(QUrl(url, QUrl::TolerantMode));
}

void SettingsDialog::showEvent(QShowEvent* event)
{
    QDialog::showEvent(event);
    this->checkVersion();
}
void SettingsDialog::showInformation(QString info)
{
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "org.freedesktop.Notifications", // --dest
        "/org/freedesktop/Notifications", // destination object path
        "org.freedesktop.Notifications", // message name (w/o method)
        "SystemNoteInfoprint" // method
    );
    msg << info;
    msg = QDBusConnection::sessionBus().call(msg);

}

void SettingsDialog::showQuestion(QString info)
{
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "org.freedesktop.Notifications", // --dest
        "/org/freedesktop/Notifications", // destination object path
        "org.freedesktop.Notifications", // message name (w/o method)
        "SystemNoteDialog" // method
    );
    QList<QVariant> args;
    args.append(info);
    args.append(static_cast<quint32>(0));
    args.append("ok");

    msg.setArguments(args);
    msg = QDBusConnection::sessionBus().call(msg);

}
