#include "profilechangerwidget.h"
#include "ui_profilechangerwidget.h"

const QString iconSilent = "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png";
const QString iconGeneral = "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png";

ProfileChangerWidget::ProfileChangerWidget (QWidget *parent) :
QMainWindow(parent, Qt::FramelessWindowHint),
    ui(new Ui::ProfileChangerWidget)
{
    ui->setupUi(this);
    QPalette palette;
    setAttribute(Qt::WA_TranslucentBackground);
    ui->centralWidget->setAttribute(Qt::WA_TranslucentBackground);
    ui->switchButton->setAttribute(Qt::WA_TranslucentBackground);
    palette.setColor(QPalette::Base, Qt::transparent);
    ui->centralWidget->setPalette(palette);
    QSettings settings;
    if (!settings.contains(PCW_SETTING_WIDTH))
        settings.setValue(PCW_SETTING_WIDTH, PCW_SETTING_WIDTH_DEFAULT);
    if (!settings.contains(PCW_SETTING_HEIGHT))
        settings.setValue(PCW_SETTING_HEIGHT, PCW_SETTING_HEIGHT_DEFAULT);
    if (!settings.contains(PCW_SETTING_OPACITY))
        settings.setValue(PCW_SETTING_OPACITY, PCW_SETTING_OPACITY_DEFAULT);
    if (!settings.contains(PCW_SETTING_SHOWNEXTPROFILE))
        settings.setValue(PCW_SETTING_SHOWNEXTPROFILE, PCW_SETTING_SHOWNEXTPROFILE_DEFAULT);
    if (!settings.contains(PCW_SETTING_LASTVERSION))
        settings.setValue(PCW_SETTING_LASTVERSION, PCW_SETTING_LASTVERSION_DEFAULT);

    connect(ui->switchButton, SIGNAL(clicked()), this, SLOT(onChangeProfileClicked()));
    this->reloadSettings();
}

ProfileChangerWidget::~ProfileChangerWidget()
{
    delete ui;
}

QString ProfileChangerWidget::getProfileName() {
    QString profileName = "";
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "get_profile" // method
    );
    msg = QDBusConnection::sessionBus().call(msg);

    if (msg.type() == QDBusMessage::ErrorMessage) {
        QErrorMessage* err = new QErrorMessage();
        err->showMessage(msg.errorMessage());
    } else if(msg.type() == QDBusMessage::ReplyMessage) {
        profileName = msg.arguments().at(0).toString();
    }
    return profileName;
}

void ProfileChangerWidget::setProfile(QString profileName) {
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "set_profile" // method
    );
    msg << profileName;
    msg = QDBusConnection::sessionBus().call(msg);
}
void ProfileChangerWidget::refreshIcon() {
    QString profileName = this->getProfileName();

    if ( profileName == "silent" ) {
        if(this->showNextProfile == true) {
            showIconGeneral();
        } else {
            showIconSilent(); 
        }
    } else {
        if(this->showNextProfile == false) {
            showIconGeneral();
        } else {
            showIconSilent(); 
        }
    }
}
    

void ProfileChangerWidget::showIconSilent() {
    ui->switchButton->setIcon(QIcon(iconSilent));    
}

void ProfileChangerWidget::showIconGeneral() {
    ui->switchButton->setIcon(QIcon(iconGeneral));    
}

void ProfileChangerWidget::switchProfile() {
    QString profileName = this->getProfileName();
    if ( profileName == "silent" ) {
        this->setProfile("general");
    }
    else {
        this->setProfile("silent");
    }
}  

void ProfileChangerWidget::onChangeProfileClicked() {
    switchProfile();
    refreshIcon();
}

void ProfileChangerWidget::onShowSettingsDialog()
{
    SettingsDialog *dialog = new SettingsDialog(0);
    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(reloadSettings()));
    dialog->show();
}

void ProfileChangerWidget::onHomeScreenChanged(bool isOnCurrentHomescreen)
{
    if(isOnCurrentHomescreen)
        refreshIcon();
}

void ProfileChangerWidget::reloadSettings()
{
    QSettings settings;
    this->showNextProfile = settings.value(PCW_SETTING_SHOWNEXTPROFILE, PCW_SETTING_SHOWNEXTPROFILE_DEFAULT).toBool();
    this->setGeometry(this->x(), this->y(),
                      settings.value(PCW_SETTING_WIDTH, PCW_SETTING_WIDTH_DEFAULT).toInt(),
                      settings.value(PCW_SETTING_HEIGHT, PCW_SETTING_HEIGHT_DEFAULT).toInt());
    ui->switchButton->setStyleSheet("background-color: rgba(0, 0, 0, " + settings.value(PCW_SETTING_OPACITY, PCW_SETTING_OPACITY_DEFAULT).toString() + "%); \
     border-style: outset; \
     border-width: 0px; \
     border-radius: 10px; \
     border-color: rgba(0, 0, 0, " + settings.value(PCW_SETTING_OPACITY, PCW_SETTING_OPACITY_DEFAULT).toString() + "%); \
     font: bold 14px; \
     min-width: 48px; \
     width: " + settings.value(PCW_SETTING_WIDTH, PCW_SETTING_WIDTH_DEFAULT).toString() + "px; \
     height: " + settings.value(PCW_SETTING_HEIGHT, PCW_SETTING_HEIGHT_DEFAULT).toString() + "px; \
     padding: 6px;");
    this->refreshIcon();
}

