#include <QtGui/QApplication>
#include <QLibraryInfo>
#include <QLocale>
#include <QTranslator>
#include "profilechangerwidget.h"

int main(int argc, char *argv[])
{
    QApplication::setOrganizationName("hschmitt");
    QApplication::setApplicationName("profile-changer-widget");
    QApplication::setApplicationVersion("0.8");
    // enforce native graphics system for now due to a bug in transparency handling
    // you can remove this line if you only target PR 1.2
//    QApplication::setGraphicsSystem("native");

    QApplication app(argc, argv);

    //Translate it
    QTranslator qtTranslator;
    qtTranslator.load(QLatin1String("qt_") + QLocale::system().name(),
            QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    QTranslator pcwTranslator;
    pcwTranslator.load("profilechangerwidget_" + QLocale::system().name(), "/opt/profilechangerwidget");
    app.installTranslator(&pcwTranslator);

    ProfileChangerWidget w;

    QMaemo5HomescreenAdaptor adaptor(&w);
    adaptor.setSettingsAvailable(true);
    QObject::connect(&adaptor, SIGNAL(settingsRequested()), &w, SLOT(onShowSettingsDialog()));
    QObject::connect(&adaptor, SIGNAL(homescreenChanged(bool)), &w, SLOT(onHomeScreenChanged(bool)));

    w.show();

    return app.exec();
}

