#include <libprofile.h>

#include "profilechangerwidget.h"
#include "ui_profilechangerwidget.h"

using namespace std;

const QString iconSilent = "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png";
const QString iconGeneral = "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png";

ProfileChangerWidget::ProfileChangerWidget (QWidget *parent) :
QMainWindow(parent),
    ui(new Ui::ProfileChangerWidget)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);
    if (!QSettings().contains("profilechangerwidget/width"))
        QSettings().setValue("profilechangerwidget/width", 48);
    if (!QSettings().contains("profilechangerwidget/height"))
        QSettings().setValue("profilechangerwidget/height", 48);

    connect(ui->switchButton, SIGNAL(clicked()), this, SLOT(changeProfile()));
    this->reloadSettings();
}

ProfileChangerWidget::~ProfileChangerWidget()
{
    delete ui;
}

void ProfileChangerWidget::refreshIcon() {
    if ( string( profile_get_profile() ) == "silent" ) {
        showIconSilent(); 
    }
    else {
        showIconGeneral();
    }
}
    

void ProfileChangerWidget::showIconSilent() {
    ui->switchButton->setIcon(QIcon(iconSilent));    
}

void ProfileChangerWidget::showIconGeneral() {
    ui->switchButton->setIcon(QIcon(iconGeneral));    
}

void ProfileChangerWidget::switchProfile() {
    if ( string(profile_get_profile()) == "silent" ) {
        profile_set_profile("general");
    }
    else {
        profile_set_profile("silent");
    }
}  

void ProfileChangerWidget::onChangeProfileClicked() {
    switchProfile();
    refreshIcon();
}

void ProfileChangerWidget::onShowSettingsDialog()
{
    SettingsDialog *dialog = new SettingsDialog(0);
    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(reloadSettings()));
    dialog->show();
}

void ProfileChangerWidget::reloadSettings()
{
    this->setGeometry(this->x(), this->y(),
                      QSettings().value("profilechangerwidget/width").toInt(),
                      QSettings().value("profilechangerwidget/height").toInt());
    this->refreshIcon();
}

