#ifndef _PROFILECHANGERWIDGET_H_
#define _PROFILECHANGERWIDGET_H_

#include <QWidget>
//#include "irctrl.h"

class IEngine;
class QGridLayout;
class QToolButton;
class QSettings;

class ProfileChangerWidget : public QWidget
{
    Q_OBJECT

public:
    ProfileChangerWidget (QWidget *parent = NULL);
    ~ProfileChangerWidget();

    QSize minimumSizeHint() const {
        return QSize(90, 90);
    }

    QSize sizeHint() const {
        return QSize(90, 90);
    }

//public slots:
//    void showSettingsDialog();

private slots:
    void changeProfile();

protected:
    void paintEvent(QPaintEvent *event);

private:
    void resize();

private:
    void switchProfile();
    void changeIcon(unsigned index);
    void refreshIcon();
    
    QSettings *settings;
    static const int BUTTON_COUNT = 1;
    QToolButton *button;
    unsigned time;
    QGridLayout *layout;
    QToolButton *buttons[BUTTON_COUNT];
};

#endif

